/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.vault.persistence;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultService;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractSlice;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class PersistentVaultService
implements VaultService {
    private static final IgniteLogger LOG;
    private final ExecutorService threadPool = Executors.newFixedThreadPool(4, (ThreadFactory)new NamedThreadFactory("vault", LOG));
    private final InFlightFutures futureTracker = new InFlightFutures();
    private final Options options = PersistentVaultService.options();
    private volatile RocksDB db;
    private final Path path;

    public PersistentVaultService(Path path) {
        this.path = path;
    }

    private static Options options() {
        return new Options().setCreateIfMissing(true).setCompressionType(CompressionType.LZ4_COMPRESSION).setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION).setLevelCompactionDynamicLevelBytes(true).setBytesPerSync(0x100000L).setCompactionPriority(CompactionPriority.MinOverlappingRatio).setTableFormatConfig((TableFormatConfig)new BlockBasedTableConfig().setBlockSize(16384L).setCacheIndexAndFilterBlocks(true).setPinL0FilterAndIndexBlocksInCache(true).setFormatVersion(5).setFilterPolicy((Filter)new BloomFilter(10.0, false)).setOptimizeFiltersForMemory(true));
    }

    @Override
    public void start() {
        try {
            this.db = RocksDB.open((Options)this.options, (String)this.path.toString());
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException((Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.futureTracker.cancelInFlightFutures();
        IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.options, this.db});
    }

    @Override
    public CompletableFuture<VaultEntry> get(ByteArray key) {
        return this.supplyAsync(() -> {
            try {
                byte[] value = this.db.get(key.bytes());
                return value == null ? null : new VaultEntry(key, value);
            }
            catch (RocksDBException e) {
                throw new IgniteInternalException("Unable to read data from RocksDB", (Throwable)e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> put(ByteArray key, byte @Nullable [] val) {
        return this.runAsync(() -> {
            try {
                if (val == null) {
                    this.db.delete(key.bytes());
                } else {
                    this.db.put(key.bytes(), val);
                }
            }
            catch (RocksDBException e) {
                throw new IgniteInternalException("Unable to write data to RocksDB", (Throwable)e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> remove(ByteArray key) {
        return this.runAsync(() -> {
            try {
                this.db.delete(key.bytes());
            }
            catch (RocksDBException e) {
                throw new IgniteInternalException("Unable to remove data to RocksDB", (Throwable)e);
            }
        });
    }

    @Override
    public Cursor<VaultEntry> range(ByteArray fromKey, ByteArray toKey) {
        final ReadOptions readOpts = new ReadOptions();
        final Slice upperBound = new Slice(toKey.bytes());
        readOpts.setIterateUpperBound((AbstractSlice)upperBound);
        RocksIterator it = this.db.newIterator(readOpts);
        it.seek(fromKey.bytes());
        return new RocksIteratorAdapter<VaultEntry>(it){

            protected VaultEntry decodeEntry(byte[] key, byte[] value) {
                return new VaultEntry(new ByteArray(key), value);
            }

            public void close() throws Exception {
                super.close();
                IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{upperBound, readOpts});
            }
        };
    }

    @Override
    public CompletableFuture<Void> putAll(Map<ByteArray, byte[]> vals) {
        return this.runAsync(() -> {
            try (WriteBatch writeBatch = new WriteBatch();
                 WriteOptions writeOpts = new WriteOptions();){
                for (Map.Entry entry : vals.entrySet()) {
                    if (entry.getValue() == null) {
                        writeBatch.delete(((ByteArray)entry.getKey()).bytes());
                        continue;
                    }
                    writeBatch.put(((ByteArray)entry.getKey()).bytes(), (byte[])entry.getValue());
                }
                this.db.write(writeOpts, writeBatch);
            }
            catch (RocksDBException e) {
                throw new IgniteInternalException("Unable to write data to RocksDB", (Throwable)e);
            }
        });
    }

    private <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        CompletableFuture<T> future = CompletableFuture.supplyAsync(supplier, this.threadPool);
        this.futureTracker.registerFuture(future);
        return future;
    }

    private CompletableFuture<Void> runAsync(Runnable runnable) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(runnable, this.threadPool);
        this.futureTracker.registerFuture(future);
        return future;
    }

    static {
        RocksDB.loadLibrary();
        LOG = Loggers.forClass(PersistentVaultService.class);
    }
}

