/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.exception.handler;

import java.util.concurrent.TimeoutException;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElement;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;

public class TimeoutExceptionHandler
implements ExceptionHandler<TimeoutException> {
    private static final IgniteLogger LOG = Loggers.forClass(TimeoutExceptionHandler.class);

    @Override
    public int handle(ExceptionWriter err, TimeoutException e) {
        LOG.error("Timeout exception", (Throwable)e);
        err.write(ErrorUiComponent.builder().header("The command is running for too long", new UiElement[0]).details(e.getMessage(), new UiElement[0]).build().render());
        return 1;
    }

    @Override
    public Class<TimeoutException> applicableException() {
        return TimeoutException.class;
    }
}

