/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl;

import java.net.ConnectException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.TopologyEventHandler;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.error.InvokeTimeoutException;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.error.RemotingException;
import org.apache.ignite.raft.jraft.option.RpcOptions;
import org.apache.ignite.raft.jraft.rpc.ClientService;
import org.apache.ignite.raft.jraft.rpc.InvokeCallback;
import org.apache.ignite.raft.jraft.rpc.InvokeContext;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RpcClient;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.RpcResponseClosure;
import org.apache.ignite.raft.jraft.rpc.impl.FutureImpl;
import org.apache.ignite.raft.jraft.util.Endpoint;
import org.apache.ignite.raft.jraft.util.Utils;
import org.apache.ignite.raft.jraft.util.concurrent.ConcurrentHashSet;
import org.apache.ignite.raft.jraft.util.internal.ThrowUtil;

public abstract class AbstractClientService
implements ClientService,
TopologyEventHandler {
    protected static final IgniteLogger LOG = Loggers.forClass(AbstractClientService.class);
    protected volatile RpcClient rpcClient;
    protected ExecutorService rpcExecutor;
    protected RpcOptions rpcOptions;
    protected Set<String> readyAddresses = new ConcurrentHashSet<String>();

    public RpcClient getRpcClient() {
        return this.rpcClient;
    }

    @Override
    public synchronized boolean init(RpcOptions rpcOptions) {
        if (this.rpcClient != null) {
            return true;
        }
        this.rpcOptions = rpcOptions;
        return this.initRpcClient(this.rpcOptions.getRpcProcessorThreadPoolSize());
    }

    public void onAppeared(ClusterNode member) {
    }

    public void onDisappeared(ClusterNode member) {
        this.readyAddresses.remove(member.address().toString());
    }

    protected void configRpcClient(RpcClient rpcClient) {
        rpcClient.registerConnectEventListener(this);
    }

    protected boolean initRpcClient(int rpcProcessorThreadPoolSize) {
        this.rpcClient = this.rpcOptions.getRpcClient();
        this.configRpcClient(this.rpcClient);
        this.rpcClient.init(null);
        this.rpcExecutor = this.rpcOptions.getClientExecutor();
        return true;
    }

    @Override
    public synchronized void shutdown() {
        if (this.rpcClient != null) {
            this.rpcClient.shutdown();
            this.rpcClient = null;
        }
    }

    @Override
    public boolean connect(Endpoint endpoint) {
        try {
            return this.connectAsync(endpoint).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted while connecting to {}, exception: {}.", new Object[]{endpoint, e.getMessage()});
        }
        catch (ExecutionException e) {
            LOG.error("Fail to connect {}, exception: {}.", new Object[]{endpoint, e.getMessage()});
        }
        return false;
    }

    @Override
    public CompletableFuture<Boolean> connectAsync(Endpoint endpoint) {
        RpcClient rc = this.rpcClient;
        if (rc == null) {
            throw new IllegalStateException("Client service is uninitialized.");
        }
        if (this.readyAddresses.contains(endpoint.toString())) {
            return CompletableFuture.completedFuture(true);
        }
        RpcRequests.PingRequest req = this.rpcOptions.getRaftMessagesFactory().pingRequest().sendTimestamp(System.currentTimeMillis()).build();
        CompletableFuture<Message> fut = this.invokeWithDone(endpoint, req, null, null, this.rpcOptions.getRpcConnectTimeoutMs(), this.rpcExecutor);
        return fut.thenApply(msg -> {
            RpcRequests.ErrorResponse resp = (RpcRequests.ErrorResponse)msg;
            if (resp != null && resp.errorCode() == 0) {
                this.readyAddresses.add(endpoint.toString());
                return true;
            }
            return false;
        });
    }

    @Override
    public <T extends Message> CompletableFuture<Message> invokeWithDone(Endpoint endpoint, Message request, RpcResponseClosure<T> done, int timeoutMs) {
        return this.invokeWithDone(endpoint, request, done, timeoutMs, this.rpcExecutor);
    }

    public <T extends Message> CompletableFuture<Message> invokeWithDone(Endpoint endpoint, Message request, RpcResponseClosure<T> done, int timeoutMs, Executor rpcExecutor) {
        return this.invokeWithDone(endpoint, request, null, done, timeoutMs, rpcExecutor);
    }

    public <T extends Message> CompletableFuture<Message> invokeWithDone(Endpoint endpoint, Message request, InvokeContext ctx, RpcResponseClosure<T> done, int timeoutMs) {
        return this.invokeWithDone(endpoint, request, ctx, done, timeoutMs, this.rpcExecutor);
    }

    public <T extends Message> CompletableFuture<Message> invokeWithDone(final Endpoint endpoint, final Message request, InvokeContext ctx, final RpcResponseClosure<T> done, int timeoutMs, Executor rpcExecutor) {
        RpcClient rc = this.rpcClient;
        final FutureImpl<Message> future = new FutureImpl<Message>();
        final Executor currExecutor = rpcExecutor != null ? rpcExecutor : this.rpcExecutor;
        try {
            if (rc == null) {
                future.completeExceptionally(new IllegalStateException("Client service is uninitialized."));
                Utils.runClosureInExecutor(currExecutor, done, new Status(RaftError.EINTERNAL, "Client service is uninitialized.", new Object[0]));
                return future;
            }
            return rc.invokeAsync(endpoint, request, ctx, new InvokeCallback(){

                @Override
                public void complete(Object result, Throwable err) {
                    if (err == null) {
                        Message msg;
                        Status status = Status.OK();
                        if (result instanceof RpcRequests.ErrorResponse) {
                            status = AbstractClientService.handleErrorResponse((RpcRequests.ErrorResponse)result);
                            msg = (Message)result;
                        } else {
                            msg = (Message)result;
                        }
                        if (done != null) {
                            try {
                                if (status.isOk()) {
                                    done.setResponse(msg);
                                }
                                done.run(status);
                            }
                            catch (Throwable t) {
                                LOG.error("Fail to run RpcResponseClosure, the request is {}.", t, new Object[]{request});
                            }
                        }
                        if (!future.isDone()) {
                            future.complete(msg);
                        }
                    } else {
                        if (ThrowUtil.hasCause(err, null, ConnectException.class)) {
                            AbstractClientService.this.readyAddresses.remove(endpoint.toString());
                        }
                        if (done != null) {
                            try {
                                done.run(new Status(err instanceof InvokeTimeoutException ? RaftError.ETIMEDOUT : RaftError.EINTERNAL, "RPC exception:" + err.getMessage(), new Object[0]));
                            }
                            catch (Throwable t) {
                                LOG.error("Fail to run RpcResponseClosure, the request is {}.", t, new Object[]{request});
                            }
                        }
                        if (!future.isDone()) {
                            future.completeExceptionally(err);
                        }
                    }
                }

                @Override
                public Executor executor() {
                    return currExecutor;
                }
            }, timeoutMs <= 0 ? (long)this.rpcOptions.getRpcDefaultTimeout() : (long)timeoutMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            future.completeExceptionally(e);
            Utils.runClosureInExecutor(currExecutor, done, new Status(RaftError.EINTR, "Sending rpc was interrupted", new Object[0]));
        }
        catch (RemotingException e) {
            future.completeExceptionally(e);
            Utils.runClosureInExecutor(currExecutor, done, new Status(RaftError.EINTERNAL, "Fail to send a RPC request:" + e.getMessage(), new Object[0]));
        }
        return future;
    }

    private static Status handleErrorResponse(RpcRequests.ErrorResponse eResp) {
        Status status = new Status();
        status.setCode(eResp.errorCode());
        status.setErrorMsg(eResp.errorMsg());
        return status;
    }
}

