/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp.agg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.Accumulator;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.Accumulators;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.Primitives;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class AccumulatorsFactory<RowT>
implements Supplier<List<AccumulatorWrapper<RowT>>> {
    private static final LoadingCache<Pair<RelDataType, RelDataType>, Function<Object, Object>> CACHE = Caffeine.newBuilder().build(AccumulatorsFactory::cast0);
    private final ExecutionContext<RowT> ctx;
    private final AggregateType type;
    private final RelDataType inputRowType;
    private final List<WrapperPrototype> prototypes;

    private static Function<Object, Object> cast(RelDataType from, RelDataType to) {
        assert (!from.isStruct());
        assert (!to.isStruct());
        return AccumulatorsFactory.cast((Pair<RelDataType, RelDataType>)Pair.of((Object)from, (Object)to));
    }

    private static Function<Object, Object> cast(Pair<RelDataType, RelDataType> types) {
        return (Function)CACHE.get(types);
    }

    private static Function<Object, Object> cast0(Pair<RelDataType, RelDataType> types) {
        IgniteTypeFactory typeFactory = Commons.typeFactory();
        RelDataType from = (RelDataType)types.left;
        RelDataType to = (RelDataType)types.right;
        Class fromType = Primitives.wrap((Class)typeFactory.getJavaClass(from));
        Class toType = Primitives.wrap((Class)typeFactory.getJavaClass(to));
        if (toType.isAssignableFrom(fromType)) {
            return Function.identity();
        }
        if (Void.class == toType) {
            return o -> null;
        }
        return AccumulatorsFactory.compileCast(typeFactory, from, to);
    }

    private static Function<Object, Object> compileCast(IgniteTypeFactory typeFactory, RelDataType from, RelDataType to) {
        RelDataType rowType = TypeUtils.createRowType(typeFactory, from);
        ParameterExpression in = Expressions.parameter(Object.class, (String)"in");
        RexToLixTranslator.InputGetterImpl getter = new RexToLixTranslator.InputGetterImpl(List.of(Pair.of((Object)EnumUtils.convert((Expression)in, Object.class, (Type)typeFactory.getJavaClass(from)), (Object)PhysTypeImpl.of((JavaTypeFactory)typeFactory, (RelDataType)rowType, (JavaRowFormat)JavaRowFormat.SCALAR, (boolean)false))));
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        RexProgramBuilder programBuilder = new RexProgramBuilder(rowType, builder);
        RexNode cast = builder.makeCast(to, (RexNode)builder.makeInputRef(from, 0));
        programBuilder.addProject(cast, null);
        RexProgram program = programBuilder.getProgram();
        BlockBuilder list = new BlockBuilder();
        List projects = RexToLixTranslator.translateProjects((RexProgram)program, (JavaTypeFactory)typeFactory, (SqlConformance)SqlConformanceEnum.DEFAULT, (BlockBuilder)list, null, (Expression)DataContext.ROOT, (RexToLixTranslator.InputGetter)getter, null);
        list.add((Expression)projects.get(0));
        MethodDeclaration decl = Expressions.methodDecl((int)1, Object.class, (String)"apply", List.of(in), (BlockStatement)list.toBlock());
        return Commons.compile(CastFunction.class, Expressions.toString(List.of(decl), (String)"\n", (boolean)false));
    }

    public AccumulatorsFactory(ExecutionContext<RowT> ctx, AggregateType type, List<AggregateCall> aggCalls, RelDataType inputRowType) {
        this.ctx = ctx;
        this.type = type;
        this.inputRowType = inputRowType;
        this.prototypes = Commons.transform(aggCalls, x$0 -> new WrapperPrototype((AggregateCall)x$0));
    }

    @Override
    public List<AccumulatorWrapper<RowT>> get() {
        return Commons.transform(this.prototypes, WrapperPrototype::get);
    }

    private final class AccumulatorWrapperImpl
    implements AccumulatorWrapper<RowT> {
        private final Accumulator accumulator;
        private final Function<Object[], Object[]> inAdapter;
        private final Function<Object, Object> outAdapter;
        private final List<Integer> argList;
        private final int filterArg;
        private final boolean ignoreNulls;
        private final RowHandler<RowT> handler;

        AccumulatorWrapperImpl(Accumulator accumulator, AggregateCall call, Function<Object[], Object[]> inAdapter, Function<Object, Object> outAdapter) {
            this.accumulator = accumulator;
            this.inAdapter = inAdapter;
            this.outAdapter = outAdapter;
            this.argList = call.getArgList();
            this.ignoreNulls = call.ignoreNulls();
            this.filterArg = call.hasFilter() ? call.filterArg : -1;
            this.handler = AccumulatorsFactory.this.ctx.rowHandler();
        }

        @Override
        public void add(RowT row) {
            assert (AccumulatorsFactory.this.type != AggregateType.REDUCE);
            if (this.filterArg >= 0 && Boolean.TRUE != this.handler.get(this.filterArg, row)) {
                return;
            }
            Object[] args = new Object[this.argList.size()];
            for (int i = 0; i < this.argList.size(); ++i) {
                args[i] = this.handler.get(this.argList.get(i), row);
                if (!this.ignoreNulls || args[i] != null) continue;
                return;
            }
            this.accumulator.add(this.inAdapter.apply(args));
        }

        @Override
        public Object end() {
            assert (AccumulatorsFactory.this.type != AggregateType.MAP);
            return this.outAdapter.apply(this.accumulator.end());
        }

        @Override
        public void apply(Accumulator accumulator) {
            assert (AccumulatorsFactory.this.type == AggregateType.REDUCE);
            this.accumulator.apply(accumulator);
        }

        @Override
        public Accumulator accumulator() {
            assert (AccumulatorsFactory.this.type == AggregateType.MAP);
            return this.accumulator;
        }
    }

    private final class WrapperPrototype
    implements Supplier<AccumulatorWrapper<RowT>> {
        private Supplier<Accumulator> accFactory;
        private final AggregateCall call;
        private Function<Object[], Object[]> inAdapter;
        private Function<Object, Object> outAdapter;

        private WrapperPrototype(AggregateCall call) {
            this.call = call;
        }

        @Override
        public AccumulatorWrapper<RowT> get() {
            Accumulator accumulator = this.accumulator();
            return new AccumulatorWrapperImpl(accumulator, this.call, this.inAdapter, this.outAdapter);
        }

        @NotNull
        private Accumulator accumulator() {
            if (this.accFactory != null) {
                return this.accFactory.get();
            }
            this.accFactory = Accumulators.accumulatorFactory(this.call);
            Accumulator accumulator = this.accFactory.get();
            this.inAdapter = this.createInAdapter(accumulator);
            this.outAdapter = this.createOutAdapter(accumulator);
            return accumulator;
        }

        @NotNull
        private Function<Object[], Object[]> createInAdapter(Accumulator accumulator) {
            if (AccumulatorsFactory.this.type == AggregateType.REDUCE || CollectionUtils.nullOrEmpty((Collection)this.call.getArgList())) {
                return Function.identity();
            }
            List<RelDataType> inTypes = SqlTypeUtil.projectTypes((RelDataType)AccumulatorsFactory.this.inputRowType, (List)this.call.getArgList());
            List<RelDataType> outTypes = accumulator.argumentTypes(AccumulatorsFactory.this.ctx.getTypeFactory());
            if (this.call.getArgList().size() > outTypes.size()) {
                throw new AssertionError((Object)("Unexpected number of arguments: expected=" + outTypes.size() + ", actual=" + inTypes.size()));
            }
            if (this.call.ignoreNulls()) {
                inTypes = Commons.transform(inTypes, this::nonNull);
            }
            final List<Function> casts = Commons.transform(Pair.zip((List)inTypes, outTypes), x$0 -> AccumulatorsFactory.cast((Pair<RelDataType, RelDataType>)x$0));
            return new Function<Object[], Object[]>(){

                @Override
                public Object[] apply(Object[] args) {
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = ((Function)casts.get(i)).apply(args[i]);
                    }
                    return args;
                }
            };
        }

        @NotNull
        private Function<Object, Object> createOutAdapter(Accumulator accumulator) {
            if (AccumulatorsFactory.this.type == AggregateType.MAP) {
                return Function.identity();
            }
            RelDataType inType = accumulator.returnType(AccumulatorsFactory.this.ctx.getTypeFactory());
            RelDataType outType = this.call.getType();
            return AccumulatorsFactory.cast(inType, outType);
        }

        private RelDataType nonNull(RelDataType type) {
            return AccumulatorsFactory.this.ctx.getTypeFactory().createTypeWithNullability(type, false);
        }
    }

    public static interface CastFunction
    extends Function<Object, Object> {
        @Override
        public Object apply(Object var1);
    }
}

