/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteMapIntersect;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteMapMinus;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteReduceIntersect;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteReduceMinus;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSingleIntersect;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSingleMinus;
import org.apache.ignite.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;

public class SetOpConverterRule {
    public static final RelOptRule SINGLE_MINUS = new SingleMinusConverterRule();
    public static final RelOptRule SINGLE_INTERSECT = new SingleIntersectConverterRule();
    public static final RelOptRule MAP_REDUCE_MINUS = new MapReduceMinusConverterRule();
    public static final RelOptRule MAP_REDUCE_INTERSECT = new MapReduceIntersectConverterRule();

    private SetOpConverterRule() {
    }

    private static class MapReduceIntersectConverterRule
    extends MapReduceSetOpConverterRule<LogicalIntersect> {
        MapReduceIntersectConverterRule() {
            super(LogicalIntersect.class, "MapReduceIntersectConverterRule");
        }

        @Override
        PhysicalNode createMapNode(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
            return new IgniteMapIntersect(cluster, traits, inputs, all);
        }

        @Override
        PhysicalNode createReduceNode(RelOptCluster cluster, RelTraitSet traits, RelNode input, boolean all, RelDataType rowType) {
            return new IgniteReduceIntersect(cluster, traits, input, all, rowType);
        }
    }

    private static class MapReduceMinusConverterRule
    extends MapReduceSetOpConverterRule<LogicalMinus> {
        MapReduceMinusConverterRule() {
            super(LogicalMinus.class, "MapReduceMinusConverterRule");
        }

        @Override
        PhysicalNode createMapNode(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
            return new IgniteMapMinus(cluster, traits, inputs, all);
        }

        @Override
        PhysicalNode createReduceNode(RelOptCluster cluster, RelTraitSet traits, RelNode input, boolean all, RelDataType rowType) {
            return new IgniteReduceMinus(cluster, traits, input, all, rowType);
        }
    }

    private static abstract class MapReduceSetOpConverterRule<T extends SetOp>
    extends AbstractIgniteConverterRule<T> {
        MapReduceSetOpConverterRule(Class<T> cls, String desc) {
            super(cls, desc);
        }

        abstract PhysicalNode createMapNode(RelOptCluster var1, RelTraitSet var2, List<RelNode> var3, boolean var4);

        abstract PhysicalNode createReduceNode(RelOptCluster var1, RelTraitSet var2, RelNode var3, boolean var4, RelDataType var5);

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, T setOp) {
            RelOptCluster cluster = setOp.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            List inputs = Util.transform((List)setOp.getInputs(), rel -> MapReduceSetOpConverterRule.convert((RelNode)rel, (RelTraitSet)inTrait));
            PhysicalNode map = this.createMapNode(cluster, outTrait, inputs, ((SetOp)setOp).all);
            return this.createReduceNode(cluster, outTrait.replace((RelTrait)IgniteDistributions.single()), MapReduceSetOpConverterRule.convert((RelNode)map, (RelTraitSet)inTrait.replace((RelTrait)IgniteDistributions.single())), ((SetOp)setOp).all, cluster.getTypeFactory().leastRestrictive(Util.transform((List)inputs, RelNode::getRowType)));
        }
    }

    private static class SingleIntersectConverterRule
    extends SingleSetOpConverterRule<LogicalIntersect> {
        SingleIntersectConverterRule() {
            super(LogicalIntersect.class, "SingleIntersectConverterRule");
        }

        @Override
        PhysicalNode createNode(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
            return new IgniteSingleIntersect(cluster, traits, inputs, all);
        }
    }

    private static class SingleMinusConverterRule
    extends SingleSetOpConverterRule<LogicalMinus> {
        SingleMinusConverterRule() {
            super(LogicalMinus.class, "SingleMinusConverterRule");
        }

        @Override
        PhysicalNode createNode(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
            return new IgniteSingleMinus(cluster, traits, inputs, all);
        }
    }

    private static abstract class SingleSetOpConverterRule<T extends SetOp>
    extends AbstractIgniteConverterRule<T> {
        SingleSetOpConverterRule(Class<T> cls, String desc) {
            super(cls, desc);
        }

        abstract PhysicalNode createNode(RelOptCluster var1, RelTraitSet var2, List<RelNode> var3, boolean var4);

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, T setOp) {
            RelOptCluster cluster = setOp.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            List inputs = Util.transform((List)setOp.getInputs(), rel -> SingleSetOpConverterRule.convert((RelNode)rel, (RelTraitSet)inTrait));
            return this.createNode(cluster, outTrait, inputs, ((SetOp)setOp).all);
        }
    }
}

