/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.index;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.row.InternalTuple;
import org.apache.ignite.internal.storage.index.SortedIndexDescriptor;

public class BinaryTupleComparator
implements Comparator<ByteBuffer> {
    private final SortedIndexDescriptor descriptor;

    public BinaryTupleComparator(SortedIndexDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public int compare(ByteBuffer buffer1, ByteBuffer buffer2) {
        assert (buffer1.order() == ByteOrder.LITTLE_ENDIAN);
        assert (buffer2.order() == ByteOrder.LITTLE_ENDIAN);
        boolean isBuffer1Prefix = BinaryTupleComparator.isFlagSet(buffer1, 8);
        boolean isBuffer2Prefix = BinaryTupleComparator.isFlagSet(buffer2, 8);
        BinaryTupleSchema schema = this.descriptor.binaryTupleSchema();
        BinaryTuplePrefix tuple1 = isBuffer1Prefix ? new BinaryTuplePrefix(schema, buffer1) : new BinaryTuple(schema, buffer1);
        BinaryTuplePrefix tuple2 = isBuffer2Prefix ? new BinaryTuplePrefix(schema, buffer2) : new BinaryTuple(schema, buffer2);
        int columnsToCompare = Math.min(tuple1.count(), tuple2.count());
        assert (columnsToCompare <= this.descriptor.columns().size());
        for (int i = 0; i < columnsToCompare; ++i) {
            SortedIndexDescriptor.SortedIndexColumnDescriptor columnDescriptor = this.descriptor.columns().get(i);
            int compare = this.compareField((InternalTuple)tuple1, (InternalTuple)tuple2, i);
            if (compare == 0) continue;
            return columnDescriptor.asc() ? compare : -compare;
        }
        if (isBuffer1Prefix == isBuffer2Prefix) {
            return 0;
        }
        if (isBuffer1Prefix) {
            return BinaryTupleComparator.equalityFlag(buffer1);
        }
        return -BinaryTupleComparator.equalityFlag(buffer2);
    }

    private int compareField(InternalTuple tuple1, InternalTuple tuple2, int index) {
        boolean tuple1HasNull = tuple1.hasNullValue(index);
        boolean tuple2HasNull = tuple2.hasNullValue(index);
        if (tuple1HasNull && tuple2HasNull) {
            return 0;
        }
        if (tuple1HasNull) {
            return 1;
        }
        if (tuple2HasNull) {
            return -1;
        }
        SortedIndexDescriptor.SortedIndexColumnDescriptor columnDescriptor = this.descriptor.columns().get(index);
        NativeTypeSpec typeSpec = columnDescriptor.type().spec();
        switch (typeSpec) {
            case INT8: {
                return Byte.compare(tuple1.byteValue(index), tuple2.byteValue(index));
            }
            case INT16: {
                return Short.compare(tuple1.shortValue(index), tuple2.shortValue(index));
            }
            case INT32: {
                return Integer.compare(tuple1.intValue(index), tuple2.intValue(index));
            }
            case INT64: {
                return Long.compare(tuple1.longValue(index), tuple2.longValue(index));
            }
            case FLOAT: {
                return Float.compare(tuple1.floatValue(index), tuple2.floatValue(index));
            }
            case DOUBLE: {
                return Double.compare(tuple1.doubleValue(index), tuple2.doubleValue(index));
            }
            case BYTES: {
                return Arrays.compare(tuple1.bytesValue(index), tuple2.bytesValue(index));
            }
            case BITMASK: {
                return Arrays.compare(tuple1.bitmaskValue(index).toLongArray(), tuple2.bitmaskValue(index).toLongArray());
            }
            case DECIMAL: 
            case UUID: 
            case STRING: 
            case NUMBER: 
            case TIMESTAMP: 
            case DATE: 
            case TIME: 
            case DATETIME: {
                return ((Comparable)typeSpec.objectValue(tuple1, index)).compareTo(typeSpec.objectValue(tuple2, index));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported column type in binary tuple comparator. Column name: %s, column type: %s", columnDescriptor.name(), columnDescriptor.type()));
    }

    private static boolean isFlagSet(ByteBuffer tuple, int flag) {
        return (tuple.get(0) & flag) != 0;
    }

    private static int equalityFlag(ByteBuffer tuple) {
        return BinaryTupleComparator.isFlagSet(tuple, 16) ? 1 : -1;
    }
}

