/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import org.apache.ignite.internal.schema.DefaultValueProvider;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypes;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;

public class Column {
    private static final DefaultValueProvider NULL_SUPPLIER = DefaultValueProvider.constantProvider(null);
    private final int schemaIndex;
    private final int columnOrder;
    private final String name;
    private final NativeType type;
    private final boolean nullable;
    @IgniteToStringExclude
    private final DefaultValueProvider defaultValueProvider;

    public Column(String name, NativeType type, boolean nullable) {
        this(-1, -1, name, type, nullable, NULL_SUPPLIER);
    }

    public Column(String name, NativeType type, boolean nullable, DefaultValueProvider defaultValueProvider) {
        this(-1, -1, name, type, nullable, defaultValueProvider);
    }

    public Column(int columnOrder, String name, NativeType type, boolean nullable) {
        this(-1, columnOrder, name, type, nullable, NULL_SUPPLIER);
    }

    public Column(int columnOrder, String name, NativeType type, boolean nullable, DefaultValueProvider defaultValueProvider) {
        this(-1, columnOrder, name, type, nullable, defaultValueProvider);
    }

    private Column(int schemaIndex, int columnOrder, String name, NativeType type, boolean nullable, DefaultValueProvider defaultValueProvider) {
        this.schemaIndex = schemaIndex;
        this.columnOrder = columnOrder;
        this.name = name;
        this.type = type;
        this.nullable = nullable;
        this.defaultValueProvider = defaultValueProvider;
    }

    public int schemaIndex() {
        return this.schemaIndex;
    }

    public int columnOrder() {
        return this.columnOrder;
    }

    public String name() {
        return this.name;
    }

    public NativeType type() {
        return this.type;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public DefaultValueProvider defaultValueProvider() {
        return this.defaultValueProvider;
    }

    public Object defaultValue() {
        return this.defaultValueProvider.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column col = (Column)o;
        return this.name.equals(col.name) && this.type.equals(col.type);
    }

    public int hashCode() {
        return this.name.hashCode() + 31 * this.type.hashCode();
    }

    public void validate(Object val) {
        if (val == null && !this.nullable) {
            throw new IllegalArgumentException("Failed to set column (null was passed, but column is not nullable): [col=" + this + "]");
        }
        NativeType objType = NativeTypes.fromObject(val);
        if (objType != null && this.type.mismatch(objType)) {
            throw new InvalidTypeException("Column's type mismatch [column=" + this + ", expectedType=" + this.type + ", actualType=" + objType + ", val=" + val + "]");
        }
    }

    public Column copy(int schemaIndex) {
        return new Column(schemaIndex, this.columnOrder, this.name, this.type, this.nullable, this.defaultValueProvider);
    }

    public String toString() {
        return S.toString(Column.class, (Object)this);
    }
}

