/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.jetbrains.annotations.Nullable;

public class HybridTimestamps {
    private static final long NULL_PHYSICAL_TIME = 0L;
    private static final int NULL_LOGICAL_TIME = 0;

    @Nullable
    static HybridTimestamp readTimestamp(long pageAddr, int offset) {
        long physical = PageUtils.getLong((long)pageAddr, (int)offset);
        int logical = PageUtils.getInt((long)pageAddr, (int)(offset + 8));
        if (physical == 0L && logical == 0) {
            return null;
        }
        return new HybridTimestamp(physical, logical);
    }

    public static int writeTimestampToMemory(long addr, int offset, @Nullable HybridTimestamp timestamp) {
        if (timestamp == null) {
            PageUtils.putLong((long)addr, (int)offset, (long)0L);
            PageUtils.putInt((long)addr, (int)(offset + 8), (int)0);
        } else {
            PageUtils.putLong((long)addr, (int)offset, (long)timestamp.getPhysical());
            PageUtils.putInt((long)addr, (int)(offset + 8), (int)timestamp.getLogical());
        }
        return 12;
    }

    public static void writeTimestampToBuffer(ByteBuffer buffer, @Nullable HybridTimestamp timestamp) {
        if (timestamp == null) {
            buffer.putLong(0L).putInt(0);
        } else {
            buffer.putLong(timestamp.getPhysical()).putInt(timestamp.getLogical());
        }
    }
}

