/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server.persistence;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.apache.ignite.internal.metastorage.common.MetaStorageException;
import org.apache.ignite.internal.metastorage.server.Entry;
import org.apache.ignite.internal.metastorage.server.EntryEvent;
import org.apache.ignite.internal.metastorage.server.Value;
import org.apache.ignite.internal.metastorage.server.WatchEvent;
import org.apache.ignite.internal.metastorage.server.persistence.RocksDbKeyValueStorage;
import org.apache.ignite.internal.metastorage.server.persistence.RocksStorageUtils;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

class WatchCursor
implements Cursor<WatchEvent> {
    private final RocksDbKeyValueStorage storage;
    private final Predicate<byte[]> predicate;
    private final ReadOptions options = new ReadOptions();
    private final RocksIterator nativeIterator;
    private long currentRevision;
    private boolean currentHasNext = false;

    WatchCursor(RocksDbKeyValueStorage storage, long rev, Predicate<byte[]> predicate) {
        this.storage = storage;
        this.predicate = predicate;
        this.currentRevision = rev;
        this.nativeIterator = storage.newDataIterator(this.options);
        this.nativeIterator.seek(RocksStorageUtils.longToBytes(rev));
    }

    public boolean hasNext() {
        this.storage.lock().readLock().lock();
        try {
            if (this.currentHasNext) {
                boolean bl = true;
                return bl;
            }
            if (!this.nativeIterator.isValid()) {
                this.nativeIterator.refresh();
                this.nativeIterator.seek(RocksStorageUtils.longToBytes(this.currentRevision));
            }
            boolean bl = this.currentHasNext = RocksUtils.find((RocksIterator)this.nativeIterator, (rocksKey, value) -> {
                byte[] key = RocksStorageUtils.rocksKeyToBytes(rocksKey);
                if (this.predicate.test(key)) {
                    this.currentRevision = RocksStorageUtils.revisionFromRocksKey(rocksKey);
                    return true;
                }
                return false;
            });
            return bl;
        }
        catch (RocksDBException e) {
            throw new MetaStorageException(ErrorGroups.MetaStorage.WATCH_EXECUTION_ERR, (Throwable)e);
        }
        finally {
            this.storage.lock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchEvent next() {
        this.storage.lock().readLock().lock();
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ArrayList<EntryEvent> evts = new ArrayList<EntryEvent>();
            long lastSeenRevision = this.currentRevision;
            while (this.nativeIterator.isValid()) {
                long revision;
                byte[] rocksKey = this.nativeIterator.key();
                byte[] rocksValue = this.nativeIterator.value();
                lastSeenRevision = revision = RocksStorageUtils.revisionFromRocksKey(rocksKey);
                if (revision > this.currentRevision) break;
                byte[] key = RocksStorageUtils.rocksKeyToBytes(rocksKey);
                if (this.predicate.test(key)) {
                    Value val = RocksStorageUtils.bytesToValue(rocksValue);
                    Entry newEntry = val.tombstone() ? Entry.tombstone(key, revision, val.updateCounter()) : new Entry(key, val.bytes(), revision, val.updateCounter());
                    Entry oldEntry = this.storage.doGet(key, revision - 1L);
                    evts.add(new EntryEvent(oldEntry, newEntry));
                }
                this.nativeIterator.next();
            }
            this.currentHasNext = false;
            this.currentRevision = lastSeenRevision > this.currentRevision ? lastSeenRevision : this.currentRevision + 1L;
            RocksUtils.checkIterator((RocksIterator)this.nativeIterator);
            WatchEvent watchEvent = new WatchEvent(evts);
            return watchEvent;
        }
        finally {
            this.storage.lock().readLock().unlock();
        }
    }

    public void close() throws Exception {
        IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.options, this.nativeIterator});
    }
}

