/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.common.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.raft.client.WriteCommand;
import org.jetbrains.annotations.NotNull;

public final class GetAndPutAllCommand
implements WriteCommand {
    @NotNull
    private final List<byte[]> keys;
    @NotNull
    private final List<byte[]> vals;

    public GetAndPutAllCommand(@NotNull Map<ByteArray, byte[]> vals) {
        int size = vals.size();
        this.keys = new ArrayList<byte[]>(size);
        this.vals = new ArrayList<byte[]>(size);
        for (Map.Entry<ByteArray, byte[]> e : vals.entrySet()) {
            this.keys.add(e.getKey().bytes());
            this.vals.add(e.getValue());
        }
    }

    @NotNull
    public List<byte[]> keys() {
        return this.keys;
    }

    @NotNull
    public List<byte[]> vals() {
        return this.vals;
    }
}

