/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.compaction;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.worker.IgniteWorker;
import org.apache.ignite.internal.util.worker.IgniteWorkerListener;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;

public class Compactor
extends IgniteWorker {
    private final Object mux = new Object();
    @Nullable
    private final ThreadPoolExecutor threadPoolExecutor;
    private final AtomicInteger deltaFileCount = new AtomicInteger();
    private final FilePageStoreManager filePageStoreManager;
    private final ThreadLocal<ByteBuffer> threadBuf;

    public Compactor(IgniteLogger log, String igniteInstanceName, @Nullable IgniteWorkerListener listener, ConfigurationValue<Integer> threads, FilePageStoreManager filePageStoreManager, int pageSize) {
        super(log, igniteInstanceName, "compaction-thread", listener);
        this.filePageStoreManager = filePageStoreManager;
        this.threadBuf = ThreadLocal.withInitial(() -> {
            ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(pageSize);
            tmpWriteBuf.order(ByteOrder.nativeOrder());
            return tmpWriteBuf;
        });
        int threadCount = (Integer)threads.value();
        this.threadPoolExecutor = threadCount > 1 ? new ThreadPoolExecutor(threadCount, threadCount, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("compaction-runner-io", log)) : null;
    }

    protected void body() throws InterruptedException {
        try {
            while (!this.isCancelled()) {
                this.waitDeltaFiles();
                if (this.isCancelled()) {
                    this.log.info("Skipping the delta file compaction because the node is stopping", new Object[0]);
                    return;
                }
                this.doCompaction();
            }
        }
        catch (Throwable t) {
            throw new IgniteInternalException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitDeltaFiles() {
        try {
            Object object = this.mux;
            synchronized (object) {
                while (this.deltaFileCount.get() == 0 && !this.isCancelled()) {
                    this.blockingSectionBegin();
                    try {
                        this.mux.wait();
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.isCancelled.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeltaFiles(int count) {
        assert (count >= 0);
        if (count > 0) {
            this.deltaFileCount.addAndGet(count);
            Object object = this.mux;
            synchronized (object) {
                this.mux.notifyAll();
            }
        }
    }

    void doCompaction() {
        Queue queue = this.filePageStoreManager.allPageStores().stream().flatMap(Collection::stream).map(filePageStore -> {
            DeltaFilePageStoreIo deltaFileToCompaction = filePageStore.getDeltaFileToCompaction();
            return deltaFileToCompaction == null ? null : new IgniteBiTuple(filePageStore, (Object)deltaFileToCompaction);
        }).filter(Objects::nonNull).collect(Collectors.toCollection(ConcurrentLinkedQueue::new));
        assert (!queue.isEmpty());
        this.updateHeartbeat();
        int threads = this.threadPoolExecutor == null ? 1 : this.threadPoolExecutor.getMaximumPoolSize();
        CompletableFuture[] futures = new CompletableFuture[threads];
        for (int i = 0; i < threads; ++i) {
            CompletableFuture future = futures[i] = new CompletableFuture();
            Runnable merger = () -> {
                try {
                    IgniteBiTuple toMerge;
                    while ((toMerge = (IgniteBiTuple)queue.poll()) != null) {
                        this.mergeDeltaFileToMainFile((FilePageStore)toMerge.get1(), (DeltaFilePageStoreIo)toMerge.get2());
                    }
                }
                catch (Throwable ex) {
                    future.completeExceptionally(ex);
                }
                future.complete(null);
            };
            if (this.isCancelled()) {
                return;
            }
            if (this.threadPoolExecutor == null) {
                merger.run();
                continue;
            }
            this.threadPoolExecutor.execute(merger);
        }
        this.updateHeartbeat();
        CompletableFuture.allOf(futures).join();
    }

    public void start() {
        if (this.runner() != null) {
            return;
        }
        assert (this.runner() == null) : "Compacter is running";
        new IgniteThread((IgniteWorker)this).start();
    }

    public void stop() throws Exception {
        this.cancel();
        boolean interrupt = false;
        while (true) {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                interrupt = true;
                continue;
            }
            break;
        }
        if (interrupt) {
            Thread.currentThread().interrupt();
        }
        if (this.threadPoolExecutor != null) {
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPoolExecutor, (long)2L, (TimeUnit)TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cancelling grid runnable: " + this, new Object[0]);
        }
        this.isCancelled.set(true);
        Object object = this.mux;
        synchronized (object) {
            this.mux.notifyAll();
        }
    }

    void mergeDeltaFileToMainFile(FilePageStore filePageStore, DeltaFilePageStoreIo deltaFilePageStore) throws Throwable {
        ByteBuffer buffer = this.threadBuf.get();
        int[] nArray = deltaFilePageStore.pageIndexes();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long pageIndex = nArray[i];
            this.updateHeartbeat();
            if (this.isCancelled()) {
                return;
            }
            long pageOffset = deltaFilePageStore.pageOffset(pageIndex);
            boolean read = deltaFilePageStore.readWithMergedToFilePageStoreCheck(pageIndex, pageOffset, buffer.rewind(), false);
            assert (read) : deltaFilePageStore.filePath();
            long pageId = PageIo.getPageId(buffer.rewind());
            assert (pageId != 0L) : deltaFilePageStore.filePath();
            this.updateHeartbeat();
            if (this.isCancelled()) {
                return;
            }
            filePageStore.write(pageId, buffer.rewind(), true);
        }
        this.updateHeartbeat();
        if (this.isCancelled()) {
            return;
        }
        filePageStore.sync();
        this.updateHeartbeat();
        if (this.isCancelled()) {
            return;
        }
        boolean removed = filePageStore.removeDeltaFile(deltaFilePageStore);
        assert (removed) : filePageStore.filePath();
        deltaFilePageStore.markMergedToFilePageStore();
        deltaFilePageStore.stop(true);
        this.deltaFileCount.decrementAndGet();
    }
}

