/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.message.FieldDescriptorMessage;
import org.apache.ignite.internal.network.message.FieldDescriptorMessageBuilder;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;

class FieldDescriptorMessageDeserializer
implements MessageDeserializer<FieldDescriptorMessage> {
    private final FieldDescriptorMessageBuilder msg;

    FieldDescriptorMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.fieldDescriptorMessage();
    }

    public Class<FieldDescriptorMessage> klass() {
        return FieldDescriptorMessage.class;
    }

    public FieldDescriptorMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.className(reader.readString("className"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.flags(reader.readByte("flags"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.name(reader.readString("name"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.typeDescriptorId(reader.readInt("typeDescriptorId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FieldDescriptorMessage.class);
    }
}

