/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.handshake.HandshakeException;
import org.apache.ignite.internal.network.handshake.HandshakeManager;
import org.apache.ignite.internal.network.netty.HandshakeHandler;
import org.apache.ignite.internal.network.netty.MessageHandler;
import org.apache.ignite.internal.network.netty.NettySender;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.internal.network.netty.PipelineUtils;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptor;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptorProvider;
import org.apache.ignite.internal.network.recovery.message.HandshakeFinishMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessage;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.OutNetworkObject;
import org.jetbrains.annotations.TestOnly;

public class RecoveryClientHandshakeManager
implements HandshakeManager {
    private static final NetworkMessagesFactory MESSAGE_FACTORY = new NetworkMessagesFactory();
    private final UUID launchId;
    private final String consistentId;
    private final RecoveryDescriptorProvider recoveryDescriptorProvider;
    private final short connectionId;
    private final CompletableFuture<NettySender> handshakeCompleteFuture = new CompletableFuture();
    private UUID remoteLaunchId;
    private String remoteConsistentId;
    private ChannelHandlerContext ctx;
    private Channel channel;
    private HandshakeHandler handler;
    private RecoveryDescriptor recoveryDescriptor;

    public RecoveryClientHandshakeManager(UUID launchId, String consistentId, short connectionId, RecoveryDescriptorProvider recoveryDescriptorProvider) {
        this.launchId = launchId;
        this.consistentId = consistentId;
        this.connectionId = connectionId;
        this.recoveryDescriptorProvider = recoveryDescriptorProvider;
    }

    @Override
    public void onInit(ChannelHandlerContext handlerContext) {
        this.ctx = handlerContext;
        this.channel = handlerContext.channel();
        this.handler = (HandshakeHandler)this.ctx.handler();
    }

    @Override
    public void onMessage(NetworkMessage message) {
        if (message instanceof HandshakeStartMessage) {
            HandshakeStartMessage msg = (HandshakeStartMessage)message;
            this.remoteLaunchId = msg.launchId();
            this.remoteConsistentId = msg.consistentId();
            this.recoveryDescriptor = this.recoveryDescriptorProvider.getRecoveryDescriptor(this.remoteConsistentId, this.remoteLaunchId, this.connectionId, false);
            this.handshake(this.recoveryDescriptor);
            return;
        }
        assert (this.recoveryDescriptor != null) : "Wrong client handshake flow";
        if (message instanceof HandshakeFinishMessage) {
            HandshakeFinishMessage msg = (HandshakeFinishMessage)message;
            long receivedCount = msg.receivedCount();
            this.recoveryDescriptor.acknowledge(receivedCount);
            int cnt = this.recoveryDescriptor.unacknowledgedCount();
            if (cnt == 0) {
                this.finishHandshake();
                return;
            }
            List<OutNetworkObject> networkMessages = this.recoveryDescriptor.unacknowledgedMessages();
            for (OutNetworkObject networkMessage : networkMessages) {
                this.channel.write((Object)networkMessage);
            }
            this.channel.flush();
            return;
        }
        int cnt = this.recoveryDescriptor.unacknowledgedCount();
        if (cnt == 0) {
            this.finishHandshake();
        }
        this.ctx.fireChannelRead((Object)message);
    }

    @Override
    public CompletableFuture<NettySender> handshakeFuture() {
        return this.handshakeCompleteFuture;
    }

    private void handshake(RecoveryDescriptor descriptor) {
        PipelineUtils.afterHandshake(this.ctx.pipeline(), descriptor, this.createMessageHandler(), MESSAGE_FACTORY);
        HandshakeStartResponseMessage response = MESSAGE_FACTORY.handshakeStartResponseMessage().launchId(this.launchId).consistentId(this.consistentId).receivedCount(descriptor.receivedCount()).connectionId(this.connectionId).build();
        ChannelFuture sendFuture = this.ctx.channel().writeAndFlush((Object)new OutNetworkObject(response, Collections.emptyList(), false));
        NettyUtils.toCompletableFuture(sendFuture).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                this.handshakeCompleteFuture.completeExceptionally(new HandshakeException("Failed to send handshake response: " + throwable.getMessage(), (Throwable)throwable));
            }
        });
    }

    private MessageHandler createMessageHandler() {
        return this.handler.createMessageHandler(this.remoteConsistentId);
    }

    protected void finishHandshake() {
        this.ctx.pipeline().remove((ChannelHandler)this.handler);
        this.handshakeCompleteFuture.complete(new NettySender(this.channel, this.remoteLaunchId.toString(), this.remoteConsistentId));
    }

    @TestOnly
    public RecoveryDescriptor recoveryDescriptor() {
        return this.recoveryDescriptor;
    }
}

