/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.ClusterStateBuilder;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class ClusterStateDeserializer
implements MessageDeserializer<ClusterState> {
    private final ClusterStateBuilder msg;

    ClusterStateDeserializer(CmgMessagesFactory messageFactory) {
        this.msg = messageFactory.clusterState();
    }

    public Class<ClusterState> klass() {
        return ClusterState.class;
    }

    public ClusterState getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.clusterTag((ClusterTag)reader.readMessage("clusterTag"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.cmgNodes(reader.readSet("cmgNodes", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.metaStorageNodes(reader.readSet("metaStorageNodes", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.version(reader.readString("version"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClusterState.class);
    }
}

