/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.notifications;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.NamedListConfiguration;
import org.apache.ignite.internal.configuration.notifications.ConfigurationNotificationContext;
import org.apache.ignite.internal.configuration.notifications.ConfigurationNotificationUtils;
import org.apache.ignite.internal.configuration.notifications.NamedListChanges;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class ConfigurationNotifier {
    public static Collection<CompletableFuture<?>> notifyListeners(@Nullable InnerNode oldInnerNode, InnerNode newInnerNode, DynamicConfiguration<InnerNode, ?> config, long storageRevision, long notificationNumber) {
        if (oldInnerNode == newInnerNode) {
            return List.of();
        }
        ConfigurationNotificationContext notificationCtx = new ConfigurationNotificationContext(storageRevision, notificationNumber);
        notificationCtx.addContainer(config, null);
        if (oldInnerNode == null) {
            ConfigurationNotifier.notifyListeners(newInnerNode, config, List.of(), notificationCtx);
        } else {
            ConfigurationNotifier.notifyListeners(oldInnerNode, newInnerNode, config, List.of(), notificationCtx);
        }
        notificationCtx.removeContainer(config);
        return notificationCtx.futures;
    }

    private static void notifyListeners(@Nullable InnerNode oldInnerNode, final InnerNode newInnerNode, final DynamicConfiguration<InnerNode, ?> config, final Collection<DynamicConfiguration<InnerNode, ?>> anyConfigs, final ConfigurationNotificationContext ctx) {
        assert (!(config instanceof NamedListConfiguration));
        if (oldInnerNode == null || newInnerNode == oldInnerNode) {
            return;
        }
        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(config, ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly(anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(anyCfg, ctx.notificationNum))), oldInnerNode.specificNode(), newInnerNode.specificNode(), ctx, ConfigurationListener::onUpdate);
        if (oldInnerNode.schemaType() != newInnerNode.schemaType()) {
            return;
        }
        oldInnerNode.traverseChildren(new ConfigurationVisitor<Void>(){

            @Override
            public Void visitLeafNode(String key, Serializable oldLeaf) {
                Serializable newLeaf = newInnerNode.traverseChild(key, ConfigurationUtil.leafNodeVisitor(), true);
                if (newLeaf != oldLeaf) {
                    ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.dynamicProperty(config, key), ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.dynamicProperty(anyCfg, key), ctx2.notificationNum))), oldLeaf, newLeaf, ctx, ConfigurationListener::onUpdate);
                }
                return null;
            }

            @Override
            public Void visitInnerNode(String key, InnerNode oldNode) {
                InnerNode newNode = newInnerNode.traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
                DynamicConfiguration<InnerNode, ?> newConfig = ConfigurationNotificationUtils.dynamicConfig(config, key);
                ctx.addContainer(newConfig, null);
                ConfigurationNotifier.notifyListeners(oldNode, newNode, newConfig, CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.dynamicConfig(anyCfg, key)), ctx);
                ctx.removeContainer(newConfig);
                return null;
            }

            @Override
            public Void visitNamedListNode(String key, NamedListNode<?> oldNamedList) {
                NamedListNode<?> newNamedList = newInnerNode.traverseChild(key, ConfigurationUtil.namedListNodeVisitor(), true);
                if (newNamedList != oldNamedList) {
                    InnerNode oldVal;
                    InnerNode newVal;
                    ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), oldNamedList, newNamedList, ctx, ConfigurationListener::onUpdate);
                    NamedListChanges namedListChanges = NamedListChanges.of(oldNamedList, newNamedList);
                    NamedListConfiguration<?, InnerNode, ?> namedListCfg = ConfigurationNotificationUtils.namedDynamicConfig(config, key);
                    Map<String, ConfigurationProperty<?>> namedListCfgMembers = namedListCfg.touchMembers();
                    Collection<DynamicConfiguration<InnerNode, ?>> newAnyConfigs = null;
                    for (String string : namedListChanges.created) {
                        DynamicConfiguration newNodeCfg = (DynamicConfiguration)namedListCfg.members().get(string);
                        ConfigurationUtil.touch(newNodeCfg);
                        ctx.addContainer(newNodeCfg, string);
                        newVal = newNamedList.getInnerNode(string);
                        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), null, newVal.specificNode(), ctx, ConfigurationNamedListListener::onCreate);
                        if (newAnyConfigs == null) {
                            newAnyConfigs = ConfigurationNotificationUtils.mergeAnyConfigs(CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.any(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key))), ConfigurationNotificationUtils.any(namedListCfg));
                        }
                        ConfigurationNotifier.notifyListeners(newVal, newNodeCfg, newAnyConfigs, ctx);
                        ctx.removeContainer(newNodeCfg);
                    }
                    for (String string : namedListChanges.deleted) {
                        DynamicConfiguration delNodeCfg = (DynamicConfiguration)namedListCfgMembers.get(string);
                        delNodeCfg.removedFromNamedList();
                        ctx.addContainer(delNodeCfg, string);
                        oldVal = oldNamedList.getInnerNode(string);
                        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), oldVal.specificNode(), null, ctx, ConfigurationNamedListListener::onDelete);
                        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(delNodeCfg, ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.any(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key)), ctx2.notificationNum))), oldVal.specificNode(), null, ctx, ConfigurationListener::onUpdate);
                        ctx.removeContainer(delNodeCfg);
                    }
                    for (Map.Entry entry : namedListChanges.renamed.entrySet()) {
                        DynamicConfiguration renNodeCfg = (DynamicConfiguration)namedListCfg.members().get(entry.getValue());
                        ctx.addContainer(renNodeCfg, (String)entry.getValue());
                        oldVal = oldNamedList.getInnerNode((String)entry.getKey());
                        InnerNode newVal2 = newNamedList.getInnerNode((String)entry.getValue());
                        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), oldVal.specificNode(), newVal2.specificNode(), ctx, (listener, event) -> listener.onRename((String)entry.getKey(), (String)entry.getValue(), event));
                        ctx.removeContainer(renNodeCfg);
                    }
                    for (String string : namedListChanges.updated) {
                        InnerNode oldVal2 = oldNamedList.getInnerNode(string);
                        if (oldVal2 == (newVal = newNamedList.getInnerNode(string))) continue;
                        DynamicConfiguration updNodeCfg = (DynamicConfiguration)namedListCfgMembers.get(string);
                        ctx.addContainer(updNodeCfg, string);
                        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), oldVal2.specificNode(), newVal.specificNode(), ctx, ConfigurationNamedListListener::onUpdate);
                        if (newAnyConfigs == null) {
                            newAnyConfigs = ConfigurationNotificationUtils.mergeAnyConfigs(CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.any(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key))), ConfigurationNotificationUtils.any(namedListCfg));
                        }
                        ConfigurationNotifier.notifyListeners(oldVal2, newVal, updNodeCfg, newAnyConfigs, ctx);
                        ctx.removeContainer(updNodeCfg);
                    }
                }
                return null;
            }
        }, true);
    }

    private static void notifyListeners(InnerNode innerNode, final DynamicConfiguration<InnerNode, ?> config, final Collection<DynamicConfiguration<InnerNode, ?>> anyConfigs, final ConfigurationNotificationContext ctx) {
        assert (!(config instanceof NamedListConfiguration));
        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(config, ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly(anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(anyCfg, ctx.notificationNum))), null, innerNode.specificNode(), ctx, ConfigurationListener::onUpdate);
        innerNode.traverseChildren(new ConfigurationVisitor<Void>(){

            @Override
            public Void visitLeafNode(String key, Serializable leaf) {
                ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.dynamicProperty(config, key), ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.dynamicProperty(anyCfg, key), ctx2.notificationNum))), null, leaf, ctx, ConfigurationListener::onUpdate);
                return null;
            }

            @Override
            public Void visitInnerNode(String key, InnerNode nestedInnerNode) {
                DynamicConfiguration<InnerNode, ?> nestedNodeConfig = ConfigurationNotificationUtils.dynamicConfig(config, key);
                ctx.addContainer(nestedNodeConfig, null);
                ConfigurationNotifier.notifyListeners(nestedInnerNode, nestedNodeConfig, CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.dynamicConfig(anyCfg, key)), ctx);
                ctx.removeContainer(nestedNodeConfig);
                return null;
            }

            @Override
            public Void visitNamedListNode(String key, NamedListNode<?> newNamedList) {
                ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), null, newNamedList, ctx, ConfigurationListener::onUpdate);
                Collection<DynamicConfiguration<InnerNode, ?>> newAnyConfigs = null;
                NamedListConfiguration<?, InnerNode, ?> namedListCfg = ConfigurationNotificationUtils.namedDynamicConfig(config, key);
                namedListCfg.touchMembers();
                for (String name : newNamedList.namedListKeys()) {
                    DynamicConfiguration<?, ?> namedNodeConfig = namedListCfg.getConfig(name);
                    ctx.addContainer(namedNodeConfig, name);
                    InnerNode namedInnerNode = newNamedList.getInnerNode(name);
                    ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat((Collection)CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), null, namedInnerNode.specificNode(), ctx, ConfigurationNamedListListener::onCreate);
                    if (newAnyConfigs == null) {
                        newAnyConfigs = ConfigurationNotificationUtils.mergeAnyConfigs(CollectionUtils.viewReadOnly((Collection)anyConfigs, anyCfg -> ConfigurationNotificationUtils.any(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key))), ConfigurationNotificationUtils.any(ConfigurationNotificationUtils.namedDynamicConfig(config, key)));
                    }
                    ConfigurationNotifier.notifyListeners(namedInnerNode, namedNodeConfig, newAnyConfigs, ctx);
                    ctx.removeContainer(namedNodeConfig);
                }
                return null;
            }
        }, true);
    }

    private static <L extends ConfigurationListener<?>> void notifyPublicListeners(Iterator<? extends L> configListeners, Iterator<? extends L> anyListeners, @Nullable Object oldValue, @Nullable Object newValue, ConfigurationNotificationContext notificationCtx, BiFunction<L, ConfigurationNotificationEvent, CompletableFuture<?>> invokeListener) {
        ConfigurationNotificationEvent<Object> event = null;
        Iterator it = CollectionUtils.concat((Iterator[])new Iterator[]{anyListeners, configListeners});
        while (it.hasNext()) {
            if (event == null) {
                event = notificationCtx.createEvent(oldValue, newValue);
            }
            try {
                CompletableFuture<?> future = invokeListener.apply((ConfigurationListener)it.next(), event);
                assert (future != null) : invokeListener;
                if (!future.isCompletedExceptionally() && !future.isCancelled() && future.isDone()) continue;
                notificationCtx.futures.add(future);
            }
            catch (Throwable t) {
                notificationCtx.futures.add(CompletableFuture.failedFuture(t));
            }
        }
    }
}

