/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.client.RetryLimitPolicy;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.PayloadInputChannel;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.AbstractClientView;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.client.table.ClientDataStreamer;
import org.apache.ignite.internal.client.table.ClientRecordSerializer;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.client.table.KeyValuePojoStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.marshaller.ClientMarshallerReader;
import org.apache.ignite.internal.marshaller.ClientMarshallerWriter;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.TupleReader;
import org.apache.ignite.internal.marshaller.ValidationUtils;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.table.criteria.SqlRowProjection;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.lang.UnexpectedNullValueException;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.ReceiverDescriptor;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;

public class ClientKeyValueView<K, V>
extends AbstractClientView<Map.Entry<K, V>>
implements KeyValueView<K, V> {
    private final ClientRecordSerializer<K> keySer;
    private final ClientRecordSerializer<V> valSer;

    ClientKeyValueView(ClientTable tbl, ClientSql sql, Mapper<K> keyMapper, Mapper<V> valMapper) {
        super(tbl, sql);
        assert (keyMapper != null);
        assert (valMapper != null);
        this.keySer = new ClientRecordSerializer<K>(tbl.tableId(), keyMapper);
        this.valSer = new ClientRecordSerializer<V>(tbl.tableId(), valMapper);
    }

    @Override
    public V get(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return ViewUtils.sync(this.doGet(tx, key, "getNullable"));
    }

    @Override
    public CompletableFuture<V> getAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doGet(tx, key, "getNullableAsync");
    }

    private CompletableFuture<V> doGet(@Nullable Transaction tx, K key, String altMethod) {
        return this.tbl.doSchemaOutInOpAsync(12, (s2, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), (s2, r) -> ClientKeyValueView.throwIfNull(this.valSer.readRec((ClientSchema)s2, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL), altMethod), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public NullableValue<V> getNullable(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valSer.mapper().targetType(), "getNullable");
        return ViewUtils.sync(this.doGetNullable(tx, key));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valSer.mapper().targetType(), "getNullableAsync");
        return this.doGetNullable(tx, key);
    }

    private CompletableFuture<NullableValue<V>> doGetNullable(@Nullable Transaction tx, K key) {
        return this.tbl.doSchemaOutInOpAsync(12, (s2, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), (s2, r) -> NullableValue.of(this.valSer.readRec((ClientSchema)s2, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL)), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public V getOrDefault(@Nullable Transaction tx, K key, V defaultValue) {
        return ViewUtils.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    @Override
    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, K key, V defaultValue) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(12, (s2, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), (s2, r) -> this.valSer.readRec((ClientSchema)s2, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL), defaultValue, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public Map<K, V> getAll(@Nullable Transaction tx, Collection<K> keys) {
        return ViewUtils.sync(this.getAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.emptyMapCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(15, (s2, w) -> this.keySer.writeRecs(tx, keys, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), this::readGetAllResponse, Collections.emptyMap(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), keys.iterator().next()), tx);
    }

    @Override
    public boolean contains(@Nullable Transaction tx, K key) {
        return ViewUtils.sync(this.containsAsync(tx, key));
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutOpAsync(33, (s2, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<K> keys) {
        return ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.tbl.doSchemaOutOpAsync(67, (s2, w) -> this.keySer.writeRecs(tx, keys, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), keys.iterator().next()), tx);
    }

    @Override
    public void put(@Nullable Transaction tx, K key, V val) {
        ViewUtils.sync(this.putAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return this.tbl.doSchemaOutOpAsync(10, (s2, w) -> this.writeKeyValue((ClientSchema)s2, (PayloadOutputChannel)w, tx, key, val), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public void putAll(@Nullable Transaction tx, Map<K, V> pairs) {
        ViewUtils.sync(this.putAllAsync(tx, pairs));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<K, V> pairs) {
        Objects.requireNonNull(pairs, "pairs");
        if (pairs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        for (Map.Entry<K, V> e : pairs.entrySet()) {
            Objects.requireNonNull(e.getKey(), "key");
            ValidationUtils.validateNullableValue(e.getValue(), this.valSer.mapper().targetType());
        }
        return this.tbl.doSchemaOutOpAsync(13, (s2, w) -> {
            this.writeSchemaAndTx((ClientSchema)s2, (PayloadOutputChannel)w, tx);
            w.out().packInt(pairs.size());
            for (Map.Entry e : pairs.entrySet()) {
                this.writeKeyValueRaw((ClientSchema)s2, (PayloadOutputChannel)w, e.getKey(), e.getValue());
            }
        }, r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), pairs.keySet().iterator().next()), tx);
    }

    @Override
    public V getAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return ViewUtils.sync(this.doGetAndPut(tx, key, val, "getNullableAndPut"));
    }

    @Override
    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return this.doGetAndPut(tx, key, val, "getNullableAndPutAsync");
    }

    private CompletableFuture<V> doGetAndPut(@Nullable Transaction tx, K key, @Nullable V val, String altMethod) {
        return this.tbl.doSchemaOutInOpAsync(16, (s2, w) -> this.writeKeyValue((ClientSchema)s2, (PayloadOutputChannel)w, tx, key, val), (s2, r) -> ClientKeyValueView.throwIfNull(this.valSer.readRec((ClientSchema)s2, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL), altMethod), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valSer.mapper().targetType(), "getNullableAndPut");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return ViewUtils.sync(this.doGetNullableAndPut(tx, key, val));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valSer.mapper().targetType(), "getNullableAndPutAsync");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return this.doGetNullableAndPut(tx, key, val);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.tbl.doSchemaOutInOpAsync(16, (s2, w) -> this.writeKeyValue((ClientSchema)s2, (PayloadOutputChannel)w, tx, key, val), (s2, r) -> NullableValue.of(this.valSer.readRec((ClientSchema)s2, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL)), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public boolean putIfAbsent(@Nullable Transaction tx, K key, V val) {
        return ViewUtils.sync(this.putIfAbsentAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return this.tbl.doSchemaOutOpAsync(18, (s2, w) -> this.writeKeyValue((ClientSchema)s2, (PayloadOutputChannel)w, tx, key, val), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key) {
        return ViewUtils.sync(this.removeAsync(tx, key));
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key, V val) {
        return ViewUtils.sync(this.removeAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutOpAsync(28, (s2, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return this.tbl.doSchemaOutOpAsync(30, (s2, w) -> this.writeKeyValue((ClientSchema)s2, (PayloadOutputChannel)w, tx, key, val), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public Collection<K> removeAll(@Nullable Transaction tx, Collection<K> keys) {
        return ViewUtils.sync(this.removeAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.emptyCollectionCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(29, (s2, w) -> this.keySer.writeRecs(tx, keys, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), (s2, r) -> this.keySer.readRecs((ClientSchema)s2, r.in(), false, TuplePart.KEY), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), keys.iterator().next()), tx);
    }

    @Override
    public V getAndRemove(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return ViewUtils.sync(this.doGetAndRemove(tx, key, "getNullableAndRemove"));
    }

    @Override
    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doGetAndRemove(tx, key, "getNullableAndRemoveAsync");
    }

    private CompletableFuture<V> doGetAndRemove(@Nullable Transaction tx, K key, String altMethod) {
        return this.tbl.doSchemaOutInOpAsync(32, (s2, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), (s2, r) -> ClientKeyValueView.throwIfNull(this.valSer.readRec((ClientSchema)s2, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL), altMethod), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valSer.mapper().targetType(), "getNullableAndRemove");
        return ViewUtils.sync(this.doGetNullableAndRemove(tx, key));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valSer.mapper().targetType(), "getNullableAndRemoveAsync");
        return this.doGetNullableAndRemove(tx, key);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndRemove(@Nullable Transaction tx, K key) {
        return this.tbl.doSchemaOutInOpAsync(32, (s2, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), (s2, r) -> NullableValue.of(this.valSer.readRec((ClientSchema)s2, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL)), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, V val) {
        return ViewUtils.sync(this.replaceAsync(tx, key, val));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, V oldVal, V newVal) {
        Objects.requireNonNull(key, "key");
        return ViewUtils.sync(this.replaceAsync(tx, key, oldVal, newVal));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return this.tbl.doSchemaOutOpAsync(22, (s2, w) -> this.writeKeyValue((ClientSchema)s2, (PayloadOutputChannel)w, tx, key, val), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, V oldVal, V newVal) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(oldVal, this.valSer.mapper().targetType());
        ValidationUtils.validateNullableValue(newVal, this.valSer.mapper().targetType());
        return this.tbl.doSchemaOutOpAsync(24, (s2, w) -> {
            this.writeSchemaAndTx((ClientSchema)s2, (PayloadOutputChannel)w, tx);
            this.writeKeyValueRaw((ClientSchema)s2, (PayloadOutputChannel)w, key, oldVal);
            this.writeKeyValueRaw((ClientSchema)s2, (PayloadOutputChannel)w, key, newVal);
        }, r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public V getAndReplace(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return ViewUtils.sync(this.doGetAndReplace(tx, key, val, "getNullableAndReplace"));
    }

    @Override
    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return this.doGetAndReplace(tx, key, val, "getNullableAndReplaceAsync");
    }

    private CompletableFuture<V> doGetAndReplace(@Nullable Transaction tx, K key, V val, String altMethod) {
        return this.tbl.doSchemaOutInOpAsync(26, (s2, w) -> this.writeKeyValue((ClientSchema)s2, (PayloadOutputChannel)w, tx, key, val), (s2, r) -> ClientKeyValueView.throwIfNull(this.valSer.readRec((ClientSchema)s2, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL), altMethod), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    @Override
    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valSer.mapper().targetType(), "getNullableAndReplace");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return ViewUtils.sync(this.getNullableAndReplaceAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valSer.mapper().targetType(), "getNullableAndReplaceAsync");
        ValidationUtils.validateNullableValue(val, this.valSer.mapper().targetType());
        return this.doGetNullableAndReplace(tx, key, val);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndReplace(@Nullable Transaction tx, K key, V val) {
        return this.tbl.doSchemaOutInOpAsync(26, (s2, w) -> this.writeKeyValue((ClientSchema)s2, (PayloadOutputChannel)w, tx, key, val), (s2, r) -> NullableValue.of(this.valSer.readRec((ClientSchema)s2, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL)), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    private void writeKeyValue(ClientSchema s2, PayloadOutputChannel w, @Nullable Transaction tx, K key, @Nullable V val) {
        this.writeSchemaAndTx(s2, w, tx);
        this.writeKeyValueRaw(s2, w, key, val);
    }

    private void writeKeyValueRaw(ClientSchema s2, PayloadOutputChannel w, K key, @Nullable V val) {
        BinaryTupleBuilder builder = new BinaryTupleBuilder(s2.columns().length);
        BitSet noValueSet = new BitSet();
        ClientMarshallerWriter writer = new ClientMarshallerWriter(builder, noValueSet);
        Marshaller keyMarsh = s2.getMarshaller(this.keySer.mapper(), TuplePart.KEY, false);
        Marshaller valMarsh = s2.getMarshaller(this.valSer.mapper(), TuplePart.VAL, false);
        for (ClientColumn column : s2.columns()) {
            if (column.key()) {
                keyMarsh.writeField(key, writer, column.keyIndex());
                continue;
            }
            valMarsh.writeField(val, writer, column.valIndex());
        }
        w.out().packBinaryTuple(builder, noValueSet);
    }

    private void writeSchemaAndTx(ClientSchema s2, PayloadOutputChannel w, @Nullable Transaction tx) {
        w.out().packInt(this.tbl.tableId());
        ClientTable.writeTx(tx, w);
        w.out().packInt(s2.version());
    }

    private HashMap<K, V> readGetAllResponse(ClientSchema schema, PayloadInputChannel in) {
        int cnt = in.in().unpackInt();
        LinkedHashMap<Object, Object> res = new LinkedHashMap<Object, Object>(cnt);
        Marshaller keyMarsh = schema.getMarshaller(this.keySer.mapper(), TuplePart.KEY);
        Marshaller valMarsh = schema.getMarshaller(this.valSer.mapper(), TuplePart.VAL);
        for (int i = 0; i < cnt; ++i) {
            if (!in.in().unpackBoolean()) continue;
            BinaryTupleReader tupleReader = new BinaryTupleReader(schema.columns().length, in.in().readBinaryUnsafe());
            ClientMarshallerReader keyReader = new ClientMarshallerReader(tupleReader, schema.keyColumns(), TuplePart.KEY_AND_VAL);
            ClientMarshallerReader valReader = new ClientMarshallerReader(tupleReader, schema.valColumns(), TuplePart.KEY_AND_VAL);
            res.put(keyMarsh.readObject(keyReader, null), valMarsh.readObject(valReader, null));
        }
        return res;
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<K, V>>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher, "publisher");
        KeyValuePojoStreamerPartitionAwarenessProvider provider = new KeyValuePojoStreamerPartitionAwarenessProvider(this.tbl, this.keySer.mapper());
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partition, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (s2, w) -> {
            w.out().packInt(this.tbl.tableId());
            w.out().packInt((int)partition);
            w.out().packBitSetNullable(deleted);
            w.out().packInt(s2.version());
            w.out().packInt(items.size());
            int i = 0;
            Marshaller keyMarsh = s2.getMarshaller(this.keySer.mapper(), TuplePart.KEY, false);
            Marshaller valMarsh = s2.getMarshaller(this.valSer.mapper(), TuplePart.VAL, false);
            BitSet noValueSet = new BitSet();
            for (Map.Entry e : items) {
                boolean del = deleted != null && deleted.get(i++);
                int colCount = del ? s2.keyColumns().length : s2.columns().length;
                noValueSet.clear();
                BinaryTupleBuilder builder = new BinaryTupleBuilder(colCount);
                ClientMarshallerWriter writer = new ClientMarshallerWriter(builder, noValueSet);
                keyMarsh.writeObject(e.getKey(), writer);
                if (!del) {
                    valMarsh.writeObject(e.getValue(), writer);
                }
                w.out().packBinaryTuple(builder, noValueSet);
            }
        }, r -> null, PartitionAwarenessProvider.of(partition), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    @Override
    public <E, P, R, A> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, Function<E, Map.Entry<K, V>> keyFunc, Function<E, P> payloadFunc, ReceiverDescriptor<A> receiver, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options, A receiverArg) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new KeyValuePojoStreamerPartitionAwarenessProvider(this.tbl, this.keySer.mapper()), this.tbl, resultSubscriber, receiver.units(), receiver.receiverClassName(), receiverArg, receiver.argumentMarshaller());
    }

    @Override
    protected Function<SqlRow, Map.Entry<K, V>> queryMapper(ResultSetMetadata meta, ClientSchema schema) {
        String[] keyCols = ClientKeyValueView.columnNames(schema.keyColumns());
        String[] valCols = ClientKeyValueView.columnNames(schema.valColumns());
        Marshaller keyMarsh = schema.getMarshaller(this.keySer.mapper(), TuplePart.KEY, true);
        Marshaller valMarsh = schema.getMarshaller(this.valSer.mapper(), TuplePart.VAL, true);
        return row -> new IgniteBiTuple<Object, Object>(keyMarsh.readObject(new TupleReader(new SqlRowProjection((SqlRow)row, meta, keyCols)), null), valMarsh.readObject(new TupleReader(new SqlRowProjection((SqlRow)row, meta, valCols)), null));
    }

    private static <T> T throwIfNull(T obj, String altMethod) {
        if (obj == null) {
            throw new UnexpectedNullValueException(IgniteStringFormatter.format("Got unexpected null value: use `{}` sibling method instead.", altMethod));
        }
        return obj;
    }
}

