/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSingleRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSingleRowReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSingleRowReplicaRequestSerializer;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ReadWriteSingleRowReplicaRequestImpl
implements ReadWriteSingleRowReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 0;
    @IgniteToStringInclude(sensitive=true)
    private final ByteBuffer binaryTuple;
    @IgniteToStringInclude
    private final TablePartitionIdMessage commitPartitionId;
    @IgniteToStringInclude
    private final UUID coordinatorId;
    @IgniteToStringInclude
    private final Long enlistmentConsistencyToken;
    @IgniteToStringInclude
    private final boolean full;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final RequestType requestType;
    @IgniteToStringInclude
    private final int schemaVersion;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID transactionId;

    private ReadWriteSingleRowReplicaRequestImpl(ByteBuffer binaryTuple, TablePartitionIdMessage commitPartitionId, UUID coordinatorId, Long enlistmentConsistencyToken, boolean full, ReplicationGroupIdMessage groupId, RequestType requestType, int schemaVersion, int tableId, HybridTimestamp timestamp, UUID transactionId) {
        this.binaryTuple = binaryTuple;
        this.commitPartitionId = commitPartitionId;
        this.coordinatorId = coordinatorId;
        this.enlistmentConsistencyToken = enlistmentConsistencyToken;
        this.full = full;
        this.groupId = groupId;
        this.requestType = requestType;
        this.schemaVersion = schemaVersion;
        this.tableId = tableId;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
    }

    @Override
    public ByteBuffer binaryTuple() {
        return this.binaryTuple;
    }

    @Override
    public TablePartitionIdMessage commitPartitionId() {
        return this.commitPartitionId;
    }

    @Override
    public UUID coordinatorId() {
        return this.coordinatorId;
    }

    public Long enlistmentConsistencyToken() {
        return this.enlistmentConsistencyToken;
    }

    @Override
    public boolean full() {
        return this.full;
    }

    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public RequestType requestType() {
        return this.requestType;
    }

    public int schemaVersion() {
        return this.schemaVersion;
    }

    public int tableId() {
        return this.tableId;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID transactionId() {
        return this.transactionId;
    }

    public MessageSerializer serializer() {
        return ReadWriteSingleRowReplicaRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ReadWriteSingleRowReplicaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadWriteSingleRowReplicaRequestImpl otherMessage = (ReadWriteSingleRowReplicaRequestImpl)other;
        return Objects.equals(this.binaryTuple, otherMessage.binaryTuple) && Objects.equals(this.commitPartitionId, otherMessage.commitPartitionId) && Objects.equals(this.coordinatorId, otherMessage.coordinatorId) && Objects.equals(this.enlistmentConsistencyToken, otherMessage.enlistmentConsistencyToken) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals((Object)this.requestType, (Object)otherMessage.requestType) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.transactionId, otherMessage.transactionId) && this.full == otherMessage.full && this.schemaVersion == otherMessage.schemaVersion && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.full, this.schemaVersion, this.tableId, this.binaryTuple, this.commitPartitionId, this.coordinatorId, this.enlistmentConsistencyToken, this.groupId, this.requestType, this.timestamp, this.transactionId});
        return result;
    }

    public ReadWriteSingleRowReplicaRequestImpl clone() {
        try {
            return (ReadWriteSingleRowReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadWriteSingleRowReplicaRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.commitPartitionId != null) {
            this.commitPartitionId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.commitPartitionId != null) {
            this.commitPartitionId.unmarshal((Object)marshaller, descriptorsObj);
        }
        if (this.groupId != null) {
            this.groupId.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ReadWriteSingleRowReplicaRequestBuilder {
        private ByteBuffer binaryTuple;
        private TablePartitionIdMessage commitPartitionId;
        private UUID coordinatorId;
        private Long enlistmentConsistencyToken;
        private boolean full;
        private ReplicationGroupIdMessage groupId;
        private RequestType requestType;
        private int schemaVersion;
        private int tableId;
        private HybridTimestamp timestamp;
        private UUID transactionId;

        private Builder() {
        }

        @Override
        public ReadWriteSingleRowReplicaRequestBuilder binaryTuple(ByteBuffer binaryTuple) {
            Objects.requireNonNull(binaryTuple, "binaryTuple is not marked @Nullable");
            this.binaryTuple = binaryTuple;
            return this;
        }

        @Override
        public ReadWriteSingleRowReplicaRequestBuilder commitPartitionId(TablePartitionIdMessage commitPartitionId) {
            Objects.requireNonNull(commitPartitionId, "commitPartitionId is not marked @Nullable");
            this.commitPartitionId = commitPartitionId;
            return this;
        }

        @Override
        public ReadWriteSingleRowReplicaRequestBuilder coordinatorId(UUID coordinatorId) {
            Objects.requireNonNull(coordinatorId, "coordinatorId is not marked @Nullable");
            this.coordinatorId = coordinatorId;
            return this;
        }

        @Override
        public ReadWriteSingleRowReplicaRequestBuilder enlistmentConsistencyToken(Long enlistmentConsistencyToken) {
            Objects.requireNonNull(enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable");
            this.enlistmentConsistencyToken = enlistmentConsistencyToken;
            return this;
        }

        @Override
        public ReadWriteSingleRowReplicaRequestBuilder full(boolean full) {
            this.full = full;
            return this;
        }

        @Override
        public ReadWriteSingleRowReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadWriteSingleRowReplicaRequestBuilder requestType(RequestType requestType) {
            Objects.requireNonNull(requestType, "requestType is not marked @Nullable");
            this.requestType = requestType;
            return this;
        }

        @Override
        public ReadWriteSingleRowReplicaRequestBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public ReadWriteSingleRowReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ReadWriteSingleRowReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ReadWriteSingleRowReplicaRequestBuilder transactionId(UUID transactionId) {
            Objects.requireNonNull(transactionId, "transactionId is not marked @Nullable");
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public ByteBuffer binaryTuple() {
            return this.binaryTuple;
        }

        @Override
        public TablePartitionIdMessage commitPartitionId() {
            return this.commitPartitionId;
        }

        @Override
        public UUID coordinatorId() {
            return this.coordinatorId;
        }

        @Override
        public Long enlistmentConsistencyToken() {
            return this.enlistmentConsistencyToken;
        }

        @Override
        public boolean full() {
            return this.full;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public RequestType requestType() {
            return this.requestType;
        }

        @Override
        public int schemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID transactionId() {
            return this.transactionId;
        }

        @Override
        public ReadWriteSingleRowReplicaRequest build() {
            return new ReadWriteSingleRowReplicaRequestImpl(Objects.requireNonNull(this.binaryTuple, "binaryTuple is not marked @Nullable"), Objects.requireNonNull(this.commitPartitionId, "commitPartitionId is not marked @Nullable"), Objects.requireNonNull(this.coordinatorId, "coordinatorId is not marked @Nullable"), Objects.requireNonNull(this.enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable"), this.full, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.requestType, "requestType is not marked @Nullable"), this.schemaVersion, this.tableId, this.timestamp, Objects.requireNonNull(this.transactionId, "transactionId is not marked @Nullable"));
        }
    }
}

