/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.replicator;

import org.apache.ignite.internal.replicator.exception.ExpectedReplicationException;
import org.apache.ignite.internal.tx.TransactionInternalException;
import org.apache.ignite.lang.ErrorGroups;

public class IncompatibleSchemaVersionException
extends TransactionInternalException
implements ExpectedReplicationException {
    private static final String SCHEMA_CHANGED_MESSAGE = "Table schema was updated after the transaction was started [table=%s, startSchema=%d, operationSchema=%d]";
    private static final String TABLE_DROPPED_NAME_MESSAGE = "Table was dropped [table=%s]";
    private static final String TABLE_DROPPED_ID_MESSAGE = "Table was dropped [tableId=%d]";

    public IncompatibleSchemaVersionException(String message) {
        super(ErrorGroups.Transactions.TX_INCOMPATIBLE_SCHEMA_ERR, message);
    }

    public static IncompatibleSchemaVersionException schemaChanged(String tableName, int startSchemaVersion, int operationSchemaVersion) {
        return new IncompatibleSchemaVersionException(String.format(SCHEMA_CHANGED_MESSAGE, tableName, startSchemaVersion, operationSchemaVersion));
    }

    public static IncompatibleSchemaVersionException tableDropped(String tableName) {
        return new IncompatibleSchemaVersionException(String.format(TABLE_DROPPED_NAME_MESSAGE, tableName));
    }

    public static IncompatibleSchemaVersionException tableDropped(int tableId) {
        return new IncompatibleSchemaVersionException(String.format(TABLE_DROPPED_ID_MESSAGE, tableId));
    }
}

