/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteServer;
import org.apache.ignite.InitParameters;

public class InitParametersBuilder {
    private Collection<String> metaStorageNodeNames;
    private Collection<String> cmgNodeNames;
    private String clusterName;
    private String clusterConfiguration;

    public InitParametersBuilder metaStorageNodeNames(String ... metaStorageNodeNames) {
        if (metaStorageNodeNames == null) {
            throw new IllegalArgumentException("Meta storage node names cannot be null.");
        }
        if (metaStorageNodeNames.length == 0) {
            throw new IllegalArgumentException("Meta storage node names cannot be empty.");
        }
        this.metaStorageNodeNames = List.of(metaStorageNodeNames);
        return this;
    }

    public InitParametersBuilder metaStorageNodeNames(Collection<String> metaStorageNodeNames) {
        if (metaStorageNodeNames == null) {
            throw new IllegalArgumentException("Meta storage node names cannot be null.");
        }
        if (metaStorageNodeNames.isEmpty()) {
            throw new IllegalArgumentException("Meta storage node names cannot be empty.");
        }
        this.metaStorageNodeNames = new ArrayList<String>(metaStorageNodeNames);
        return this;
    }

    public InitParametersBuilder metaStorageNodes(IgniteServer ... metaStorageNodes) {
        if (metaStorageNodes == null) {
            throw new IllegalArgumentException("Meta storage nodes cannot be null.");
        }
        if (metaStorageNodes.length == 0) {
            throw new IllegalArgumentException("Meta storage nodes cannot be empty.");
        }
        this.metaStorageNodeNames = Arrays.stream(metaStorageNodes).map(IgniteServer::name).collect(Collectors.toList());
        return this;
    }

    public InitParametersBuilder metaStorageNodes(Collection<IgniteServer> metaStorageNodes) {
        if (metaStorageNodes == null) {
            throw new IllegalArgumentException("Meta storage nodes cannot be null.");
        }
        if (metaStorageNodes.isEmpty()) {
            throw new IllegalArgumentException("Meta storage nodes cannot be empty.");
        }
        this.metaStorageNodeNames = metaStorageNodes.stream().map(IgniteServer::name).collect(Collectors.toList());
        return this;
    }

    public InitParametersBuilder cmgNodeNames(String ... cmgNodeNames) {
        if (cmgNodeNames == null) {
            throw new IllegalArgumentException("CMG node names cannot be null.");
        }
        if (cmgNodeNames.length == 0) {
            throw new IllegalArgumentException("CMG node names cannot be empty.");
        }
        this.cmgNodeNames = List.of(cmgNodeNames);
        return this;
    }

    public InitParametersBuilder cmgNodeNames(Collection<String> cmgNodeNames) {
        if (cmgNodeNames == null) {
            throw new IllegalArgumentException("CMG node names cannot be null.");
        }
        if (cmgNodeNames.isEmpty()) {
            throw new IllegalArgumentException("CMG node names cannot be empty.");
        }
        this.cmgNodeNames = new ArrayList<String>(cmgNodeNames);
        return this;
    }

    public InitParametersBuilder cmgNodes(IgniteServer ... cmgNodes) {
        if (cmgNodes == null) {
            throw new IllegalArgumentException("CMG nodes cannot be null.");
        }
        if (cmgNodes.length == 0) {
            throw new IllegalArgumentException("CMG nodes cannot be empty.");
        }
        this.cmgNodeNames = Arrays.stream(cmgNodes).map(IgniteServer::name).collect(Collectors.toList());
        return this;
    }

    public InitParametersBuilder cmgNodes(Collection<IgniteServer> cmgNodes) {
        if (cmgNodes == null) {
            throw new IllegalArgumentException("CMG nodes cannot be null.");
        }
        if (cmgNodes.isEmpty()) {
            throw new IllegalArgumentException("CMG nodes cannot be empty.");
        }
        this.cmgNodeNames = cmgNodes.stream().map(IgniteServer::name).collect(Collectors.toList());
        return this;
    }

    public InitParametersBuilder clusterName(String clusterName) {
        if (clusterName == null || clusterName.isBlank()) {
            throw new IllegalArgumentException("Cluster name cannot be null or empty.");
        }
        this.clusterName = clusterName;
        return this;
    }

    public InitParametersBuilder clusterConfiguration(String clusterConfiguration) {
        this.clusterConfiguration = clusterConfiguration;
        return this;
    }

    public InitParameters build() {
        Collection<String> collection = this.cmgNodeNames = this.cmgNodeNames == null ? this.metaStorageNodeNames : this.cmgNodeNames;
        if (this.metaStorageNodeNames == null) {
            throw new IllegalStateException("Meta storage node names is not set.");
        }
        if (this.cmgNodeNames == null) {
            throw new IllegalStateException("CMG node names is not set.");
        }
        if (this.clusterName == null) {
            throw new IllegalStateException("Cluster name is not set.");
        }
        return new InitParameters(this.metaStorageNodeNames, this.cmgNodeNames, this.clusterName, this.clusterConfiguration);
    }
}

