/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite.internal.sql.engine.exec.fsm.QueryExecutor;
import org.apache.ignite.internal.sql.engine.exec.fsm.QueryInfo;
import org.apache.ignite.internal.systemview.api.NodeSystemView;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViews;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.SubscriptionUtils;
import org.jetbrains.annotations.Nullable;

public class SqlQueriesViewProvider {
    public static final String SCRIPT_QUERY_TYPE = "SCRIPT";
    private final CompletableFuture<QueryExecutor> queryExecutorFuture = new CompletableFuture();

    public void init(QueryExecutor queryExecutor) {
        this.queryExecutorFuture.complete(queryExecutor);
    }

    public SystemView<?> get() {
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable((CompletableFuture)this.queryExecutorFuture.thenApply(queryExecutor -> () -> queryExecutor.runningQueries().iterator()));
        NativeType stringType = NativeTypes.stringOf((int)Short.MAX_VALUE);
        NativeType idType = NativeTypes.stringOf((int)36);
        NativeType timestampType = NativeTypes.timestamp((int)9);
        return ((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)SystemViews.nodeViewBuilder().name("SQL_QUERIES")).nodeNameColumnAlias("INITIATOR_NODE").addColumn("ID", idType, info -> SqlQueriesViewProvider.mapId(info.id()))).addColumn("PHASE", NativeTypes.stringOf((int)10), info -> SqlQueriesViewProvider.mapPhase(info.phase()))).addColumn("TYPE", NativeTypes.stringOf((int)10), SqlQueriesViewProvider::deriveQueryType)).addColumn("SCHEMA", stringType, QueryInfo::schema)).addColumn("SQL", stringType, QueryInfo::sql)).addColumn("START_TIME", timestampType, QueryInfo::startTime)).addColumn("TRANSACTION_ID", idType, info -> SqlQueriesViewProvider.mapId(info.transactionId()))).addColumn("PARENT_ID", idType, info -> SqlQueriesViewProvider.mapId(info.parentId()))).addColumn("STATEMENT_NUM", NativeTypes.INT32, info -> SqlQueriesViewProvider.mapStatementNum(info.statementNum()))).dataProvider(viewDataPublisher)).build();
    }

    @Nullable
    private static String mapId(@Nullable UUID id) {
        return id == null ? null : id.toString();
    }

    @Nullable
    private static String deriveQueryType(QueryInfo info) {
        if (info.script()) {
            return SCRIPT_QUERY_TYPE;
        }
        SqlQueryType queryType = info.queryType();
        return queryType == null ? null : queryType.toString();
    }

    private static String mapPhase(ExecutionPhase phase) {
        switch (phase) {
            case REGISTERED: 
            case PARSING: {
                return "INITIALIZATION";
            }
            case OPTIMIZING: {
                return "OPTIMIZATION";
            }
            case CURSOR_INITIALIZATION: 
            case SCRIPT_INITIALIZATION: 
            case EXECUTING: {
                return "EXECUTION";
            }
            case TERMINATED: {
                return "TERMINATED";
            }
        }
        throw new AssertionError((Object)("Unknown phase " + String.valueOf((Object)phase)));
    }

    @Nullable
    private static Integer mapStatementNum(int statementNum) {
        return statementNum >= 0 ? Integer.valueOf(statementNum) : null;
    }
}

