/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlParserPos
implements Serializable {
    public static final SqlParserPos ZERO = new SqlParserPos(0, 0);
    public static final SqlParserPos QUOTED_ZERO = new QuotedParserPos(0, 0, 0, 0);
    private static final long serialVersionUID = 1L;
    private final int lineNumber;
    private final int columnNumber;
    private final int endLineNumber;
    private final int endColumnNumber;

    public SqlParserPos(int lineNumber, int columnNumber) {
        this(lineNumber, columnNumber, lineNumber, columnNumber);
    }

    public SqlParserPos(int startLineNumber, int startColumnNumber, int endLineNumber, int endColumnNumber) {
        this.lineNumber = startLineNumber;
        this.columnNumber = startColumnNumber;
        this.endLineNumber = endLineNumber;
        this.endColumnNumber = endColumnNumber;
        assert (startLineNumber < endLineNumber || startLineNumber == endLineNumber && startColumnNumber <= endColumnNumber);
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.columnNumber, this.endLineNumber, this.endColumnNumber);
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof SqlParserPos && this.lineNumber == ((SqlParserPos)o).lineNumber && this.columnNumber == ((SqlParserPos)o).columnNumber && this.endLineNumber == ((SqlParserPos)o).endLineNumber && this.endColumnNumber == ((SqlParserPos)o).endColumnNumber;
    }

    public int getLineNum() {
        return this.lineNumber;
    }

    public int getColumnNum() {
        return this.columnNumber;
    }

    public int getEndLineNum() {
        return this.endLineNumber;
    }

    public int getEndColumnNum() {
        return this.endColumnNumber;
    }

    public SqlParserPos withQuoting(boolean quoted) {
        if (this.isQuoted() == quoted) {
            return this;
        }
        if (quoted) {
            return new QuotedParserPos(this.lineNumber, this.columnNumber, this.endLineNumber, this.endColumnNumber);
        }
        return new SqlParserPos(this.lineNumber, this.columnNumber, this.endLineNumber, this.endColumnNumber);
    }

    public boolean isQuoted() {
        return false;
    }

    public String toString() {
        return Static.RESOURCE.parserContext(this.lineNumber, this.columnNumber).str();
    }

    public SqlParserPos plus(SqlParserPos pos) {
        return new SqlParserPos(this.getLineNum(), this.getColumnNum(), pos.getEndLineNum(), pos.getEndColumnNum());
    }

    public SqlParserPos plusAll(@Nullable SqlNode[] nodes) {
        PosBuilder b = new PosBuilder(this);
        for (SqlNode node : nodes) {
            if (node == null) continue;
            b.add(node.getParserPosition());
        }
        return b.build(this);
    }

    public SqlParserPos plusAll(Collection<? extends @Nullable SqlNode> nodes) {
        PosBuilder b = new PosBuilder(this);
        for (SqlNode sqlNode : nodes) {
            if (sqlNode == null) continue;
            b.add(sqlNode.getParserPosition());
        }
        return b.build(this);
    }

    public static SqlParserPos sum(SqlNode[] nodes) {
        if (nodes.length == 0) {
            throw new AssertionError();
        }
        SqlParserPos pos0 = nodes[0].getParserPosition();
        if (nodes.length == 1) {
            return pos0;
        }
        PosBuilder b = new PosBuilder(pos0);
        for (int i = 1; i < nodes.length; ++i) {
            b.add(nodes[i].getParserPosition());
        }
        return b.build(pos0);
    }

    public static SqlParserPos sum(List<? extends SqlNode> nodes) {
        if (nodes.isEmpty()) {
            throw new AssertionError();
        }
        SqlParserPos pos0 = nodes.get(0).getParserPosition();
        if (nodes.size() == 1) {
            return pos0;
        }
        PosBuilder b = new PosBuilder(pos0);
        for (int i = 1; i < nodes.size(); ++i) {
            b.add(nodes.get(i).getParserPosition());
        }
        return b.build(pos0);
    }

    public static SqlParserPos sum(Iterable<SqlParserPos> poses) {
        List list;
        List list2 = list = poses instanceof List ? (List)poses : Lists.newArrayList(poses);
        if (list.isEmpty()) {
            throw new AssertionError();
        }
        SqlParserPos pos0 = (SqlParserPos)list.get(0);
        if (list.size() == 1) {
            return pos0;
        }
        PosBuilder b = new PosBuilder(pos0);
        for (int i = 1; i < list.size(); ++i) {
            b.add((SqlParserPos)list.get(i));
        }
        return b.build(pos0);
    }

    public boolean overlaps(SqlParserPos pos) {
        return this.startsBefore(pos) && this.endsAfter(pos) || pos.startsBefore(this) && pos.endsAfter(this);
    }

    private boolean startsBefore(SqlParserPos pos) {
        return this.lineNumber < pos.lineNumber || this.lineNumber == pos.lineNumber && this.columnNumber <= pos.columnNumber;
    }

    private boolean endsAfter(SqlParserPos pos) {
        return this.endLineNumber > pos.endLineNumber || this.endLineNumber == pos.endLineNumber && this.endColumnNumber >= pos.endColumnNumber;
    }

    public boolean startsAt(SqlParserPos pos) {
        return this.lineNumber == pos.lineNumber && this.columnNumber == pos.columnNumber;
    }

    private static class PosBuilder {
        private int line;
        private int column;
        private int endLine;
        private int endColumn;

        PosBuilder(SqlParserPos p) {
            this(p.lineNumber, p.columnNumber, p.endLineNumber, p.endColumnNumber);
        }

        PosBuilder(int line, int column, int endLine, int endColumn) {
            this.line = line;
            this.column = column;
            this.endLine = endLine;
            this.endColumn = endColumn;
        }

        void add(SqlParserPos pos) {
            if (pos.equals(ZERO)) {
                return;
            }
            int testLine = pos.getLineNum();
            int testColumn = pos.getColumnNum();
            if (testLine < this.line || testLine == this.line && testColumn < this.column) {
                this.line = testLine;
                this.column = testColumn;
            }
            testLine = pos.getEndLineNum();
            testColumn = pos.getEndColumnNum();
            if (testLine > this.endLine || testLine == this.endLine && testColumn > this.endColumn) {
                this.endLine = testLine;
                this.endColumn = testColumn;
            }
        }

        SqlParserPos build(SqlParserPos p) {
            return p.lineNumber == this.line && p.columnNumber == this.column && p.endLineNumber == this.endLine && p.endColumnNumber == this.endColumn ? p : this.build();
        }

        SqlParserPos build() {
            return new SqlParserPos(this.line, this.column, this.endLine, this.endColumn);
        }
    }

    private static class QuotedParserPos
    extends SqlParserPos {
        QuotedParserPos(int startLineNumber, int startColumnNumber, int endLineNumber, int endColumnNumber) {
            super(startLineNumber, startColumnNumber, endLineNumber, endColumnNumber);
        }

        @Override
        public boolean isQuoted() {
            return true;
        }
    }
}

