/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.RootInnerNode;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ConfigurationTreeGenerator
implements ManuallyCloseable {
    private final Map<String, RootKey<?, ?>> rootKeys;
    @Nullable
    private ConfigurationAsmGenerator generator = new ConfigurationAsmGenerator();

    @TestOnly
    public ConfigurationTreeGenerator(RootKey<?, ?> ... rootKeys) {
        this(List.of(rootKeys), Set.of(), Set.of());
    }

    public ConfigurationTreeGenerator(Collection<RootKey<?, ?>> rootKeys, Collection<Class<?>> schemaExtensions, Collection<Class<?>> polymorphicSchemaExtensions) {
        this.rootKeys = rootKeys.stream().collect(Collectors.toMap(RootKey::key, Function.identity()));
        Set<Class<?>> allSchemas = ConfigurationTreeGenerator.collectAllSchemas(rootKeys, schemaExtensions, polymorphicSchemaExtensions);
        Map<Class<?>, Set<Class<?>>> extensions = this.extensionsWithCheck(allSchemas, schemaExtensions);
        Map<Class<?>, Set<Class<?>>> polymorphicExtensions = this.polymorphicExtensionsWithCheck(allSchemas, polymorphicSchemaExtensions);
        rootKeys.forEach(key -> this.generator.compileRootSchema(key.schemaClass(), extensions, polymorphicExtensions));
    }

    public synchronized SuperRoot createSuperRoot() {
        assert (this.generator != null) : "ConfigurationTreeGenerator is already closed";
        SuperRoot superRoot = new SuperRoot(this.rootCreator());
        for (RootKey<?, ?> rootKey : this.rootKeys.values()) {
            superRoot.addRoot(rootKey, this.createRootNode(rootKey));
        }
        return superRoot;
    }

    public synchronized DynamicConfiguration<?, ?> instantiateCfg(RootKey<?, ?> rootKey, DynamicConfigurationChanger changer) {
        assert (this.generator != null) : "ConfigurationTreeGenerator is already closed";
        return this.generator.instantiateCfg(rootKey, changer);
    }

    public synchronized InnerNode instantiateNode(Class<?> schemaClass) {
        assert (this.generator != null) : "ConfigurationTreeGenerator is already closed";
        return this.generator.instantiateNode(schemaClass);
    }

    public synchronized InnerNode createRootNode(RootKey<?, ?> rootKey) {
        return this.instantiateNode(rootKey.schemaClass());
    }

    private Function<String, RootInnerNode> rootCreator() {
        return key -> {
            RootKey<?, ?> rootKey = this.rootKeys.get(key);
            return rootKey == null ? null : new RootInnerNode(rootKey, this.createRootNode(rootKey));
        };
    }

    public synchronized void close() {
        this.generator = null;
    }

    private static Set<Class<?>> collectAllSchemas(Collection<RootKey<?, ?>> rootKeys, Collection<Class<?>> internalSchemaExtensions, Collection<Class<?>> polymorphicSchemaExtensions) {
        HashSet allSchemas = new HashSet();
        allSchemas.addAll(ConfigurationUtil.collectSchemas(ConfigurationUtil.mapIterable(rootKeys, RootKey::schemaClass)));
        allSchemas.addAll(ConfigurationUtil.collectSchemas(internalSchemaExtensions));
        allSchemas.addAll(ConfigurationUtil.collectSchemas(polymorphicSchemaExtensions));
        return allSchemas;
    }

    private Map<Class<?>, Set<Class<?>>> extensionsWithCheck(Set<Class<?>> allSchemas, Collection<Class<?>> schemaExtensions) {
        if (schemaExtensions.isEmpty()) {
            return Map.of();
        }
        Map<Class<?>, Set<Class<?>>> extensions = ConfigurationUtil.schemaExtensions(schemaExtensions);
        Set notInAllSchemas = CollectionUtils.difference(extensions.keySet(), allSchemas);
        if (!notInAllSchemas.isEmpty()) {
            throw new IllegalArgumentException("Extensions for which no parent configuration schemas were found: " + String.valueOf(notInAllSchemas));
        }
        return extensions;
    }

    private Map<Class<?>, Set<Class<?>>> polymorphicExtensionsWithCheck(Set<Class<?>> allSchemas, Collection<Class<?>> polymorphicSchemaExtensions) {
        Map<Class<?>, Set<Class<?>>> polymorphicExtensionsByParent = ConfigurationUtil.polymorphicSchemaExtensions(polymorphicSchemaExtensions);
        Set notInAllSchemas = CollectionUtils.difference(polymorphicExtensionsByParent.keySet(), allSchemas);
        if (!notInAllSchemas.isEmpty()) {
            throw new IllegalArgumentException("Polymorphic extensions for which no polymorphic configuration schemas were found: " + String.valueOf(notInAllSchemas));
        }
        Collection noPolymorphicExtensionsSchemas = allSchemas.stream().filter(ConfigurationUtil::isPolymorphicConfig).filter(Predicate.not(polymorphicExtensionsByParent::containsKey)).collect(Collectors.toList());
        if (!noPolymorphicExtensionsSchemas.isEmpty()) {
            throw new IllegalArgumentException("Polymorphic configuration schemas for which no extensions were found: " + String.valueOf(noPolymorphicExtensionsSchemas));
        }
        this.checkPolymorphicConfigIds(polymorphicExtensionsByParent);
        for (Map.Entry<Class<?>, Set<Class<?>>> e : polymorphicExtensionsByParent.entrySet()) {
            Class<?> schemaClass = e.getKey();
            Field typeIdField = ConfigurationUtil.schemaFields(schemaClass).get(0);
            if (ConfigurationUtil.isPolymorphicId(typeIdField)) continue;
            throw new IllegalArgumentException(String.format("First field in a polymorphic configuration schema must contain @%s: %s", PolymorphicId.class, schemaClass.getName()));
        }
        return polymorphicExtensionsByParent;
    }

    private void checkPolymorphicConfigIds(Map<Class<?>, Set<Class<?>>> polymorphicExtensions) {
        HashMap ids = new HashMap();
        for (Map.Entry<Class<?>, Set<Class<?>>> e : polymorphicExtensions.entrySet()) {
            for (Class<?> schemaClass : e.getValue()) {
                String id = ConfigurationUtil.polymorphicInstanceId(schemaClass);
                Class<?> prev = ids.put(id, schemaClass);
                if (prev == null) continue;
                throw new IllegalArgumentException("Found an id conflict for a polymorphic configuration [id=" + id + ", schemas=" + String.valueOf(List.of(prev, schemaClass)));
            }
            ids.clear();
        }
    }
}

