/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.disaster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CreateTableEventParameters;
import org.apache.ignite.internal.catalog.events.DropTableEventParameters;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.events.HaZoneTopologyUpdateEvent;
import org.apache.ignite.internal.distributionzones.events.HaZoneTopologyUpdateEventParams;
import org.apache.ignite.internal.distributionzones.exception.DistributionZoneNotFoundException;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.WatchEvent;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessageGroup;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateEnum;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateMessage;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStatesRequest;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStatesResponse;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.raft.Loza;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViewProvider;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryRequest;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryRequestSerializer;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoverySystemViews;
import org.apache.ignite.internal.table.distributed.disaster.GlobalPartitionState;
import org.apache.ignite.internal.table.distributed.disaster.GlobalPartitionStateEnum;
import org.apache.ignite.internal.table.distributed.disaster.GroupUpdateRequest;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionState;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionStateByNode;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionStateEnumWithLogIndex;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionStateMessageByNode;
import org.apache.ignite.internal.table.distributed.disaster.ManualGroupRestartRequest;
import org.apache.ignite.internal.table.distributed.disaster.PartitionStatesMetricSource;
import org.apache.ignite.internal.table.distributed.disaster.exceptions.DisasterRecoveryException;
import org.apache.ignite.internal.table.distributed.disaster.exceptions.IllegalPartitionIdException;
import org.apache.ignite.internal.table.distributed.disaster.exceptions.NodesNotFoundException;
import org.apache.ignite.internal.table.distributed.disaster.exceptions.ZonesNotFoundException;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DisasterRecoveryManager
implements IgniteComponent,
SystemViewProvider {
    static final IgniteLogger LOG = Loggers.forClass(DisasterRecoveryManager.class);
    static final ByteArray RECOVERY_TRIGGER_KEY = new ByteArray("disaster.recovery.trigger");
    private static final String RECOVERY_TRIGGER_REVISION_KEY_PREFIX = "disaster.recovery.trigger.revision.";
    private static final PartitionReplicationMessagesFactory PARTITION_REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private static final int TIMEOUT_SECONDS = 30;
    private static final int CATCH_UP_THRESHOLD = 100;
    private final ExecutorService threadPool;
    private final MessagingService messagingService;
    final MetaStorageManager metaStorageManager;
    final CatalogManager catalogManager;
    final DistributionZoneManager dzManager;
    final Loza raftManager;
    private final TopologyService topologyService;
    private final WatchListener watchListener;
    final TableManager tableManager;
    private final MetricManager metricManager;
    private final Map<UUID, CompletableFuture<Void>> ongoingOperationsById = new ConcurrentHashMap<UUID, CompletableFuture<Void>>();
    private final Map<Integer, PartitionStatesMetricSource> metricSourceByTableId = new ConcurrentHashMap<Integer, PartitionStatesMetricSource>();

    public DisasterRecoveryManager(ExecutorService threadPool, MessagingService messagingService, MetaStorageManager metaStorageManager, CatalogManager catalogManager, DistributionZoneManager dzManager, Loza raftManager, TopologyService topologyService, TableManager tableManager, MetricManager metricManager) {
        this.threadPool = threadPool;
        this.messagingService = messagingService;
        this.metaStorageManager = metaStorageManager;
        this.catalogManager = catalogManager;
        this.dzManager = dzManager;
        this.raftManager = raftManager;
        this.topologyService = topologyService;
        this.tableManager = tableManager;
        this.metricManager = metricManager;
        this.watchListener = event -> {
            this.handleTriggerKeyUpdate(event);
            return CompletableFutures.nullCompletedFuture();
        };
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.messagingService.addMessageHandler(PartitionReplicationMessageGroup.class, this::handleMessage);
        this.metaStorageManager.registerExactWatch(RECOVERY_TRIGGER_KEY, this.watchListener);
        this.dzManager.listen((Event)HaZoneTopologyUpdateEvent.TOPOLOGY_REDUCED, this::onHaZoneTopologyReduce);
        this.catalogManager.listen((Event)CatalogEvent.TABLE_CREATE, EventListener.fromConsumer(this::onTableCreate));
        this.catalogManager.listen((Event)CatalogEvent.TABLE_DROP, EventListener.fromConsumer(this::onTableDrop));
        this.registerMetricSources();
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.metaStorageManager.unregisterWatch(this.watchListener);
        for (CompletableFuture<Void> future : this.ongoingOperationsById.values()) {
            future.completeExceptionally((Throwable)new NodeStoppingException());
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public List<SystemView<?>> systemViews() {
        return List.of(DisasterRecoverySystemViews.createGlobalPartitionStatesSystemView(this), DisasterRecoverySystemViews.createLocalPartitionStatesSystemView(this));
    }

    @TestOnly
    public Map<UUID, CompletableFuture<Void>> ongoingOperationsById() {
        return this.ongoingOperationsById;
    }

    private CompletableFuture<Boolean> onHaZoneTopologyReduce(HaZoneTopologyUpdateEventParams params) {
        int zoneId = params.zoneId();
        long revision = params.causalityToken();
        long timestamp = this.metaStorageManager.timestampByRevisionLocally(revision).longValue();
        CatalogZoneDescriptor zoneDescriptor = this.catalogManager.zone(zoneId, timestamp);
        int catalogVersion = this.catalogManager.activeCatalogVersion(timestamp);
        List tables = DistributionZonesUtil.findTablesByZoneId((int)zoneId, (int)catalogVersion, (CatalogService)this.catalogManager);
        HashMap<Integer, Set<Integer>> tablePartitionsToReset = new HashMap<Integer, Set<Integer>>();
        for (CatalogTableDescriptor table : tables) {
            HashSet<Integer> partitionsToReset = new HashSet<Integer>();
            for (int partId = 0; partId < zoneDescriptor.partitions(); ++partId) {
                TablePartitionId partitionId = new TablePartitionId(table.id(), partId);
                if (this.stableAssignmentsWithOnlyAliveNodes(partitionId, revision).size() >= zoneDescriptor.replicas() / 2 + 1) continue;
                partitionsToReset.add(partId);
            }
            if (partitionsToReset.isEmpty()) continue;
            tablePartitionsToReset.put(table.id(), partitionsToReset);
        }
        if (!tablePartitionsToReset.isEmpty()) {
            return this.resetPartitions(zoneDescriptor.name(), tablePartitionsToReset, false, revision).thenApply(r -> false);
        }
        return CompletableFutures.falseCompletedFuture();
    }

    private Set<Assignment> stableAssignmentsWithOnlyAliveNodes(TablePartitionId partitionId, long revision) {
        Set stableAssignments = Assignments.fromBytes((byte[])this.metaStorageManager.getLocally(RebalanceUtil.stablePartAssignmentsKey((TablePartitionId)partitionId), revision).value()).nodes();
        Set logicalTopology = this.dzManager.logicalTopology(revision).stream().map(NodeWithAttributes::nodeName).collect(Collectors.toUnmodifiableSet());
        return stableAssignments.stream().filter(a -> logicalTopology.contains(a.consistentId())).collect(Collectors.toUnmodifiableSet());
    }

    public CompletableFuture<Void> resetAllPartitions(String zoneName, String schemaName, String tableName, boolean manualUpdate, long triggerRevision) {
        return this.resetPartitions(zoneName, schemaName, tableName, Collections.emptySet(), manualUpdate, triggerRevision);
    }

    public CompletableFuture<Void> resetPartitions(String zoneName, String schemaName, String tableName, Set<Integer> partitionIds) {
        int tableId = DisasterRecoveryManager.tableDescriptor(this.catalogLatestVersion(), schemaName, tableName).id();
        return this.resetPartitions(zoneName, Map.of(tableId, partitionIds), true, -1L);
    }

    private CompletableFuture<Void> resetPartitions(String zoneName, String schemaName, String tableName, Set<Integer> partitionIds, boolean manualUpdate, long triggerRevision) {
        int tableId = DisasterRecoveryManager.tableDescriptor(this.catalogLatestVersion(), schemaName, tableName).id();
        return this.resetPartitions(zoneName, Map.of(tableId, partitionIds), manualUpdate, triggerRevision);
    }

    private CompletableFuture<Void> resetPartitions(String zoneName, Map<Integer, Set<Integer>> partitionIds, boolean manualUpdate, long triggerRevision) {
        try {
            Catalog catalog = this.catalogLatestVersion();
            CatalogZoneDescriptor zone = DisasterRecoveryManager.zoneDescriptor(catalog, zoneName);
            partitionIds.values().forEach(ids -> DisasterRecoveryManager.checkPartitionsRange(ids, Set.of(zone)));
            return this.processNewRequest(new GroupUpdateRequest(UUID.randomUUID(), catalog.version(), zone.id(), partitionIds, manualUpdate), triggerRevision);
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    public CompletableFuture<Void> restartPartitions(Set<String> nodeNames, String zoneName, String schemaName, String tableName, Set<Integer> partitionIds) {
        try {
            this.getNodes(nodeNames);
            Catalog catalog = this.catalogLatestVersion();
            CatalogZoneDescriptor zone = DisasterRecoveryManager.zoneDescriptor(catalog, zoneName);
            CatalogTableDescriptor table = DisasterRecoveryManager.tableDescriptor(catalog, schemaName, tableName);
            DisasterRecoveryManager.checkPartitionsRange(partitionIds, Set.of(zone));
            return this.processNewRequest(new ManualGroupRestartRequest(UUID.randomUUID(), zone.id(), table.id(), partitionIds, nodeNames, catalog.time()));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    public CompletableFuture<Map<TablePartitionId, LocalPartitionStateByNode>> localPartitionStates(Set<String> zoneNames, Set<String> nodeNames, Set<Integer> partitionIds) {
        try {
            Catalog catalog = this.catalogLatestVersion();
            return this.localPartitionStatesInternal(zoneNames, nodeNames, partitionIds, catalog).thenApply(res -> DisasterRecoveryManager.normalizeLocal(res, catalog));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    public CompletableFuture<Map<TablePartitionId, GlobalPartitionState>> globalPartitionStates(Set<String> zoneNames, Set<Integer> partitionIds) {
        try {
            Catalog catalog = this.catalogLatestVersion();
            return ((CompletableFuture)this.localPartitionStatesInternal(zoneNames, Set.of(), partitionIds, catalog).thenApply(res -> DisasterRecoveryManager.normalizeLocal(res, catalog))).thenApply(res -> DisasterRecoveryManager.assembleGlobal(res, partitionIds, catalog));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    CompletableFuture<Map<TablePartitionId, LocalPartitionStateMessageByNode>> localPartitionStatesInternal(Set<String> zoneNames, Set<String> nodeNames, Set<Integer> partitionIds, Catalog catalog) {
        Collection<CatalogZoneDescriptor> zones = DisasterRecoveryManager.filterZones(zoneNames, catalog.zones());
        DisasterRecoveryManager.checkPartitionsRange(partitionIds, zones);
        Set<NodeWithAttributes> nodes = this.getNodes(nodeNames);
        Set zoneIds = zones.stream().map(CatalogObjectDescriptor::id).collect(Collectors.toSet());
        LocalPartitionStatesRequest localPartitionStatesRequest = PARTITION_REPLICATION_MESSAGES_FACTORY.localPartitionStatesRequest().zoneIds(zoneIds).partitionIds(partitionIds).catalogVersion(catalog.version()).build();
        ConcurrentHashMap result = new ConcurrentHashMap();
        CompletableFuture[] futures = new CompletableFuture[nodes.size()];
        int i = 0;
        for (NodeWithAttributes node : nodes) {
            CompletableFuture invokeFuture = this.messagingService.invoke(node.nodeName(), (NetworkMessage)localPartitionStatesRequest, TimeUnit.SECONDS.toMillis(30L));
            futures[i++] = invokeFuture.thenAccept(networkMessage -> {
                assert (networkMessage instanceof LocalPartitionStatesResponse) : networkMessage;
                LocalPartitionStatesResponse response = (LocalPartitionStatesResponse)networkMessage;
                for (LocalPartitionStateMessage state : response.states()) {
                    result.compute(state.partitionId().asTablePartitionId(), (tablePartitionId, messageByNode) -> {
                        if (messageByNode == null) {
                            return new LocalPartitionStateMessageByNode(Map.of(node.nodeName(), state));
                        }
                        messageByNode = new LocalPartitionStateMessageByNode((LocalPartitionStateMessageByNode)messageByNode);
                        messageByNode.put(node.nodeName(), state);
                        return messageByNode;
                    });
                }
            });
        }
        return CompletableFuture.allOf(futures).handle((unused, err) -> {
            if (err != null) {
                throw new DisasterRecoveryException(ErrorGroups.DisasterRecovery.PARTITION_STATE_ERR, (Throwable)err);
            }
            return result;
        });
    }

    private static void checkPartitionsRange(Set<Integer> partitionIds, Collection<CatalogZoneDescriptor> zones) {
        if (partitionIds.isEmpty()) {
            return;
        }
        int minPartition = (Integer)partitionIds.stream().min(Integer::compare).get();
        if (minPartition < 0) {
            throw new IllegalPartitionIdException(minPartition);
        }
        int maxPartition = (Integer)partitionIds.stream().max(Integer::compare).get();
        zones.forEach(zone -> {
            if (maxPartition >= zone.partitions()) {
                throw new IllegalPartitionIdException(maxPartition, zone.partitions(), zone.name());
            }
        });
    }

    private Set<NodeWithAttributes> getNodes(Set<String> nodeNames) throws NodesNotFoundException {
        if (nodeNames.isEmpty()) {
            return this.dzManager.logicalTopology();
        }
        Set<NodeWithAttributes> nodes = this.dzManager.logicalTopology().stream().filter(node -> nodeNames.contains(node.nodeName())).collect(Collectors.toSet());
        Set foundNodeNames = nodes.stream().map(NodeWithAttributes::nodeName).collect(Collectors.toSet());
        if (!nodeNames.equals(foundNodeNames)) {
            Set missingNodeNames = CollectionUtils.difference(nodeNames, foundNodeNames);
            throw new NodesNotFoundException(missingNodeNames);
        }
        return nodes;
    }

    private static Collection<CatalogZoneDescriptor> filterZones(Set<String> zoneNames, Collection<CatalogZoneDescriptor> zones) throws ZonesNotFoundException {
        if (zoneNames.isEmpty()) {
            return zones;
        }
        List<CatalogZoneDescriptor> zoneDescriptors = zones.stream().filter(catalogZoneDescriptor -> zoneNames.contains(catalogZoneDescriptor.name())).collect(Collectors.toList());
        Set foundZoneNames = zoneDescriptors.stream().map(CatalogObjectDescriptor::name).collect(Collectors.toSet());
        if (!zoneNames.equals(foundZoneNames)) {
            Set missingZoneNames = CollectionUtils.difference(zoneNames, foundZoneNames);
            throw new ZonesNotFoundException(missingZoneNames);
        }
        return zoneDescriptors;
    }

    private CompletableFuture<Void> processNewRequest(DisasterRecoveryRequest request) {
        return this.processNewRequest(request, -1L);
    }

    private CompletableFuture<Void> processNewRequest(DisasterRecoveryRequest request, long revision) {
        UUID operationId = request.operationId();
        CompletableFuture<Void> operationFuture = ((CompletableFuture)new CompletableFuture().whenComplete((v, throwable) -> this.ongoingOperationsById.remove(operationId))).orTimeout(30L, TimeUnit.SECONDS);
        byte[] serializedRequest = VersionedSerialization.toBytes((Object)request, (VersionedSerializer)DisasterRecoveryRequestSerializer.INSTANCE);
        this.ongoingOperationsById.put(operationId, operationFuture);
        if (revision != -1L) {
            this.putRecoveryTriggerIfRevisionIsNotProcessed(request.zoneId(), ByteUtils.longToBytesKeepingOrder((long)revision), serializedRequest, operationId);
        } else {
            this.metaStorageManager.put(RECOVERY_TRIGGER_KEY, serializedRequest);
        }
        return operationFuture;
    }

    private void putRecoveryTriggerIfRevisionIsNotProcessed(int zoneId, byte[] revisionBytes, byte[] recoveryTriggerValue, UUID operationId) {
        ByteArray zoneTriggerRevisionKey = DisasterRecoveryManager.zoneRecoveryTriggerRevisionKey(zoneId);
        this.metaStorageManager.invoke(Conditions.notExists((ByteArray)zoneTriggerRevisionKey).or((Condition)Conditions.value((ByteArray)zoneTriggerRevisionKey).lt(revisionBytes)), List.of(Operations.put((ByteArray)RECOVERY_TRIGGER_KEY, (byte[])recoveryTriggerValue), Operations.put((ByteArray)zoneTriggerRevisionKey, (byte[])revisionBytes)), List.of()).thenAccept(wasWrite -> {
            if (!wasWrite.booleanValue()) {
                this.ongoingOperationsById.remove(operationId).complete(null);
            }
        });
    }

    private void handleTriggerKeyUpdate(WatchEvent watchEvent) {
        DisasterRecoveryRequest request;
        Entry newEntry = watchEvent.entryEvent().newEntry();
        byte[] requestBytes = newEntry.value();
        assert (requestBytes != null);
        try {
            request = (DisasterRecoveryRequest)VersionedSerialization.fromBytes((byte[])requestBytes, (VersionedSerializer)DisasterRecoveryRequestSerializer.INSTANCE);
        }
        catch (Exception e) {
            LOG.warn("Unable to deserialize disaster recovery request.", (Throwable)e);
            return;
        }
        CompletableFuture<Void> operationFuture = this.ongoingOperationsById.remove(request.operationId());
        switch (request.type()) {
            case SINGLE_NODE: {
                if (operationFuture == null) {
                    return;
                }
                request.handle(this, watchEvent.revision(), watchEvent.timestamp()).whenComplete(CompletableFutures.copyStateTo(operationFuture));
                break;
            }
            case MULTI_NODE: {
                CompletableFuture<Void> handleFuture = request.handle(this, watchEvent.revision(), watchEvent.timestamp());
                if (operationFuture == null) {
                    return;
                }
                handleFuture.whenComplete(CompletableFutures.copyStateTo(operationFuture));
                break;
            }
            default: {
                AssertionError error = new AssertionError((Object)("Unexpected request type: " + String.valueOf(request.getClass())));
                if (operationFuture == null) break;
                operationFuture.completeExceptionally((Throwable)((Object)error));
            }
        }
    }

    private void handleMessage(NetworkMessage message, ClusterNode sender, @Nullable Long correlationId) {
        if (message instanceof LocalPartitionStatesRequest) {
            this.handleLocalPartitionStatesRequest((LocalPartitionStatesRequest)message, sender, correlationId);
        }
    }

    private void handleLocalPartitionStatesRequest(LocalPartitionStatesRequest request, ClusterNode sender, @Nullable Long correlationId) {
        assert (correlationId != null) : "request=" + String.valueOf(request) + ", sender=" + String.valueOf(sender);
        int catalogVersion = request.catalogVersion();
        this.catalogManager.catalogReadyFuture(catalogVersion).thenRunAsync(() -> {
            ArrayList statesList = new ArrayList();
            this.raftManager.forEach((raftNodeId, raftGroupService) -> {
                if (raftNodeId.groupId() instanceof TablePartitionId) {
                    TablePartitionId tablePartitionId = (TablePartitionId)raftNodeId.groupId();
                    if (!DisasterRecoveryManager.containsOrEmpty(tablePartitionId.partitionId(), request.partitionIds())) {
                        return;
                    }
                    CatalogTableDescriptor tableDescriptor = this.catalogManager.table(tablePartitionId.tableId(), catalogVersion);
                    if (tableDescriptor == null || !DisasterRecoveryManager.containsOrEmpty(tableDescriptor.zoneId(), request.zoneIds())) {
                        return;
                    }
                    TableViewInternal tableViewInternal = this.tableManager.cachedTable(tablePartitionId.tableId());
                    if (tableViewInternal == null) {
                        return;
                    }
                    MvPartitionStorage partitionStorage = tableViewInternal.internalTable().storage().getMvPartition(tablePartitionId.partitionId());
                    if (partitionStorage == null) {
                        return;
                    }
                    LocalPartitionStateEnumWithLogIndex localPartitionStateWithLogIndex = LocalPartitionStateEnumWithLogIndex.of(raftGroupService.getRaftNode());
                    statesList.add(PARTITION_REPLICATION_MESSAGES_FACTORY.localPartitionStateMessage().partitionId(ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)tablePartitionId)).state(localPartitionStateWithLogIndex.state).logIndex(localPartitionStateWithLogIndex.logIndex).estimatedRows(partitionStorage.estimatedSize()).build());
                }
            });
            LocalPartitionStatesResponse response = PARTITION_REPLICATION_MESSAGES_FACTORY.localPartitionStatesResponse().states(statesList).build();
            this.messagingService.respond(sender, (NetworkMessage)response, correlationId.longValue());
        }, this.threadPool);
    }

    private static <T> boolean containsOrEmpty(T item, Collection<T> collection) {
        return collection.isEmpty() || collection.contains(item);
    }

    private static Map<TablePartitionId, LocalPartitionStateByNode> normalizeLocal(Map<TablePartitionId, LocalPartitionStateMessageByNode> result, Catalog catalog) {
        HashMap<TablePartitionId, LocalPartitionStateByNode> map = new HashMap<TablePartitionId, LocalPartitionStateByNode>();
        for (Map.Entry<TablePartitionId, LocalPartitionStateMessageByNode> entry : result.entrySet()) {
            TablePartitionId tablePartitionId = entry.getKey();
            LocalPartitionStateMessageByNode messageByNode = entry.getValue();
            long maxLogIndex = messageByNode.values().stream().mapToLong(LocalPartitionStateMessage::logIndex).max().getAsLong();
            Map<String, LocalPartitionState> nodeToStateMap = messageByNode.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, nodeToState -> DisasterRecoveryManager.toLocalPartitionState(nodeToState, maxLogIndex, tablePartitionId, catalog)));
            map.put(tablePartitionId, new LocalPartitionStateByNode(nodeToStateMap));
        }
        return map;
    }

    private static LocalPartitionState toLocalPartitionState(Map.Entry<String, LocalPartitionStateMessage> nodeToMessage, long maxLogIndex, TablePartitionId tablePartitionId, Catalog catalog) {
        LocalPartitionStateMessage stateMsg = nodeToMessage.getValue();
        LocalPartitionStateEnum stateEnum = stateMsg.state();
        if (stateEnum == LocalPartitionStateEnum.HEALTHY && maxLogIndex - stateMsg.logIndex() >= 100L) {
            stateEnum = LocalPartitionStateEnum.CATCHING_UP;
        }
        CatalogTableDescriptor tableDescriptor = catalog.table(tablePartitionId.tableId());
        String zoneName = catalog.zone(tableDescriptor.zoneId()).name();
        String schemaName = catalog.schema(tableDescriptor.schemaId()).name();
        return new LocalPartitionState(zoneName, schemaName, tableDescriptor.id(), tableDescriptor.name(), tablePartitionId.partitionId(), stateEnum, stateMsg.estimatedRows());
    }

    private static Map<TablePartitionId, GlobalPartitionState> assembleGlobal(Map<TablePartitionId, LocalPartitionStateByNode> localResult, Set<Integer> partitionIds, Catalog catalog) {
        Map<TablePartitionId, GlobalPartitionState> result = localResult.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            TablePartitionId tablePartitionId = (TablePartitionId)entry.getKey();
            LocalPartitionStateByNode map = (LocalPartitionStateByNode)entry.getValue();
            return DisasterRecoveryManager.assembleGlobalStateFromLocal(catalog, tablePartitionId, map);
        }));
        DisasterRecoveryManager.makeMissingPartitionsUnavailable(localResult, catalog, result, partitionIds);
        return result;
    }

    private static void makeMissingPartitionsUnavailable(Map<TablePartitionId, LocalPartitionStateByNode> localResult, Catalog catalog, Map<TablePartitionId, GlobalPartitionState> result, Set<Integer> partitionIds) {
        localResult.keySet().stream().map(TablePartitionId::tableId).distinct().forEach(tableId -> {
            CatalogTableDescriptor table = catalog.table(tableId.intValue());
            CatalogZoneDescriptor zoneDescriptor = catalog.zone(table.zoneId());
            CatalogSchemaDescriptor schemaDescriptor = catalog.schema(table.schemaId());
            if (partitionIds.isEmpty()) {
                int partitions = zoneDescriptor.partitions();
                for (int partitionId2 = 0; partitionId2 < partitions; ++partitionId2) {
                    DisasterRecoveryManager.putUnavailableStateIfAbsent(catalog, result, tableId, partitionId2, schemaDescriptor, zoneDescriptor);
                }
            } else {
                partitionIds.forEach(partitionId -> DisasterRecoveryManager.putUnavailableStateIfAbsent(catalog, result, tableId, partitionId, schemaDescriptor, zoneDescriptor));
            }
        });
    }

    private static void putUnavailableStateIfAbsent(Catalog catalog, Map<TablePartitionId, GlobalPartitionState> states, Integer tableId, int partitionId, CatalogSchemaDescriptor schemaDescriptor, CatalogZoneDescriptor zoneDescriptor) {
        TablePartitionId tablePartitionId = new TablePartitionId(tableId.intValue(), partitionId);
        states.computeIfAbsent(tablePartitionId, key -> new GlobalPartitionState(zoneDescriptor.name(), schemaDescriptor.name(), key.tableId(), catalog.table(key.tableId()).name(), key.partitionId(), GlobalPartitionStateEnum.UNAVAILABLE));
    }

    private static GlobalPartitionState assembleGlobalStateFromLocal(Catalog catalog, TablePartitionId tablePartitionId, LocalPartitionStateByNode map) {
        CatalogTableDescriptor table = catalog.table(tablePartitionId.tableId());
        CatalogSchemaDescriptor schemaDescriptor = catalog.schema(table.schemaId());
        CatalogZoneDescriptor zoneDescriptor = catalog.zone(table.zoneId());
        int replicas = zoneDescriptor.replicas();
        int quorum = replicas / 2 + 1;
        Map<LocalPartitionStateEnum, List<LocalPartitionState>> groupedStates = map.values().stream().collect(Collectors.groupingBy(localPartitionState -> localPartitionState.state));
        int healthyReplicas = groupedStates.getOrDefault(LocalPartitionStateEnum.HEALTHY, Collections.emptyList()).size();
        GlobalPartitionStateEnum globalStateEnum = healthyReplicas == replicas ? GlobalPartitionStateEnum.AVAILABLE : (healthyReplicas >= quorum ? GlobalPartitionStateEnum.DEGRADED : (healthyReplicas > 0 ? GlobalPartitionStateEnum.READ_ONLY : GlobalPartitionStateEnum.UNAVAILABLE));
        LocalPartitionState anyLocalState = map.values().iterator().next();
        return new GlobalPartitionState(zoneDescriptor.name(), schemaDescriptor.name(), anyLocalState.tableId, anyLocalState.tableName, tablePartitionId.partitionId(), globalStateEnum);
    }

    private Catalog catalogLatestVersion() {
        int catalogVersion = this.catalogManager.latestCatalogVersion();
        Catalog catalog = this.catalogManager.catalog(catalogVersion);
        assert (catalog != null) : catalogVersion;
        return catalog;
    }

    private static CatalogTableDescriptor tableDescriptor(Catalog catalog, String schemaName, String tableName) {
        CatalogTableDescriptor tableDescriptor = catalog.table(schemaName, tableName);
        if (tableDescriptor == null) {
            throw new TableNotFoundException(schemaName, tableName);
        }
        return tableDescriptor;
    }

    private static CatalogZoneDescriptor zoneDescriptor(Catalog catalog, String zoneName) {
        CatalogZoneDescriptor zoneDescriptor = catalog.zone(zoneName);
        if (zoneDescriptor == null) {
            throw new DistributionZoneNotFoundException(zoneName);
        }
        return zoneDescriptor;
    }

    private static ByteArray zoneRecoveryTriggerRevisionKey(int zoneId) {
        return new ByteArray(RECOVERY_TRIGGER_REVISION_KEY_PREFIX + zoneId);
    }

    ClusterNode localNode() {
        return this.topologyService.localMember();
    }

    private void onTableCreate(CreateTableEventParameters parameters) {
        this.registerPartitionStatesMetricSource(parameters.tableDescriptor());
    }

    private void onTableDrop(DropTableEventParameters parameters) {
        this.unregisterPartitionStatesMetricSource(parameters.tableId());
    }

    private void registerMetricSources() {
        int catalogVersion = this.catalogManager.latestCatalogVersion();
        this.catalogManager.tables(catalogVersion).forEach(this::registerPartitionStatesMetricSource);
    }

    private void registerPartitionStatesMetricSource(CatalogTableDescriptor tableDescriptor) {
        PartitionStatesMetricSource metricSource = new PartitionStatesMetricSource(tableDescriptor, this);
        PartitionStatesMetricSource previous = this.metricSourceByTableId.putIfAbsent(tableDescriptor.id(), metricSource);
        assert (previous == null) : "tableId=" + tableDescriptor.id();
        this.metricManager.registerSource((MetricSource)metricSource);
        this.metricManager.enable((MetricSource)metricSource);
    }

    private void unregisterPartitionStatesMetricSource(int tableId) {
        PartitionStatesMetricSource metricSource = this.metricSourceByTableId.get(tableId);
        assert (metricSource != null) : "tableId=" + tableId;
        this.metricManager.unregisterSource((MetricSource)metricSource);
    }
}

