/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.RecordMarshaller;
import org.apache.ignite.internal.table.AbstractClientStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.util.ColocationUtils;
import org.apache.ignite.internal.util.HashCalculator;
import org.apache.ignite.lang.MarshallerException;

class PojoStreamerPartitionAwarenessProvider<R>
extends AbstractClientStreamerPartitionAwarenessProvider<R> {
    private final RecordMarshaller<R> marsh;

    PojoStreamerPartitionAwarenessProvider(SchemaRegistry schemaReg, int partitions, RecordMarshaller<R> marsh) {
        super(schemaReg, partitions);
        assert (marsh != null);
        this.marsh = marsh;
    }

    @Override
    int colocationHash(SchemaDescriptor schema, R item) throws MarshallerException {
        HashCalculator hashCalc = new HashCalculator();
        for (Column c : schema.colocationColumns()) {
            Object val = this.marsh.value(item, c.positionInRow());
            ColocationUtils.append((HashCalculator)hashCalc, (Object)val, (NativeType)c.type());
        }
        return hashCalc.hash();
    }
}

