/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metrics.exporters.otlp;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Objects;
import org.apache.ignite3.internal.metrics.Metric;
import org.apache.ignite3.internal.util.Lazy;
import org.jetbrains.annotations.Nullable;

abstract class IgniteMetricData<T extends Metric>
implements MetricData {
    private final Lazy<Resource> resource;
    private final InstrumentationScopeInfo scope;
    private final T metric;

    IgniteMetricData(Lazy<Resource> resource, InstrumentationScopeInfo scope, T metric) {
        this.resource = resource;
        this.scope = scope;
        this.metric = metric;
    }

    public Resource getResource() {
        @Nullable Resource resource0 = this.resource.get();
        assert (resource0 != null);
        return resource0;
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.scope;
    }

    public String getName() {
        return this.metric.name();
    }

    public String getDescription() {
        return Objects.requireNonNull(this.metric.description(), "");
    }

    public String getUnit() {
        return "";
    }
}

