/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.placementdriver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite3.internal.distributionzones.rebalance.ZoneRebalanceUtil;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.EntryEvent;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.metastorage.Revisions;
import org.apache.ignite3.internal.metastorage.WatchEvent;
import org.apache.ignite3.internal.metastorage.WatchListener;
import org.apache.ignite3.internal.partitiondistribution.Assignment;
import org.apache.ignite3.internal.partitiondistribution.Assignments;
import org.apache.ignite3.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite3.internal.partitiondistribution.TokenizedAssignments;
import org.apache.ignite3.internal.partitiondistribution.TokenizedAssignmentsImpl;
import org.apache.ignite3.internal.placementdriver.AssignmentsPlacementDriver;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;

public class AssignmentsTracker
implements AssignmentsPlacementDriver {
    private static final IgniteLogger LOG = Loggers.forClass(AssignmentsTracker.class);
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final MetaStorageManager msManager;
    private final FailureProcessor failureProcessor;
    private final NodeProperties nodeProperties;
    private final Map<ReplicationGroupId, TokenizedAssignments> groupStableAssignments;
    private final WatchListener stableAssignmentsListener;
    private final Map<ReplicationGroupId, TokenizedAssignments> groupPendingAssignments;
    private final WatchListener pendingAssignmentsListener;

    public AssignmentsTracker(MetaStorageManager msManager, FailureProcessor failureProcessor, NodeProperties nodeProperties) {
        this.msManager = msManager;
        this.failureProcessor = failureProcessor;
        this.nodeProperties = nodeProperties;
        this.groupStableAssignments = new ConcurrentHashMap<ReplicationGroupId, TokenizedAssignments>();
        this.stableAssignmentsListener = this.createStableAssignmentsListener();
        this.groupPendingAssignments = new ConcurrentHashMap<ReplicationGroupId, TokenizedAssignments>();
        this.pendingAssignmentsListener = this.createPendingAssignmentsListener();
    }

    public void startTrack() {
        this.msManager.registerPrefixWatch(new ByteArray(this.pendingAssignmentsQueuePrefixBytes()), this.pendingAssignmentsListener);
        this.msManager.registerPrefixWatch(new ByteArray(this.stableAssignmentsPrefixBytes()), this.stableAssignmentsListener);
        ((CompletableFuture)this.msManager.recoveryFinishedFuture().thenAccept(recoveryRevisions -> {
            this.handleRecoveryAssignments((Revisions)recoveryRevisions, this.pendingAssignmentsQueuePrefixBytes(), this.groupPendingAssignments, bytes -> AssignmentsQueue.fromBytes(bytes).poll().nodes());
            this.handleRecoveryAssignments((Revisions)recoveryRevisions, this.stableAssignmentsPrefixBytes(), this.groupStableAssignments, bytes -> Assignments.fromBytes(bytes).nodes());
        })).whenComplete((res, ex) -> {
            if (ex != null) {
                this.failureProcessor.process(new FailureContext((Throwable)ex, "Failed to start assignment tracker due to recovery error"));
            } else if (LOG.isInfoEnabled()) {
                LOG.info("Assignment cache initialized for placement driver [stableAssignments=[{}], pendingAssignments=[{}]]", AssignmentsTracker.prepareAssignmentsForLogging(this.groupStableAssignments), AssignmentsTracker.prepareAssignmentsForLogging(this.groupPendingAssignments));
            }
        });
    }

    public void stopTrack() {
        this.msManager.unregisterWatch(this.pendingAssignmentsListener);
        this.msManager.unregisterWatch(this.stableAssignmentsListener);
    }

    @Override
    public CompletableFuture<List<TokenizedAssignments>> getAssignments(List<? extends ReplicationGroupId> replicationGroupIds, HybridTimestamp clusterTimeToAwait) {
        return this.msManager.clusterTime().waitFor(clusterTimeToAwait).thenApply(ignored -> IgniteUtils.inBusyLock(this.busyLock, () -> {
            Map<ReplicationGroupId, TokenizedAssignments> assignments = this.stableAssignments();
            return replicationGroupIds.stream().map(assignments::get).collect(Collectors.toList());
        }));
    }

    Map<ReplicationGroupId, TokenizedAssignments> stableAssignments() {
        return this.groupStableAssignments;
    }

    Map<ReplicationGroupId, TokenizedAssignments> pendingAssignments() {
        return this.groupPendingAssignments;
    }

    private WatchListener createStableAssignmentsListener() {
        return event -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stable assignments update [revision={}, keys={}]", event.revision(), AssignmentsTracker.collectKeysFromEventAsString(event));
            }
            this.handleReceivedAssignments(event, this.stableAssignmentsPrefixBytes(), this.groupStableAssignments, bytes -> Assignments.fromBytes(bytes).nodes());
            return CompletableFutures.nullCompletedFuture();
        };
    }

    private WatchListener createPendingAssignmentsListener() {
        return event -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pending assignments update [revision={}, keys={}]", event.revision(), AssignmentsTracker.collectKeysFromEventAsString(event));
            }
            this.handleReceivedAssignments(event, this.pendingAssignmentsQueuePrefixBytes(), this.groupPendingAssignments, bytes -> AssignmentsQueue.fromBytes(bytes).poll().nodes());
            return CompletableFutures.nullCompletedFuture();
        };
    }

    private void handleReceivedAssignments(WatchEvent event, byte[] assignmentsMetastoreKeyPrefix, Map<ReplicationGroupId, TokenizedAssignments> groupIdToAssignmentsMap, Function<byte[], Set<Assignment>> deserializer) {
        for (EntryEvent evt : event.entryEvents()) {
            Entry entry = evt.newEntry();
            ReplicationGroupId grpId = this.extractReplicationGroupPartitionId(entry.key(), assignmentsMetastoreKeyPrefix);
            if (entry.tombstone()) {
                groupIdToAssignmentsMap.remove(grpId);
                continue;
            }
            AssignmentsTracker.updateGroupAssignments(groupIdToAssignmentsMap, grpId, entry, deserializer);
        }
    }

    private void handleRecoveryAssignments(Revisions recoveryRevisions, byte[] assignmentsMetastoreKeyPrefix, Map<ReplicationGroupId, TokenizedAssignments> groupIdToAssignmentsMap, Function<byte[], Set<Assignment>> deserializer) {
        ByteArray prefix = new ByteArray(assignmentsMetastoreKeyPrefix);
        long revision = recoveryRevisions.revision();
        try (Cursor<Entry> cursor = this.msManager.prefixLocally(prefix, revision);){
            for (Entry entry : cursor) {
                if (entry.tombstone()) continue;
                ReplicationGroupId grpId = this.extractReplicationGroupPartitionId(entry.key(), assignmentsMetastoreKeyPrefix);
                AssignmentsTracker.updateGroupAssignments(groupIdToAssignmentsMap, grpId, entry, deserializer);
            }
        }
    }

    private static void updateGroupAssignments(Map<ReplicationGroupId, TokenizedAssignments> groupIdToAssignmentsMap, ReplicationGroupId grpId, Entry entry, Function<byte[], Set<Assignment>> deserializer) {
        byte[] value = entry.value();
        assert (value != null);
        Set<Assignment> assignmentNodes = deserializer.apply(value);
        groupIdToAssignmentsMap.put(grpId, new TokenizedAssignmentsImpl(assignmentNodes, entry.revision()));
    }

    private static String collectKeysFromEventAsString(WatchEvent event) {
        return event.entryEvents().stream().map(e -> new ByteArray(e.newEntry().key()).toString()).collect(Collectors.joining(","));
    }

    private static String prepareAssignmentsForLogging(Map<ReplicationGroupId, TokenizedAssignments> assignmentsMap) {
        class NodeAssignments {
            private List<ReplicationGroupId> peers;
            private List<ReplicationGroupId> learners;

            private NodeAssignments() {
            }

            private void addReplicationGroupId(ReplicationGroupId replicationGroupId, boolean isPeer) {
                List<ReplicationGroupId> peersOrLearners;
                if (isPeer) {
                    if (this.peers == null) {
                        this.peers = new ArrayList<ReplicationGroupId>();
                    }
                    peersOrLearners = this.peers;
                } else {
                    if (this.learners == null) {
                        this.learners = new ArrayList<ReplicationGroupId>();
                    }
                    peersOrLearners = this.learners;
                }
                peersOrLearners.add(replicationGroupId);
            }

            private boolean arePeersEmpty() {
                return this.peers == null || this.peers.isEmpty();
            }

            private boolean areLearnersEmpty() {
                return this.learners == null || this.learners.isEmpty();
            }
        }
        HashMap<String, NodeAssignments> assignmentsToLog = new HashMap<String, NodeAssignments>();
        for (Map.Entry<ReplicationGroupId, TokenizedAssignments> assignments : assignmentsMap.entrySet()) {
            for (Assignment assignment : assignments.getValue().nodes()) {
                assignmentsToLog.computeIfAbsent(assignment.consistentId(), k -> new NodeAssignments()).addReplicationGroupId(assignments.getKey(), assignment.isPeer());
            }
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : assignmentsToLog.entrySet()) {
            NodeAssignments value = (NodeAssignments)entry.getValue();
            if (value.arePeersEmpty() && value.areLearnersEmpty()) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append((String)entry.getKey()).append("=[");
            if (!value.arePeersEmpty()) {
                sb.append("peers=").append(value.peers);
                if (!value.areLearnersEmpty()) {
                    sb.append(", ");
                }
            }
            if (!value.areLearnersEmpty()) {
                sb.append("learners=").append(value.learners);
            }
            sb.append(']');
        }
        return sb.toString();
    }

    private byte[] pendingAssignmentsQueuePrefixBytes() {
        return this.nodeProperties.colocationEnabled() ? ZoneRebalanceUtil.PENDING_ASSIGNMENTS_QUEUE_PREFIX_BYTES : RebalanceUtil.PENDING_ASSIGNMENTS_QUEUE_PREFIX_BYTES;
    }

    private byte[] stableAssignmentsPrefixBytes() {
        return this.nodeProperties.colocationEnabled() ? ZoneRebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES : RebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES;
    }

    private ReplicationGroupId extractReplicationGroupPartitionId(byte[] key, byte[] prefix) {
        return this.nodeProperties.colocationEnabled() ? ZoneRebalanceUtil.extractZonePartitionId(key, prefix) : RebalanceUtil.extractTablePartitionId(key, prefix);
    }
}

