/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.builder;

import org.apache.ignite.binary.BinaryInvalidTypeException;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.builder.BinaryAbstractLazyValue;
import org.apache.ignite.internal.binary.builder.BinaryBuilderReader;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializer;
import org.apache.ignite.internal.binary.builder.BinaryLazyValue;
import org.apache.ignite.internal.util.typedef.internal.U;

class BinaryObjectArrayLazyValue
extends BinaryAbstractLazyValue {
    private Object[] lazyValsArr;
    private int compTypeId;
    private String clsName;

    protected BinaryObjectArrayLazyValue(BinaryBuilderReader reader) {
        super(reader, reader.position() - 1);
        int typeId = reader.readInt();
        if (typeId == 0) {
            Class<?> cls;
            this.clsName = reader.readString();
            try {
                cls = U.forName(reader.readString(), reader.binaryContext().configuration().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new BinaryInvalidTypeException("Failed to load the class: " + this.clsName, e);
            }
            this.compTypeId = reader.binaryContext().registerClass(cls, false, false).typeId();
        } else {
            this.compTypeId = typeId;
            this.clsName = null;
        }
        int size = reader.readInt();
        this.lazyValsArr = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.lazyValsArr[i] = reader.parseValue();
        }
    }

    @Override
    protected Object init() {
        for (int i = 0; i < this.lazyValsArr.length; ++i) {
            if (!(this.lazyValsArr[i] instanceof BinaryLazyValue)) continue;
            this.lazyValsArr[i] = ((BinaryLazyValue)this.lazyValsArr[i]).value();
        }
        return this.lazyValsArr;
    }

    @Override
    public void writeTo(BinaryWriterExImpl writer, BinaryBuilderSerializer ctx) {
        if (this.clsName == null) {
            ctx.writeArray(writer, (byte)23, this.lazyValsArr, this.compTypeId);
        } else {
            ctx.writeArray(writer, (byte)23, this.lazyValsArr, this.clsName);
        }
    }
}

