/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.defragmentation;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.store.PageStoreCollection;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.collection.IntRWHashMap;
import org.apache.ignite.internal.util.typedef.internal.S;

class PageStoreMap
implements PageStoreCollection {
    private final IntMap<IntMap<PageStore>> grpPageStoresMap = new IntRWHashMap<IntMap<PageStore>>();

    PageStoreMap() {
    }

    public void addPageStore(int grpId, int partId, PageStore pageStore) {
        IntMap<PageStore> pageStoresMap = this.grpPageStoresMap.get(grpId);
        if (pageStoresMap == null) {
            this.grpPageStoresMap.putIfAbsent(grpId, new IntRWHashMap());
            pageStoresMap = this.grpPageStoresMap.get(grpId);
        }
        pageStoresMap.put(partId, pageStore);
    }

    public void removePageStore(int grpId, int partId) {
        IntMap<PageStore> pageStoresMap = this.grpPageStoresMap.get(grpId);
        if (pageStoresMap != null) {
            pageStoresMap.remove(partId);
        }
    }

    public void clear(int grpId) {
        this.grpPageStoresMap.remove(grpId);
    }

    @Override
    public PageStore getStore(int grpId, int partId) throws IgniteCheckedException {
        IntMap<PageStore> partPageStoresMap = this.grpPageStoresMap.get(grpId);
        if (partPageStoresMap == null) {
            throw new IgniteCheckedException(S.toString("Page store map not found. ", "grpId", (Object)grpId, false, "partId", (Object)partId, false, "keys", (Object)Arrays.toString(this.grpPageStoresMap.keys()), false, "this", (Object)this.hashCode(), false));
        }
        PageStore pageStore = partPageStoresMap.get(partId);
        if (pageStore == null) {
            throw new IgniteCheckedException(S.toString("Page store not found. ", "grpId", (Object)grpId, false, "partId", (Object)partId, false, "keys", (Object)Arrays.toString(partPageStoresMap.keys()), false, "this", (Object)this.hashCode(), false));
        }
        return pageStore;
    }

    @Override
    public Collection<PageStore> getStores(int grpId) throws IgniteCheckedException {
        IntMap<PageStore> partPageStoresMap = this.grpPageStoresMap.get(grpId);
        if (partPageStoresMap == null) {
            throw new IgniteCheckedException(S.toString("Page store map not found. ", "grpId", (Object)grpId, false, "keys", (Object)Arrays.toString(this.grpPageStoresMap.keys()), false, "this", (Object)this.hashCode(), false));
        }
        return Arrays.asList(partPageStoresMap.values());
    }
}

