/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;

class SegmentCompressStorage {
    private final IgniteLogger log;
    private volatile boolean interrupted;
    private final boolean compactionEnabled;
    private volatile long lastCompressedIdx = -1L;
    private long lastEnqueuedToCompressIdx = -1L;
    private final Queue<Long> segmentsToCompress = new ArrayDeque<Long>();
    private final List<Long> compressingSegments = new ArrayList<Long>();
    private long lastMaxCompressedIdx = -1L;

    SegmentCompressStorage(IgniteLogger log, boolean compactionEnabled) {
        this.log = log;
        this.compactionEnabled = compactionEnabled;
    }

    synchronized void onSegmentCompressed(long compressedIdx) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Segment compressed notification [idx=" + compressedIdx + ']');
        }
        if (compressedIdx > this.lastMaxCompressedIdx) {
            this.lastMaxCompressedIdx = compressedIdx;
        }
        this.compressingSegments.remove(compressedIdx);
        this.lastCompressedIdx = !this.compressingSegments.isEmpty() ? Math.min(this.lastMaxCompressedIdx, this.compressingSegments.get(0) - 1L) : this.lastMaxCompressedIdx;
        if (compressedIdx > this.lastEnqueuedToCompressIdx) {
            this.lastEnqueuedToCompressIdx = compressedIdx;
        }
    }

    long lastCompressedIdx() {
        return this.lastCompressedIdx;
    }

    synchronized long nextSegmentToCompressOrWait() throws IgniteInterruptedCheckedException {
        try {
            while (this.segmentsToCompress.peek() == null && !this.interrupted) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        this.checkInterrupted();
        Long idx = this.segmentsToCompress.poll();
        assert (idx != null);
        this.compressingSegments.add(idx);
        return idx;
    }

    synchronized void interrupt() {
        this.interrupted = true;
        this.notifyAll();
    }

    private void checkInterrupted() throws IgniteInterruptedCheckedException {
        if (this.interrupted) {
            throw new IgniteInterruptedCheckedException("Interrupt waiting of change compressed idx");
        }
    }

    synchronized void onSegmentArchived(long lastAbsArchivedIdx) {
        while (this.lastEnqueuedToCompressIdx < lastAbsArchivedIdx && this.compactionEnabled) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Enqueuing segment for compression [idx=" + (this.lastEnqueuedToCompressIdx + 1L) + ']');
            }
            this.segmentsToCompress.add(++this.lastEnqueuedToCompressIdx);
        }
        this.notifyAll();
    }

    public void reset() {
        this.interrupted = false;
    }
}

