/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.performancestatistics.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.performancestatistics.handlers.IgnitePerformanceStatisticsHandler;
import org.apache.ignite.internal.performancestatistics.util.OrderedFixedSizeStructure;
import org.apache.ignite.internal.performancestatistics.util.Utils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class ComputeHandler
implements IgnitePerformanceStatisticsHandler {
    private final Map<String, AggregatedTaskInfo> taskRes = new HashMap<String, AggregatedTaskInfo>();
    private final Map<IgniteUuid, List<Job>> jobs = new HashMap<IgniteUuid, List<Job>>();
    private final OrderedFixedSizeStructure<Long, Task> topSlowTask = new OrderedFixedSizeStructure();

    @Override
    public void task(UUID nodeId, IgniteUuid sesId, String taskName, long startTime, long duration, int affPartId) {
        Task task = new Task(nodeId, sesId, taskName, startTime, duration, affPartId);
        this.topSlowTask.put(duration, task);
        AggregatedTaskInfo info = this.taskRes.computeIfAbsent(taskName, name -> new AggregatedTaskInfo());
        info.mergeTask(sesId, duration);
    }

    @Override
    public void job(UUID nodeId, IgniteUuid sesId, long queuedTime, long startTime, long duration, boolean timedOut) {
        Job job = new Job(nodeId, queuedTime, startTime, duration, timedOut);
        this.jobs.computeIfAbsent(sesId, uuid -> new LinkedList()).add(job);
    }

    @Override
    public Map<String, JsonNode> results() {
        ObjectNode taskJson = Utils.MAPPER.createObjectNode();
        this.taskRes.forEach((taskName, info) -> {
            info.ids.forEach(uuid -> {
                List<Job> jobs = this.jobs.get(uuid);
                if (jobs == null) {
                    return;
                }
                jobs.forEach(job -> {
                    ++info.jobsCnt;
                    info.jobsDuration += ((Job)job).duration;
                });
            });
            ObjectNode task = Utils.MAPPER.createObjectNode();
            task.put("count", info.count);
            task.put("duration", info.totalDuration);
            task.put("jobsCount", info.jobsCnt);
            task.put("jobsTotalDuration", info.jobsDuration);
            taskJson.set(taskName, (JsonNode)task);
        });
        ArrayNode topSlowJson = Utils.MAPPER.createArrayNode();
        this.topSlowTask.values().forEach(task -> {
            ObjectNode node = Utils.MAPPER.createObjectNode();
            long jobsTotalDuration = 0L;
            ArrayNode jobsJson = Utils.MAPPER.createArrayNode();
            for (Job job : this.jobs.get(((Task)task).sesId)) {
                ObjectNode jobJson = Utils.MAPPER.createObjectNode();
                jobJson.put("queuedTime", job.queuedTime);
                jobJson.put("startTime", job.startTime);
                jobJson.put("duration", job.duration);
                jobJson.put("isTimedOut", job.isTimedOut);
                jobJson.put("nodeId", String.valueOf(job.nodeId));
                jobsJson.add((JsonNode)jobJson);
                jobsTotalDuration += job.duration;
            }
            node.put("taskName", ((Task)task).taskName);
            node.put("startTime", ((Task)task).startTime);
            node.put("duration", ((Task)task).duration);
            node.put("affPartId", ((Task)task).affPartId);
            node.put("nodeId", String.valueOf(((Task)task).nodeId));
            node.put("jobsTotalDuration", jobsTotalDuration);
            node.set("jobs", (JsonNode)jobsJson);
            topSlowJson.add((JsonNode)node);
        });
        return U.map((Object)"compute", (Object)taskJson, (Object)"topSlowCompute", (Object)topSlowJson);
    }

    public static class Job {
        private final UUID nodeId;
        private final long queuedTime;
        private final long startTime;
        private final long duration;
        private final boolean isTimedOut;

        public Job(UUID nodeId, long queuedTime, long startTime, long duration, boolean isTimedOut) {
            this.nodeId = nodeId;
            this.queuedTime = queuedTime;
            this.startTime = startTime;
            this.duration = duration;
            this.isTimedOut = isTimedOut;
        }
    }

    public static class Task {
        private final UUID nodeId;
        private final IgniteUuid sesId;
        private final String taskName;
        private final long startTime;
        private final long duration;
        private final int affPartId;

        public Task(UUID id, IgniteUuid sesId, String taskName, long startTime, long duration, int affPartId) {
            this.nodeId = id;
            this.sesId = sesId;
            this.taskName = taskName;
            this.startTime = startTime;
            this.duration = duration;
            this.affPartId = affPartId;
        }
    }

    private static class AggregatedTaskInfo {
        long count;
        long totalDuration;
        long jobsCnt;
        long jobsDuration;
        final Set<IgniteUuid> ids = new HashSet<IgniteUuid>();

        private AggregatedTaskInfo() {
        }

        public void mergeTask(IgniteUuid sesId, long duration) {
            ++this.count;
            this.totalDuration += duration;
            this.ids.add(sesId);
        }
    }
}

