/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisChangeTrackingVersions;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.policy.PolicyMappingPersistence;

public interface BasePersistence
extends PolicyMappingPersistence {
    public long generateNewId(@Nonnull PolarisCallContext var1);

    public void writeEntity(@Nonnull PolarisCallContext var1, @Nonnull PolarisBaseEntity var2, boolean var3, @Nullable PolarisBaseEntity var4);

    public void writeEntities(@Nonnull PolarisCallContext var1, @Nonnull List<PolarisBaseEntity> var2, @Nullable List<PolarisBaseEntity> var3);

    public void writeToGrantRecords(@Nonnull PolarisCallContext var1, @Nonnull PolarisGrantRecord var2);

    public void deleteEntity(@Nonnull PolarisCallContext var1, @Nonnull PolarisBaseEntity var2);

    public void deleteFromGrantRecords(@Nonnull PolarisCallContext var1, @Nonnull PolarisGrantRecord var2);

    public void deleteAllEntityGrantRecords(@Nonnull PolarisCallContext var1, @Nonnull PolarisEntityCore var2, @Nonnull List<PolarisGrantRecord> var3, @Nonnull List<PolarisGrantRecord> var4);

    public void deleteAll(@Nonnull PolarisCallContext var1);

    @Nullable
    public PolarisBaseEntity lookupEntity(@Nonnull PolarisCallContext var1, long var2, long var4, int var6);

    @Nullable
    public PolarisBaseEntity lookupEntityByName(@Nonnull PolarisCallContext var1, long var2, long var4, int var6, @Nonnull String var7);

    @Nullable
    default public EntityNameLookupRecord lookupEntityIdAndSubTypeByName(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, int typeCode, @Nonnull String name) {
        PolarisBaseEntity baseEntity = this.lookupEntityByName(callCtx, catalogId, parentId, typeCode, name);
        if (baseEntity == null) {
            return null;
        }
        return new EntityNameLookupRecord(baseEntity);
    }

    @Nonnull
    public List<PolarisBaseEntity> lookupEntities(@Nonnull PolarisCallContext var1, List<PolarisEntityId> var2);

    @Nonnull
    public List<PolarisChangeTrackingVersions> lookupEntityVersions(@Nonnull PolarisCallContext var1, List<PolarisEntityId> var2);

    @Nonnull
    public Page<EntityNameLookupRecord> listEntities(@Nonnull PolarisCallContext var1, long var2, long var4, @Nonnull PolarisEntityType var6, @Nonnull PolarisEntitySubType var7, @Nonnull PageToken var8);

    @Nonnull
    public <T> Page<T> loadEntities(@Nonnull PolarisCallContext var1, long var2, long var4, @Nonnull PolarisEntityType var6, @Nonnull PolarisEntitySubType var7, @Nonnull Predicate<PolarisBaseEntity> var8, @Nonnull Function<PolarisBaseEntity, T> var9, PageToken var10);

    public int lookupEntityGrantRecordsVersion(@Nonnull PolarisCallContext var1, long var2, long var4);

    @Nullable
    public PolarisGrantRecord lookupGrantRecord(@Nonnull PolarisCallContext var1, long var2, long var4, long var6, long var8, int var10);

    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnSecurable(@Nonnull PolarisCallContext var1, long var2, long var4);

    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnGrantee(@Nonnull PolarisCallContext var1, long var2, long var4);

    public boolean hasChildren(@Nonnull PolarisCallContext var1, @Nullable PolarisEntityType var2, long var3, long var5);

    default public <T extends PolarisEntity> Optional<Optional<String>> hasOverlappingSiblings(@Nonnull PolarisCallContext callContext, T entity) {
        return Optional.empty();
    }

    default public BasePersistence detach() {
        return this;
    }
}

