/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisGrantRecord;

public class ResolvedPolarisEntity {
    private final PolarisEntity entity;
    private final List<PolarisGrantRecord> grantRecordsAsGrantee;
    private final List<PolarisGrantRecord> grantRecordsAsSecurable;

    public ResolvedPolarisEntity(@Nonnull PolarisDiagnostics diagnostics, @Nonnull PolarisBaseEntity entity, @Nonnull List<PolarisGrantRecord> grantRecords, int grantsVersion) {
        diagnostics.checkNotNull(entity, "entity_null");
        diagnostics.checkNotNull(grantRecords, "grant_records_null");
        if (entity.getGrantRecordsVersion() != grantsVersion) {
            diagnostics.check(entity.getGrantRecordsVersion() <= grantsVersion, "grants_version_going_backward", "entity={} grantsVersion={}", entity, grantsVersion);
            this.entity = PolarisEntity.of(entity.withGrantRecordsVersion(grantsVersion));
        } else {
            this.entity = PolarisEntity.of(entity);
        }
        this.grantRecordsAsGrantee = grantRecords.stream().filter(record -> record.getGranteeId() == entity.getId()).collect(Collectors.toList());
        this.grantRecordsAsSecurable = grantRecords.stream().filter(record -> record.getSecurableId() == entity.getId()).collect(Collectors.toList());
    }

    public ResolvedPolarisEntity(PolarisEntity entity, List<PolarisGrantRecord> grantRecordsAsGrantee, List<PolarisGrantRecord> grantRecordsAsSecurable) {
        this.entity = entity;
        this.grantRecordsAsGrantee = grantRecordsAsGrantee;
        this.grantRecordsAsSecurable = grantRecordsAsSecurable;
    }

    public PolarisEntity getEntity() {
        return this.entity;
    }

    @Nonnull
    public List<PolarisGrantRecord> getAllGrantRecords() {
        return Stream.concat(this.grantRecordsAsGrantee.stream(), this.grantRecordsAsSecurable.stream()).collect(Collectors.toList());
    }

    public List<PolarisGrantRecord> getGrantRecordsAsGrantee() {
        return this.grantRecordsAsGrantee;
    }

    public List<PolarisGrantRecord> getGrantRecordsAsSecurable() {
        return this.grantRecordsAsSecurable;
    }

    public String toString() {
        return "entity:" + String.valueOf(this.entity) + ";grantRecordsAsGrantee:" + String.valueOf(this.grantRecordsAsGrantee) + ";grantRecordsAsSecurable:" + String.valueOf(this.grantRecordsAsSecurable);
    }
}

