/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.azure;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.file.datalake.DataLakeFileSystemClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import com.azure.storage.file.datalake.sas.PathSasPermission;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.storage.AccessConfig;
import org.apache.polaris.core.storage.InMemoryStorageIntegration;
import org.apache.polaris.core.storage.StorageAccessProperty;
import org.apache.polaris.core.storage.azure.AzureLocation;
import org.apache.polaris.core.storage.azure.AzureStorageConfigurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AzureCredentialsStorageIntegration
extends InMemoryStorageIntegration<AzureStorageConfigurationInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureCredentialsStorageIntegration.class);
    final DefaultAzureCredential defaultAzureCredential = new DefaultAzureCredentialBuilder().build();

    public AzureCredentialsStorageIntegration(AzureStorageConfigurationInfo config) {
        super(config, AzureCredentialsStorageIntegration.class.getName());
    }

    @Override
    public AccessConfig getSubscopedCreds(@Nonnull RealmConfig realmConfig, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations, Optional<String> refreshCredentialsEndpoint) {
        String sasToken;
        OffsetDateTime maxAllowedEndTime;
        String loc;
        String string = loc = !allowedWriteLocations.isEmpty() ? (String)allowedWriteLocations.stream().findAny().orElse(null) : (String)allowedReadLocations.stream().findAny().orElse(null);
        if (loc == null) {
            throw new IllegalArgumentException("Expect valid location");
        }
        AzureLocation location = new AzureLocation(loc);
        this.validateAccountAndContainer(location, allowedReadLocations, allowedWriteLocations);
        String storageDnsName = location.getStorageAccount() + "." + location.getEndpoint();
        String filePath = location.getFilePath();
        BlobSasPermission blobSasPermission = new BlobSasPermission();
        PathSasPermission pathSasPermission = new PathSasPermission();
        if (allowListOperation) {
            blobSasPermission.setListPermission(true);
            pathSasPermission.setListPermission(true);
        }
        if (!allowedReadLocations.isEmpty()) {
            blobSasPermission.setReadPermission(true);
            pathSasPermission.setReadPermission(true);
        }
        if (!allowedWriteLocations.isEmpty()) {
            blobSasPermission.setAddPermission(true);
            blobSasPermission.setWritePermission(true);
            blobSasPermission.setDeletePermission(true);
            pathSasPermission.setAddPermission(true);
            pathSasPermission.setWritePermission(true);
            pathSasPermission.setDeletePermission(true);
        }
        Instant start = Instant.now();
        OffsetDateTime expiry = OffsetDateTime.ofInstant(start.plusSeconds(3600L), ZoneOffset.UTC);
        AccessToken accessToken = this.getAccessToken(((AzureStorageConfigurationInfo)this.config()).getTenantId());
        OffsetDateTime startTime = start.truncatedTo(ChronoUnit.SECONDS).atOffset(ZoneOffset.UTC);
        int intendedDurationSeconds = realmConfig.getConfig(FeatureConfiguration.STORAGE_CREDENTIAL_DURATION_SECONDS);
        OffsetDateTime intendedEndTime = start.plusSeconds(intendedDurationSeconds).atOffset(ZoneOffset.UTC);
        OffsetDateTime sanitizedEndTime = intendedEndTime.isBefore(maxAllowedEndTime = start.plus(Period.ofDays(7)).minusSeconds(60L).atOffset(ZoneOffset.UTC)) ? intendedEndTime : maxAllowedEndTime;
        LOGGER.atDebug().addKeyValue("allowedListAction", (Object)allowListOperation).addKeyValue("allowedReadLoc", allowedReadLocations).addKeyValue("allowedWriteLoc", allowedWriteLocations).addKeyValue("location", (Object)loc).addKeyValue("storageAccount", (Object)location.getStorageAccount()).addKeyValue("endpoint", (Object)location.getEndpoint()).addKeyValue("container", (Object)location.getContainer()).addKeyValue("filePath", (Object)filePath).log("Subscope Azure SAS");
        if (location.getEndpoint().equalsIgnoreCase("blob.core.windows.net")) {
            sasToken = this.getBlobUserDelegationSas(startTime, sanitizedEndTime, expiry, storageDnsName, location.getContainer(), blobSasPermission, (Mono<AccessToken>)Mono.just((Object)accessToken));
        } else if (location.getEndpoint().equalsIgnoreCase("dfs.core.windows.net")) {
            sasToken = this.getAdlsUserDelegationSas(startTime, sanitizedEndTime, expiry, storageDnsName, location.getContainer(), pathSasPermission, (Mono<AccessToken>)Mono.just((Object)accessToken));
        } else {
            throw new RuntimeException(String.format("Endpoint %s not supported", location.getEndpoint()));
        }
        return AzureCredentialsStorageIntegration.toAccessConfig(sasToken, storageDnsName, sanitizedEndTime.toInstant(), refreshCredentialsEndpoint);
    }

    @VisibleForTesting
    static AccessConfig toAccessConfig(String sasToken, String storageDnsName, Instant expiresAt, Optional<String> refreshCredentialsEndpoint) {
        AccessConfig.Builder accessConfig = AccessConfig.builder();
        AzureCredentialsStorageIntegration.handleAzureCredential(accessConfig, sasToken, storageDnsName);
        accessConfig.put(StorageAccessProperty.EXPIRATION_TIME, String.valueOf(expiresAt.toEpochMilli()));
        refreshCredentialsEndpoint.ifPresent(endpoint -> accessConfig.put(StorageAccessProperty.AZURE_REFRESH_CREDENTIALS_ENDPOINT, (String)endpoint));
        return accessConfig.build();
    }

    private static void handleAzureCredential(AccessConfig.Builder config, String sasToken, String host) {
        String withSuffixStripped;
        int suffixIndex;
        config.putCredential(StorageAccessProperty.AZURE_SAS_TOKEN.getPropertyName() + host, sasToken);
        if (host.endsWith("dfs.core.windows.net") && (suffixIndex = host.lastIndexOf("dfs.core.windows.net") - 1) > 0) {
            withSuffixStripped = host.substring(0, suffixIndex);
            config.putCredential(StorageAccessProperty.AZURE_SAS_TOKEN.getPropertyName() + withSuffixStripped, sasToken);
        }
        if (host.endsWith("blob.core.windows.net") && (suffixIndex = host.lastIndexOf("blob.core.windows.net") - 1) > 0) {
            withSuffixStripped = host.substring(0, suffixIndex);
            config.putCredential(StorageAccessProperty.AZURE_SAS_TOKEN.getPropertyName() + withSuffixStripped, sasToken);
        }
    }

    private String getBlobUserDelegationSas(OffsetDateTime startTime, OffsetDateTime keyEndtime, OffsetDateTime sasExpiry, String storageDnsName, String container, BlobSasPermission blobSasPermission, Mono<AccessToken> accessTokenMono) {
        String endpoint = "https://" + storageDnsName;
        try {
            BlobServiceClient serviceClient = new BlobServiceClientBuilder().endpoint(endpoint).credential(c -> accessTokenMono).buildClient();
            UserDelegationKey userDelegationKey = serviceClient.getUserDelegationKey(startTime, keyEndtime);
            BlobServiceSasSignatureValues sigValues = new BlobServiceSasSignatureValues(sasExpiry, blobSasPermission);
            return new BlobContainerClientBuilder().endpoint(endpoint).containerName(container).buildClient().generateUserDelegationSas(sigValues, userDelegationKey);
        }
        catch (BlobStorageException ex) {
            LOGGER.debug("Azure DataLakeStorageException for getBlobUserDelegationSas. keyStart={} keyEnd={}, storageDns={}, container={}", new Object[]{startTime, keyEndtime, storageDnsName, container, ex});
            throw ex;
        }
    }

    private String getAdlsUserDelegationSas(OffsetDateTime startTime, OffsetDateTime endTime, OffsetDateTime sasExpiry, String storageDnsName, String fileSystemNameOrContainer, PathSasPermission pathSasPermission, Mono<AccessToken> accessTokenMono) {
        String endpoint = "https://" + storageDnsName;
        try {
            DataLakeServiceClient dataLakeServiceClient = new DataLakeServiceClientBuilder().endpoint(endpoint).credential(c -> accessTokenMono).buildClient();
            com.azure.storage.file.datalake.models.UserDelegationKey userDelegationKey = dataLakeServiceClient.getUserDelegationKey(startTime, endTime);
            DataLakeServiceSasSignatureValues signatureValues = new DataLakeServiceSasSignatureValues(sasExpiry, pathSasPermission);
            return new DataLakeFileSystemClientBuilder().endpoint(endpoint).fileSystemName(fileSystemNameOrContainer).buildClient().generateUserDelegationSas(signatureValues, userDelegationKey);
        }
        catch (DataLakeStorageException ex) {
            LOGGER.debug("Azure DataLakeStorageException for getAdlsUserDelegationSas. keyStart={} keyEnd={}, storageDns={}, fileSystemName={}", new Object[]{startTime, endTime, storageDnsName, fileSystemNameOrContainer, ex});
            throw ex;
        }
    }

    private void validateAccountAndContainer(AzureLocation target, Set<String> readLocations, Set<String> writeLocations) {
        HashSet<String> allLocations = new HashSet<String>();
        allLocations.addAll(readLocations);
        allLocations.addAll(writeLocations);
        allLocations.forEach(loc -> {
            AzureLocation location = new AzureLocation((String)loc);
            if (!(Objects.equals(location.getStorageAccount(), target.getStorageAccount()) && Objects.equals(location.getContainer(), target.getContainer()) && Objects.equals(location.getEndpoint(), target.getEndpoint()))) {
                throw new RuntimeException("Expect allowed read write locations belong to the same storage account and container");
            }
        });
    }

    private AccessToken getAccessToken(String tenantId) {
        String scope = "https://storage.azure.com/.default";
        AccessToken accessToken = this.defaultAzureCredential.getToken(new TokenRequestContext().addScopes(new String[]{scope}).setTenantId(tenantId)).blockOptional().orElse(null);
        if (accessToken == null) {
            throw new RuntimeException("No access token fetched!");
        }
        return accessToken;
    }
}

