/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import org.apache.iceberg.aws.s3.AnalyticsAcceleratorUtil;
import org.apache.iceberg.aws.s3.BaseS3File;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.aws.s3.S3InputStream;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.encryption.NativeFileCryptoParameters;
import org.apache.iceberg.encryption.NativelyEncryptedFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.metrics.MetricsContext;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;

public class S3InputFile
extends BaseS3File
implements InputFile,
NativelyEncryptedFile {
    private NativeFileCryptoParameters nativeDecryptionParameters;
    private Long length;

    public static S3InputFile fromLocation(String location, S3Client client, S3FileIOProperties s3FileIOProperties, MetricsContext metrics) {
        return new S3InputFile(client, null, new S3URI(location, s3FileIOProperties.bucketToAccessPointMapping()), null, s3FileIOProperties, metrics);
    }

    public static S3InputFile fromLocation(String location, S3Client client, S3AsyncClient asyncClient, S3FileIOProperties s3FileIOProperties, MetricsContext metrics) {
        return new S3InputFile(client, asyncClient, new S3URI(location, s3FileIOProperties.bucketToAccessPointMapping()), null, s3FileIOProperties, metrics);
    }

    public static S3InputFile fromLocation(String location, long length, S3Client client, S3FileIOProperties s3FileIOProperties, MetricsContext metrics) {
        return new S3InputFile(client, null, new S3URI(location, s3FileIOProperties.bucketToAccessPointMapping()), length > 0L ? Long.valueOf(length) : null, s3FileIOProperties, metrics);
    }

    public static S3InputFile fromLocation(String location, long length, S3Client client, S3AsyncClient asyncClient, S3FileIOProperties s3FileIOProperties, MetricsContext metrics) {
        return new S3InputFile(client, asyncClient, new S3URI(location, s3FileIOProperties.bucketToAccessPointMapping()), length > 0L ? Long.valueOf(length) : null, s3FileIOProperties, metrics);
    }

    S3InputFile(S3Client client, S3AsyncClient asyncClient, S3URI uri, Long length, S3FileIOProperties s3FileIOProperties, MetricsContext metrics) {
        super(client, asyncClient, uri, s3FileIOProperties, metrics);
        this.length = length;
    }

    public long getLength() {
        if (this.length == null) {
            this.length = this.getObjectMetadata().contentLength();
        }
        return this.length;
    }

    public SeekableInputStream newStream() {
        if (this.s3FileIOProperties().isS3AnalyticsAcceleratorEnabled()) {
            return AnalyticsAcceleratorUtil.newStream(this);
        }
        return new S3InputStream(this.client(), this.uri(), this.s3FileIOProperties(), this.metrics());
    }

    public NativeFileCryptoParameters nativeCryptoParameters() {
        return this.nativeDecryptionParameters;
    }

    public void setNativeCryptoParameters(NativeFileCryptoParameters nativeCryptoParameters) {
        this.nativeDecryptionParameters = nativeCryptoParameters;
    }
}

