/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.api;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;
import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.catalog.api.PolarisCatalogPolicyApiService;
import org.apache.polaris.service.types.AttachPolicyRequest;
import org.apache.polaris.service.types.CreatePolicyRequest;
import org.apache.polaris.service.types.DetachPolicyRequest;
import org.apache.polaris.service.types.UpdatePolicyRequest;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/catalog/polaris/v1/{prefix}")
public class PolarisCatalogPolicyApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisCatalogPolicyApi.class);
    private final PolarisCatalogPolicyApiService service;

    @Inject
    public PolarisCatalogPolicyApi(PolarisCatalogPolicyApiService service) {
        this.service = service;
    }

    @PUT
    @Path(value="/namespaces/{namespace}/policies/{policy-name}/mappings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.PolicyApi.attachPolicy")
    @Timeout
    public Response attachPolicy(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @Pattern(regexp="^[A-Za-z0-9\\-_]+$") @PathParam(value="policy-name") @Pattern(regexp="^[A-Za-z0-9\\-_]+$") String policyName, @Nonnull @Valid AttachPolicyRequest attachPolicyRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking PolicyApi with params").addKeyValue("operation", (Object)"attachPolicy").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("policyName", (Object)policyName).addKeyValue("attachPolicyRequest", (Object)String.valueOf(attachPolicyRequest)).log();
        Response ret = this.service.attachPolicy(prefix, namespace, policyName, attachPolicyRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of attachPolicy API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/namespaces/{namespace}/policies")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.PolicyApi.createPolicy")
    @Timeout
    public Response createPolicy(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @Nonnull @Valid CreatePolicyRequest createPolicyRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking PolicyApi with params").addKeyValue("operation", (Object)"createPolicy").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("createPolicyRequest", (Object)String.valueOf(createPolicyRequest)).log();
        Response ret = this.service.createPolicy(prefix, namespace, createPolicyRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of createPolicy API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/namespaces/{namespace}/policies/{policy-name}/mappings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.PolicyApi.detachPolicy")
    @Timeout
    public Response detachPolicy(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @Pattern(regexp="^[A-Za-z0-9\\-_]+$") @PathParam(value="policy-name") @Pattern(regexp="^[A-Za-z0-9\\-_]+$") String policyName, @Nonnull @Valid DetachPolicyRequest detachPolicyRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking PolicyApi with params").addKeyValue("operation", (Object)"detachPolicy").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("policyName", (Object)policyName).addKeyValue("detachPolicyRequest", (Object)String.valueOf(detachPolicyRequest)).log();
        Response ret = this.service.detachPolicy(prefix, namespace, policyName, detachPolicyRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of detachPolicy API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @DELETE
    @Path(value="/namespaces/{namespace}/policies/{policy-name}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.PolicyApi.dropPolicy")
    @Timeout
    public Response dropPolicy(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @Pattern(regexp="^[A-Za-z0-9\\-_]+$") @PathParam(value="policy-name") @Pattern(regexp="^[A-Za-z0-9\\-_]+$") String policyName, @QueryParam(value="detach-all") Boolean detachAll, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking PolicyApi with params").addKeyValue("operation", (Object)"dropPolicy").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("policyName", (Object)policyName).addKeyValue("detachAll", (Object)detachAll).log();
        Response ret = this.service.dropPolicy(prefix, namespace, policyName, detachAll, realmContext, securityContext);
        LOGGER.debug("Completed execution of dropPolicy API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/applicable-policies")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.PolicyApi.getApplicablePolicies")
    @Timeout
    public Response getApplicablePolicies(@PathParam(value="prefix") String prefix, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") @Min(value=1L) @Min(value=1L) Integer pageSize, @QueryParam(value="namespace") String namespace, @QueryParam(value="target-name") String targetName, @QueryParam(value="policyType") String policyType, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking PolicyApi with params").addKeyValue("operation", (Object)"getApplicablePolicies").addKeyValue("prefix", (Object)prefix).addKeyValue("pageToken", (Object)pageToken).addKeyValue("pageSize", (Object)pageSize).addKeyValue("namespace", (Object)namespace).addKeyValue("targetName", (Object)targetName).addKeyValue("policyType", (Object)policyType).log();
        Response ret = this.service.getApplicablePolicies(prefix, pageToken, pageSize, namespace, targetName, policyType, realmContext, securityContext);
        LOGGER.debug("Completed execution of getApplicablePolicies API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/namespaces/{namespace}/policies")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.PolicyApi.listPolicies")
    @Timeout
    public Response listPolicies(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") @Min(value=1L) @Min(value=1L) Integer pageSize, @QueryParam(value="policyType") String policyType, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking PolicyApi with params").addKeyValue("operation", (Object)"listPolicies").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("pageToken", (Object)pageToken).addKeyValue("pageSize", (Object)pageSize).addKeyValue("policyType", (Object)policyType).log();
        Response ret = this.service.listPolicies(prefix, namespace, pageToken, pageSize, policyType, realmContext, securityContext);
        LOGGER.debug("Completed execution of listPolicies API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/namespaces/{namespace}/policies/{policy-name}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.PolicyApi.loadPolicy")
    @Timeout
    public Response loadPolicy(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @Pattern(regexp="^[A-Za-z0-9\\-_]+$") @PathParam(value="policy-name") @Pattern(regexp="^[A-Za-z0-9\\-_]+$") String policyName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking PolicyApi with params").addKeyValue("operation", (Object)"loadPolicy").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("policyName", (Object)policyName).log();
        Response ret = this.service.loadPolicy(prefix, namespace, policyName, realmContext, securityContext);
        LOGGER.debug("Completed execution of loadPolicy API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @PUT
    @Path(value="/namespaces/{namespace}/policies/{policy-name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.PolicyApi.updatePolicy")
    @Timeout
    public Response updatePolicy(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @Pattern(regexp="^[A-Za-z0-9\\-_]+$") @PathParam(value="policy-name") @Pattern(regexp="^[A-Za-z0-9\\-_]+$") String policyName, @Nonnull @Valid UpdatePolicyRequest updatePolicyRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking PolicyApi with params").addKeyValue("operation", (Object)"updatePolicy").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("policyName", (Object)policyName).addKeyValue("updatePolicyRequest", (Object)String.valueOf(updatePolicyRequest)).log();
        Response ret = this.service.updatePolicy(prefix, namespace, policyName, updatePolicyRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of updatePolicy API with status code {}", (Object)ret.getStatus());
        return ret;
    }
}

