/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.wrapper;

import io.agroal.pool.ConnectionHandler;
import io.agroal.pool.util.AutoCloseableElement;
import io.agroal.pool.wrapper.ConnectionWrapper;
import io.agroal.pool.wrapper.XAResourceWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public final class XAConnectionWrapper
extends AutoCloseableElement
implements XAConnection {
    private static final String CLOSED_HANDLER_STRING = XAConnectionWrapper.class.getSimpleName() + ".CLOSED_XA_CONNECTION";
    private static final InvocationHandler CLOSED_HANDLER = (proxy, method, args) -> {
        switch (method.getName()) {
            case "close": {
                return Void.TYPE;
            }
            case "isClosed": {
                return Boolean.TRUE;
            }
            case "toString": {
                return CLOSED_HANDLER_STRING;
            }
        }
        throw new SQLException("XAConnection is closed");
    };
    private static final XAConnection CLOSED_XA_CONNECTION = (XAConnection)Proxy.newProxyInstance(XAConnection.class.getClassLoader(), new Class[]{XAConnection.class}, CLOSED_HANDLER);
    private final AutoCloseableElement trackedXAResources;
    private final ConnectionHandler handler;
    private XAConnection wrappedXAConnection;

    public XAConnectionWrapper(ConnectionHandler connectionHandler, XAConnection xaConnection, boolean trackResources) {
        super(null);
        this.handler = connectionHandler;
        this.wrappedXAConnection = xaConnection;
        this.trackedXAResources = trackResources ? XAConnectionWrapper.newHead() : null;
    }

    private XAResource trackXAResource(XAResource resource) {
        if (this.trackedXAResources != null && resource != null) {
            return new XAResourceWrapper(this.handler, resource, this.trackedXAResources);
        }
        return resource;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.wrappedXAConnection == CLOSED_XA_CONNECTION;
    }

    @Override
    public void close() throws SQLException {
        this.handler.traceConnectionOperation("close()");
        if (this.wrappedXAConnection != CLOSED_XA_CONNECTION) {
            this.wrappedXAConnection = CLOSED_XA_CONNECTION;
            this.trackedXAResources.closeAllAutocloseableElements();
            this.handler.transactionEnd();
        }
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        try {
            this.handler.traceConnectionOperation("getXAResource()");
            this.handler.verifyEnlistment();
            return this.trackXAResource(this.handler.getXaResource());
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            this.handler.traceConnectionOperation("getConnection()");
            this.handler.verifyEnlistment();
            return new ConnectionWrapper(this.handler, this.trackedXAResources != null, true);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.handler.traceConnectionOperation("addConnectionEventListener()");
        this.wrappedXAConnection.addConnectionEventListener(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.handler.traceConnectionOperation("removeConnectionEventListener()");
        this.wrappedXAConnection.removeConnectionEventListener(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.handler.traceConnectionOperation("addStatementEventListener()");
        this.wrappedXAConnection.addStatementEventListener(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.handler.traceConnectionOperation("removeStatementEventListener()");
        this.wrappedXAConnection.removeStatementEventListener(listener);
    }
}

