/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc.models;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;
import org.apache.polaris.persistence.relational.jdbc.DatabaseType;
import org.apache.polaris.persistence.relational.jdbc.models.Converter;

public class ModelPolicyMappingRecord
implements Converter<PolarisPolicyMappingRecord> {
    public static final String TABLE_NAME = "POLICY_MAPPING_RECORD";
    public static final List<String> ALL_COLUMNS = List.of("target_catalog_id", "target_id", "policy_type_code", "policy_catalog_id", "policy_id", "parameters");
    private long targetCatalogId;
    private long targetId;
    private int policyTypeCode;
    private long policyCatalogId;
    private long policyId;
    private String parameters;

    public long getTargetCatalogId() {
        return this.targetCatalogId;
    }

    public long getTargetId() {
        return this.targetId;
    }

    public int getPolicyTypeCode() {
        return this.policyTypeCode;
    }

    public long getPolicyCatalogId() {
        return this.policyCatalogId;
    }

    public long getPolicyId() {
        return this.policyId;
    }

    public String getParameters() {
        return this.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModelPolicyMappingRecord fromPolicyMappingRecord(PolarisPolicyMappingRecord record) {
        if (record == null) {
            return null;
        }
        return ModelPolicyMappingRecord.builder().targetCatalogId(record.getTargetCatalogId()).targetId(record.getTargetId()).policyTypeCode(record.getPolicyTypeCode()).policyCatalogId(record.getPolicyCatalogId()).policyId(record.getPolicyId()).parameters(record.getParameters()).build();
    }

    public static PolarisPolicyMappingRecord toPolicyMappingRecord(ModelPolicyMappingRecord model) {
        if (model == null) {
            return null;
        }
        return new PolarisPolicyMappingRecord(model.getTargetCatalogId(), model.getTargetId(), model.getPolicyCatalogId(), model.getPolicyId(), model.getPolicyTypeCode(), model.getParameters());
    }

    @Override
    public PolarisPolicyMappingRecord fromResultSet(ResultSet rs) throws SQLException {
        ModelPolicyMappingRecord modelRecord = ModelPolicyMappingRecord.builder().targetCatalogId(rs.getObject("target_catalog_id", Long.class)).targetId(rs.getObject("target_id", Long.class)).policyTypeCode(rs.getObject("policy_type_code", Integer.class)).policyCatalogId(rs.getObject("policy_catalog_id", Long.class)).policyId(rs.getObject("policy_id", Long.class)).parameters(rs.getString("parameters")).build();
        return ModelPolicyMappingRecord.toPolicyMappingRecord(modelRecord);
    }

    @Override
    public Map<String, Object> toMap(DatabaseType databaseType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("target_catalog_id", this.targetCatalogId);
        map.put("target_id", this.targetId);
        map.put("policy_type_code", this.policyTypeCode);
        map.put("policy_catalog_id", this.policyCatalogId);
        map.put("policy_id", this.policyId);
        if (databaseType.equals((Object)DatabaseType.POSTGRES)) {
            map.put("parameters", this.toJsonbPGobject(this.getParameters()));
        } else {
            map.put("parameters", this.getParameters());
        }
        return map;
    }

    public static final class Builder {
        private final ModelPolicyMappingRecord policyMappingRecord = new ModelPolicyMappingRecord();

        private Builder() {
        }

        public Builder targetCatalogId(long targetCatalogId) {
            this.policyMappingRecord.targetCatalogId = targetCatalogId;
            return this;
        }

        public Builder targetId(long targetId) {
            this.policyMappingRecord.targetId = targetId;
            return this;
        }

        public Builder policyTypeCode(int policyTypeCode) {
            this.policyMappingRecord.policyTypeCode = policyTypeCode;
            return this;
        }

        public Builder policyCatalogId(long policyCatalogId) {
            this.policyMappingRecord.policyCatalogId = policyCatalogId;
            return this;
        }

        public Builder policyId(long policyId) {
            this.policyMappingRecord.policyId = policyId;
            return this;
        }

        public Builder parameters(String parameters) {
            this.policyMappingRecord.parameters = parameters;
            return this;
        }

        public ModelPolicyMappingRecord build() {
            return this.policyMappingRecord;
        }
    }
}

