/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.invocation;

import io.smallrye.faulttolerance.core.Completer;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import io.smallrye.faulttolerance.core.invocation.Invoker;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

public class CompletionStageSupport<T>
implements AsyncSupport<T, CompletionStage<T>> {
    @Override
    public String mustDescription() {
        return "return " + CompletionStage.class.getSimpleName();
    }

    @Override
    public String doesDescription() {
        return "returns " + CompletionStage.class.getSimpleName();
    }

    @Override
    public boolean applies(Class<?>[] parameterTypes, Class<?> returnType) {
        return CompletionStage.class.equals(returnType);
    }

    @Override
    public CompletionStage<T> createComplete(T value) {
        return CompletableFuture.completedFuture(value);
    }

    @Override
    public Future<T> toFuture(Invoker<CompletionStage<T>> invoker) {
        Completer completer = Completer.create();
        try {
            invoker.proceed().whenComplete((value, error) -> {
                if (error == null) {
                    completer.complete(value);
                } else if (error instanceof CompletionException) {
                    completer.completeWithError(error.getCause());
                } else {
                    completer.completeWithError((Throwable)error);
                }
            });
        }
        catch (Exception e) {
            completer.completeWithError(e);
        }
        return completer.future();
    }

    @Override
    public CompletionStage<T> fromFuture(Invoker<Future<T>> invoker) {
        CompletableFuture result = new CompletableFuture();
        try {
            invoker.proceed().then((value, error) -> {
                if (error == null) {
                    result.complete(value);
                } else {
                    result.completeExceptionally((Throwable)error);
                }
            });
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        return result;
    }
}

