/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.admin;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.polaris.core.admin.model.AddGrantRequest;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.AwsStorageConfigInfo;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogGrant;
import org.apache.polaris.core.admin.model.CatalogRole;
import org.apache.polaris.core.admin.model.CatalogRoles;
import org.apache.polaris.core.admin.model.Catalogs;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.CreateCatalogRequest;
import org.apache.polaris.core.admin.model.CreateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.CreatePrincipalRequest;
import org.apache.polaris.core.admin.model.CreatePrincipalRoleRequest;
import org.apache.polaris.core.admin.model.ExternalCatalog;
import org.apache.polaris.core.admin.model.GrantCatalogRoleRequest;
import org.apache.polaris.core.admin.model.GrantPrincipalRoleRequest;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.GrantResources;
import org.apache.polaris.core.admin.model.NamespaceGrant;
import org.apache.polaris.core.admin.model.PolicyGrant;
import org.apache.polaris.core.admin.model.Principal;
import org.apache.polaris.core.admin.model.PrincipalRole;
import org.apache.polaris.core.admin.model.PrincipalRoles;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.core.admin.model.Principals;
import org.apache.polaris.core.admin.model.RevokeGrantRequest;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.core.admin.model.TableGrant;
import org.apache.polaris.core.admin.model.UpdateCatalogRequest;
import org.apache.polaris.core.admin.model.UpdateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRoleRequest;
import org.apache.polaris.core.admin.model.ViewGrant;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.CatalogRoleEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisPrivilege;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.entity.PrincipalRoleEntity;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.PrivilegeResult;
import org.apache.polaris.core.persistence.resolver.ResolutionManifestFactory;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.core.secrets.UserSecretsManagerFactory;
import org.apache.polaris.service.admin.PolarisAdminService;
import org.apache.polaris.service.admin.api.PolarisCatalogsApiService;
import org.apache.polaris.service.admin.api.PolarisPrincipalRolesApiService;
import org.apache.polaris.service.admin.api.PolarisPrincipalsApiService;
import org.apache.polaris.service.config.ReservedProperties;
import org.apache.polaris.service.types.PolicyIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class PolarisServiceImpl
implements PolarisCatalogsApiService,
PolarisPrincipalsApiService,
PolarisPrincipalRolesApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisServiceImpl.class);
    private final ResolutionManifestFactory resolutionManifestFactory;
    private final PolarisAuthorizer polarisAuthorizer;
    private final MetaStoreManagerFactory metaStoreManagerFactory;
    private final UserSecretsManagerFactory userSecretsManagerFactory;
    private final CallContext callContext;
    private final RealmConfig realmConfig;
    private final ReservedProperties reservedProperties;

    @Inject
    public PolarisServiceImpl(ResolutionManifestFactory resolutionManifestFactory, MetaStoreManagerFactory metaStoreManagerFactory, UserSecretsManagerFactory userSecretsManagerFactory, PolarisAuthorizer polarisAuthorizer, CallContext callContext, ReservedProperties reservedProperties) {
        this.resolutionManifestFactory = resolutionManifestFactory;
        this.metaStoreManagerFactory = metaStoreManagerFactory;
        this.userSecretsManagerFactory = userSecretsManagerFactory;
        this.polarisAuthorizer = polarisAuthorizer;
        this.callContext = callContext;
        this.realmConfig = callContext.getRealmConfig();
        this.reservedProperties = reservedProperties;
    }

    private PolarisAdminService newAdminService(RealmContext realmContext, SecurityContext securityContext) {
        PolarisPrincipal authenticatedPrincipal = (PolarisPrincipal)securityContext.getUserPrincipal();
        if (authenticatedPrincipal == null) {
            throw new NotAuthorizedException("Failed to find authenticatedPrincipal in SecurityContext", new Object[0]);
        }
        PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerFactory.getOrCreateMetaStoreManager(realmContext);
        UserSecretsManager userSecretsManager = this.userSecretsManagerFactory.getOrCreateUserSecretsManager(realmContext);
        return new PolarisAdminService(this.callContext, this.resolutionManifestFactory, metaStoreManager, userSecretsManager, securityContext, this.polarisAuthorizer, this.reservedProperties);
    }

    private static Response toResponse(BaseResult result, Response.Status successStatus) {
        if (!result.isSuccess()) {
            ErrorResponse icebergErrorResponse = ErrorResponse.builder().responseCode(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode())).withType(result.getReturnStatus().toString()).withMessage("Operation failed: " + result.getReturnStatus().toString()).build();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)icebergErrorResponse).build();
        }
        return Response.status((Response.Status)successStatus).build();
    }

    public Response createCatalog(CreateCatalogRequest request, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        Catalog catalog = request.getCatalog();
        this.validateStorageConfig(catalog.getStorageConfigInfo());
        this.validateExternalCatalog(catalog);
        Catalog newCatalog = CatalogEntity.of((PolarisBaseEntity)adminService.createCatalog(request)).asCatalog();
        LOGGER.info("Created new catalog {}", (Object)newCatalog);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    private void validateStorageConfig(StorageConfigInfo storageConfigInfo) {
        AwsStorageConfigInfo s3Config;
        List allowedStorageTypes = (List)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.SUPPORTED_CATALOG_STORAGE_TYPES);
        if (!allowedStorageTypes.contains(storageConfigInfo.getStorageType().name())) {
            LOGGER.atWarn().addKeyValue("storageConfig", (Object)storageConfigInfo).log("Disallowed storage type in catalog");
            throw new IllegalArgumentException("Unsupported storage type: " + String.valueOf(storageConfigInfo.getStorageType()));
        }
        if (!((Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_SETTING_S3_ENDPOINTS)).booleanValue() && storageConfigInfo instanceof AwsStorageConfigInfo && ((s3Config = (AwsStorageConfigInfo)storageConfigInfo).getEndpoint() != null || s3Config.getStsEndpoint() != null || s3Config.getEndpointInternal() != null)) {
            throw new IllegalArgumentException("Explicitly setting S3 endpoints is not allowed.");
        }
    }

    private void validateExternalCatalog(Catalog catalog) {
        ExternalCatalog externalCatalog;
        ConnectionConfigInfo connectionConfigInfo;
        if (catalog.getType() == Catalog.TypeEnum.EXTERNAL && catalog instanceof ExternalCatalog && (connectionConfigInfo = (externalCatalog = (ExternalCatalog)catalog).getConnectionConfigInfo()) != null) {
            this.validateConnectionConfigInfo(connectionConfigInfo);
            this.validateAuthenticationParameters(connectionConfigInfo.getAuthenticationParameters());
        }
    }

    private void validateConnectionConfigInfo(ConnectionConfigInfo connectionConfigInfo) {
        String connectionType = connectionConfigInfo.getConnectionType().name();
        List<String> supportedConnectionTypes = ((List)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.SUPPORTED_CATALOG_CONNECTION_TYPES)).stream().map(s -> s.toUpperCase(Locale.ROOT)).toList();
        if (!supportedConnectionTypes.contains(connectionType)) {
            throw new IllegalStateException("Unsupported connection type: " + connectionType);
        }
    }

    private void validateAuthenticationParameters(AuthenticationParameters authenticationParameters) {
        String authenticationType = authenticationParameters.getAuthenticationType().name();
        List<String> supportedAuthenticationTypes = ((List)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.SUPPORTED_EXTERNAL_CATALOG_AUTHENTICATION_TYPES)).stream().map(s -> s.toUpperCase(Locale.ROOT)).toList();
        if (!supportedAuthenticationTypes.contains(authenticationType)) {
            throw new IllegalStateException("Unsupported authentication type: " + authenticationType);
        }
    }

    public Response deleteCatalog(String catalogName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        adminService.deleteCatalog(catalogName);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response getCatalog(String catalogName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        return Response.ok((Object)adminService.getCatalog(catalogName).asCatalog()).build();
    }

    public Response updateCatalog(String catalogName, UpdateCatalogRequest updateRequest, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        if (updateRequest.getStorageConfigInfo() != null) {
            this.validateStorageConfig(updateRequest.getStorageConfigInfo());
        }
        return Response.ok((Object)adminService.updateCatalog(catalogName, updateRequest).asCatalog()).build();
    }

    public Response listCatalogs(RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        List catalogList = adminService.listCatalogs();
        Catalogs catalogs = new Catalogs(catalogList);
        LOGGER.debug("listCatalogs returning: {}", (Object)catalogs);
        return Response.ok((Object)catalogs).build();
    }

    public Response createPrincipal(CreatePrincipalRequest request, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        PrincipalEntity principal = ((PrincipalEntity.Builder)((PrincipalEntity.Builder)new PrincipalEntity.Builder().setName(request.getPrincipal().getName())).setClientId(request.getPrincipal().getClientId()).setProperties(this.reservedProperties.removeReservedProperties(request.getPrincipal().getProperties()))).build();
        if (Boolean.TRUE.equals(request.getCredentialRotationRequired())) {
            principal = new PrincipalEntity.Builder(principal).setCredentialRotationRequiredState().build();
        }
        PrincipalWithCredentials createdPrincipal = adminService.createPrincipal((PolarisEntity)principal);
        LOGGER.info("Created new principal {}", (Object)createdPrincipal);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)createdPrincipal).build();
    }

    public Response deletePrincipal(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        adminService.deletePrincipal(principalName);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response getPrincipal(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        return Response.ok((Object)adminService.getPrincipal(principalName).asPrincipal()).build();
    }

    public Response updatePrincipal(String principalName, UpdatePrincipalRequest updateRequest, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        return Response.ok((Object)adminService.updatePrincipal(principalName, updateRequest).asPrincipal()).build();
    }

    public Response rotateCredentials(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        return Response.ok((Object)adminService.rotateCredentials(principalName)).build();
    }

    public Response listPrincipals(RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        List principalList = adminService.listPrincipals();
        Principals principals = new Principals(principalList);
        LOGGER.debug("listPrincipals returning: {}", (Object)principals);
        return Response.ok((Object)principals).build();
    }

    public Response createPrincipalRole(CreatePrincipalRoleRequest request, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        PrincipalRoleEntity entity = ((PrincipalRoleEntity.Builder)((PrincipalRoleEntity.Builder)new PrincipalRoleEntity.Builder().setName(request.getPrincipalRole().getName())).setProperties(this.reservedProperties.removeReservedProperties(request.getPrincipalRole().getProperties()))).build();
        PrincipalRole newPrincipalRole = new PrincipalRoleEntity((PolarisBaseEntity)adminService.createPrincipalRole((PolarisEntity)entity)).asPrincipalRole();
        LOGGER.info("Created new principalRole {}", (Object)newPrincipalRole);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    public Response deletePrincipalRole(String principalRoleName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        adminService.deletePrincipalRole(principalRoleName);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response getPrincipalRole(String principalRoleName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        return Response.ok((Object)adminService.getPrincipalRole(principalRoleName).asPrincipalRole()).build();
    }

    public Response updatePrincipalRole(String principalRoleName, UpdatePrincipalRoleRequest updateRequest, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        return Response.ok((Object)adminService.updatePrincipalRole(principalRoleName, updateRequest).asPrincipalRole()).build();
    }

    public Response listPrincipalRoles(RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        List principalRoleList = adminService.listPrincipalRoles();
        PrincipalRoles principalRoles = new PrincipalRoles(principalRoleList);
        LOGGER.debug("listPrincipalRoles returning: {}", (Object)principalRoles);
        return Response.ok((Object)principalRoles).build();
    }

    public Response createCatalogRole(String catalogName, CreateCatalogRoleRequest request, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        CatalogRoleEntity entity = ((CatalogRoleEntity.Builder)((CatalogRoleEntity.Builder)new CatalogRoleEntity.Builder().setName(request.getCatalogRole().getName())).setProperties(this.reservedProperties.removeReservedProperties(request.getCatalogRole().getProperties()))).build();
        CatalogRole newCatalogRole = new CatalogRoleEntity((PolarisBaseEntity)adminService.createCatalogRole(catalogName, (PolarisEntity)entity)).asCatalogRole();
        LOGGER.info("Created new catalogRole {}", (Object)newCatalogRole);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    public Response deleteCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        adminService.deleteCatalogRole(catalogName, catalogRoleName);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response getCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        return Response.ok((Object)adminService.getCatalogRole(catalogName, catalogRoleName).asCatalogRole()).build();
    }

    public Response updateCatalogRole(String catalogName, String catalogRoleName, UpdateCatalogRoleRequest updateRequest, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        return Response.ok((Object)adminService.updateCatalogRole(catalogName, catalogRoleName, updateRequest).asCatalogRole()).build();
    }

    public Response listCatalogRoles(String catalogName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        List catalogRoleList = adminService.listCatalogRoles(catalogName);
        CatalogRoles catalogRoles = new CatalogRoles(catalogRoleList);
        LOGGER.debug("listCatalogRoles returning: {}", (Object)catalogRoles);
        return Response.ok((Object)catalogRoles).build();
    }

    public Response assignPrincipalRole(String principalName, GrantPrincipalRoleRequest request, RealmContext realmContext, SecurityContext securityContext) {
        LOGGER.info("Assigning principalRole {} to principal {}", (Object)request.getPrincipalRole().getName(), (Object)principalName);
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        PrivilegeResult result = adminService.assignPrincipalRole(principalName, request.getPrincipalRole().getName());
        return PolarisServiceImpl.toResponse((BaseResult)result, Response.Status.CREATED);
    }

    public Response revokePrincipalRole(String principalName, String principalRoleName, RealmContext realmContext, SecurityContext securityContext) {
        LOGGER.info("Revoking principalRole {} from principal {}", (Object)principalRoleName, (Object)principalName);
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        PrivilegeResult result = adminService.revokePrincipalRole(principalName, principalRoleName);
        return PolarisServiceImpl.toResponse((BaseResult)result, Response.Status.NO_CONTENT);
    }

    public Response listPrincipalRolesAssigned(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        List<PrincipalRole> principalRoleList = adminService.listPrincipalRolesAssigned(principalName).stream().map(PrincipalRoleEntity::new).map(PrincipalRoleEntity::asPrincipalRole).toList();
        PrincipalRoles principalRoles = new PrincipalRoles(principalRoleList);
        LOGGER.debug("listPrincipalRolesAssigned returning: {}", (Object)principalRoles);
        return Response.ok((Object)principalRoles).build();
    }

    public Response assignCatalogRoleToPrincipalRole(String principalRoleName, String catalogName, GrantCatalogRoleRequest request, RealmContext realmContext, SecurityContext securityContext) {
        LOGGER.info("Assigning catalogRole {} in catalog {} to principalRole {}", new Object[]{request.getCatalogRole().getName(), catalogName, principalRoleName});
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        PrivilegeResult result = adminService.assignCatalogRoleToPrincipalRole(principalRoleName, catalogName, request.getCatalogRole().getName());
        return PolarisServiceImpl.toResponse((BaseResult)result, Response.Status.CREATED);
    }

    public Response revokeCatalogRoleFromPrincipalRole(String principalRoleName, String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        LOGGER.info("Revoking catalogRole {} in catalog {} from principalRole {}", new Object[]{catalogRoleName, catalogName, principalRoleName});
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        PrivilegeResult result = adminService.revokeCatalogRoleFromPrincipalRole(principalRoleName, catalogName, catalogRoleName);
        return PolarisServiceImpl.toResponse((BaseResult)result, Response.Status.NO_CONTENT);
    }

    public Response listAssigneePrincipalsForPrincipalRole(String principalRoleName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        List<Principal> principalList = adminService.listAssigneePrincipalsForPrincipalRole(principalRoleName).stream().map(PrincipalEntity::new).map(PrincipalEntity::asPrincipal).toList();
        Principals principals = new Principals(principalList);
        LOGGER.debug("listAssigneePrincipalsForPrincipalRole returning: {}", (Object)principals);
        return Response.ok((Object)principals).build();
    }

    public Response listCatalogRolesForPrincipalRole(String principalRoleName, String catalogName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        List<CatalogRole> catalogRoleList = adminService.listCatalogRolesForPrincipalRole(principalRoleName, catalogName).stream().map(CatalogRoleEntity::new).map(CatalogRoleEntity::asCatalogRole).toList();
        CatalogRoles catalogRoles = new CatalogRoles(catalogRoleList);
        LOGGER.debug("listCatalogRolesForPrincipalRole returning: {}", (Object)catalogRoles);
        return Response.ok((Object)catalogRoles).build();
    }

    public Response addGrantToCatalogRole(String catalogName, String catalogRoleName, AddGrantRequest grantRequest, RealmContext realmContext, SecurityContext securityContext) {
        PrivilegeResult result;
        LOGGER.info("Adding grant {} to catalogRole {} in catalog {}", new Object[]{grantRequest, catalogRoleName, catalogName});
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        GrantResource grantResource = grantRequest.getGrant();
        Objects.requireNonNull(grantResource);
        GrantResource grantResource2 = grantResource;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ViewGrant.class, TableGrant.class, NamespaceGrant.class, CatalogGrant.class, PolicyGrant.class}, (Object)grantResource2, n)) {
            case 0: {
                ViewGrant viewGrant = (ViewGrant)grantResource2;
                PolarisPrivilege privilege = PolarisPrivilege.valueOf((String)viewGrant.getPrivilege().toString());
                String viewName = viewGrant.getViewName();
                String[] namespaceParts = viewGrant.getNamespace().toArray(new String[0]);
                result = adminService.grantPrivilegeOnViewToRole(catalogName, catalogRoleName, TableIdentifier.of((Namespace)Namespace.of((String[])namespaceParts), (String)viewName), privilege);
                break;
            }
            case 1: {
                TableGrant tableGrant = (TableGrant)grantResource2;
                PolarisPrivilege privilege = PolarisPrivilege.valueOf((String)tableGrant.getPrivilege().toString());
                String tableName = tableGrant.getTableName();
                String[] namespaceParts = tableGrant.getNamespace().toArray(new String[0]);
                result = adminService.grantPrivilegeOnTableToRole(catalogName, catalogRoleName, TableIdentifier.of((Namespace)Namespace.of((String[])namespaceParts), (String)tableName), privilege);
                break;
            }
            case 2: {
                NamespaceGrant namespaceGrant = (NamespaceGrant)grantResource2;
                PolarisPrivilege privilege = PolarisPrivilege.valueOf((String)namespaceGrant.getPrivilege().toString());
                String[] namespaceParts = namespaceGrant.getNamespace().toArray(new String[0]);
                result = adminService.grantPrivilegeOnNamespaceToRole(catalogName, catalogRoleName, Namespace.of((String[])namespaceParts), privilege);
                break;
            }
            case 3: {
                CatalogGrant catalogGrant = (CatalogGrant)grantResource2;
                PolarisPrivilege privilege = PolarisPrivilege.valueOf((String)catalogGrant.getPrivilege().toString());
                result = adminService.grantPrivilegeOnCatalogToRole(catalogName, catalogRoleName, privilege);
                break;
            }
            case 4: {
                PolicyGrant policyGrant = (PolicyGrant)grantResource2;
                PolarisPrivilege privilege = PolarisPrivilege.valueOf((String)policyGrant.getPrivilege().toString());
                String policyName = policyGrant.getPolicyName();
                String[] namespaceParts = policyGrant.getNamespace().toArray(new String[0]);
                result = adminService.grantPrivilegeOnPolicyToRole(catalogName, catalogRoleName, new PolicyIdentifier(Namespace.of((String[])namespaceParts), policyName), privilege);
                break;
            }
            default: {
                LOGGER.atWarn().addKeyValue("catalog", (Object)catalogName).addKeyValue("role", (Object)catalogRoleName).log("Don't know how to handle privilege grant: {}", (Object)grantRequest);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        return PolarisServiceImpl.toResponse((BaseResult)result, Response.Status.CREATED);
    }

    public Response revokeGrantFromCatalogRole(String catalogName, String catalogRoleName, Boolean cascade, RevokeGrantRequest grantRequest, RealmContext realmContext, SecurityContext securityContext) {
        PrivilegeResult result;
        LOGGER.info("Revoking grant {} from catalogRole {} in catalog {}", new Object[]{grantRequest, catalogRoleName, catalogName});
        if (cascade != null && cascade.booleanValue()) {
            LOGGER.warn("Tried to use unimplemented 'cascade' feature when revoking grants.");
            return Response.status((int)501).build();
        }
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        GrantResource grantResource = grantRequest.getGrant();
        Objects.requireNonNull(grantResource);
        GrantResource grantResource2 = grantResource;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ViewGrant.class, TableGrant.class, NamespaceGrant.class, CatalogGrant.class, PolicyGrant.class}, (Object)grantResource2, n)) {
            case 0: {
                ViewGrant viewGrant = (ViewGrant)grantResource2;
                PolarisPrivilege privilege = PolarisPrivilege.valueOf((String)viewGrant.getPrivilege().toString());
                String viewName = viewGrant.getViewName();
                String[] namespaceParts = viewGrant.getNamespace().toArray(new String[0]);
                result = adminService.revokePrivilegeOnViewFromRole(catalogName, catalogRoleName, TableIdentifier.of((Namespace)Namespace.of((String[])namespaceParts), (String)viewName), privilege);
                break;
            }
            case 1: {
                TableGrant tableGrant = (TableGrant)grantResource2;
                PolarisPrivilege privilege = PolarisPrivilege.valueOf((String)tableGrant.getPrivilege().toString());
                String tableName = tableGrant.getTableName();
                String[] namespaceParts = tableGrant.getNamespace().toArray(new String[0]);
                result = adminService.revokePrivilegeOnTableFromRole(catalogName, catalogRoleName, TableIdentifier.of((Namespace)Namespace.of((String[])namespaceParts), (String)tableName), privilege);
                break;
            }
            case 2: {
                NamespaceGrant namespaceGrant = (NamespaceGrant)grantResource2;
                PolarisPrivilege privilege = PolarisPrivilege.valueOf((String)namespaceGrant.getPrivilege().toString());
                String[] namespaceParts = namespaceGrant.getNamespace().toArray(new String[0]);
                result = adminService.revokePrivilegeOnNamespaceFromRole(catalogName, catalogRoleName, Namespace.of((String[])namespaceParts), privilege);
                break;
            }
            case 3: {
                CatalogGrant catalogGrant = (CatalogGrant)grantResource2;
                PolarisPrivilege privilege = PolarisPrivilege.valueOf((String)catalogGrant.getPrivilege().toString());
                result = adminService.revokePrivilegeOnCatalogFromRole(catalogName, catalogRoleName, privilege);
                break;
            }
            case 4: {
                PolicyGrant policyGrant = (PolicyGrant)grantResource2;
                PolarisPrivilege privilege = PolarisPrivilege.valueOf((String)policyGrant.getPrivilege().toString());
                String policyName = policyGrant.getPolicyName();
                String[] namespaceParts = policyGrant.getNamespace().toArray(new String[0]);
                result = adminService.revokePrivilegeOnPolicyFromRole(catalogName, catalogRoleName, new PolicyIdentifier(Namespace.of((String[])namespaceParts), policyName), privilege);
                break;
            }
            default: {
                LOGGER.atWarn().addKeyValue("catalog", (Object)catalogName).addKeyValue("role", (Object)catalogRoleName).log("Don't know how to handle privilege revocation: {}", (Object)grantRequest);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        return PolarisServiceImpl.toResponse((BaseResult)result, Response.Status.CREATED);
    }

    public Response listAssigneePrincipalRolesForCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        List<PrincipalRole> principalRoleList = adminService.listAssigneePrincipalRolesForCatalogRole(catalogName, catalogRoleName).stream().map(PrincipalRoleEntity::new).map(PrincipalRoleEntity::asPrincipalRole).toList();
        PrincipalRoles principalRoles = new PrincipalRoles(principalRoleList);
        LOGGER.debug("listAssigneePrincipalRolesForCatalogRole returning: {}", (Object)principalRoles);
        return Response.ok((Object)principalRoles).build();
    }

    public Response listGrantsForCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        PolarisAdminService adminService = this.newAdminService(realmContext, securityContext);
        List grantList = adminService.listGrantsForCatalogRole(catalogName, catalogRoleName);
        GrantResources grantResources = new GrantResources(grantList);
        return Response.ok((Object)grantResources).build();
    }

    public PolarisServiceImpl() {
    }
}

