/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.secrets;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SecretReference {
    @JsonProperty(value="urn")
    private final String urn;
    @JsonProperty(value="referencePayload")
    private final Map<String, String> referencePayload;
    private static final String URN_SCHEME = "urn";
    private static final String URN_NAMESPACE = "polaris-secret";
    private static final String SECRET_MANAGER_TYPE_REGEX = "([a-zA-Z0-9_-]+)";
    private static final String TYPE_SPECIFIC_IDENTIFIER_REGEX = "([a-zA-Z0-9_-]+(?::[a-zA-Z0-9_-]+)*)";
    private static final Pattern SECRET_MANAGER_TYPE_PATTERN = Pattern.compile("^([a-zA-Z0-9_-]+)$");
    private static final Pattern TYPE_SPECIFIC_IDENTIFIER_PATTERN = Pattern.compile("^([a-zA-Z0-9_-]+(?::[a-zA-Z0-9_-]+)*)$");
    private static final Pattern URN_PATTERN = Pattern.compile("^urn:polaris-secret:([a-zA-Z0-9_-]+):([a-zA-Z0-9_-]+(?::[a-zA-Z0-9_-]+)*)$");

    public SecretReference(@JsonProperty(value="urn", required=true) @Nonnull String urn, @JsonProperty(value="referencePayload") @Nullable Map<String, String> referencePayload) {
        Preconditions.checkArgument((boolean)SecretReference.urnIsValid(urn), (Object)("Invalid secret URN: " + urn + "; must be of the form: " + URN_PATTERN.toString()));
        this.urn = urn;
        this.referencePayload = Objects.requireNonNullElse(referencePayload, new HashMap());
    }

    private static boolean urnIsValid(@Nonnull String urn) {
        return urn.trim().isEmpty() ? false : URN_PATTERN.matcher(urn).matches();
    }

    @Nonnull
    public static String buildUrnString(@Nonnull String secretManagerType, @Nonnull String typeSpecificIdentifier) {
        Preconditions.checkArgument((!secretManagerType.trim().isEmpty() ? 1 : 0) != 0, (Object)"Secret manager type cannot be empty");
        Preconditions.checkArgument((boolean)SECRET_MANAGER_TYPE_PATTERN.matcher(secretManagerType).matches(), (String)"Invalid secret manager type '%s'; must contain only alphanumeric characters, hyphens, and underscores", (Object)secretManagerType);
        Preconditions.checkArgument((!typeSpecificIdentifier.trim().isEmpty() ? 1 : 0) != 0, (Object)"Type-specific identifier cannot be empty");
        Preconditions.checkArgument((boolean)TYPE_SPECIFIC_IDENTIFIER_PATTERN.matcher(typeSpecificIdentifier).matches(), (String)"Invalid type-specific identifier '%s'; must be colon-separated alphanumeric components (hyphens and underscores allowed)", (Object)typeSpecificIdentifier);
        return "urn:polaris-secret:" + secretManagerType + ":" + typeSpecificIdentifier;
    }

    @JsonIgnore
    public String getSecretManagerType() {
        Matcher matcher = URN_PATTERN.matcher(this.urn);
        Preconditions.checkState((boolean)matcher.matches(), (Object)("Invalid secret URN: " + this.urn));
        return matcher.group(1);
    }

    @JsonIgnore
    public String getTypeSpecificIdentifier() {
        Matcher matcher = URN_PATTERN.matcher(this.urn);
        Preconditions.checkState((boolean)matcher.matches(), (Object)("Invalid secret URN: " + this.urn));
        return matcher.group(2);
    }

    @Nonnull
    public String getUrn() {
        return this.urn;
    }

    @Nonnull
    public Map<String, String> getReferencePayload() {
        return this.referencePayload;
    }

    public int hashCode() {
        return Objects.hash(this.getUrn(), this.getReferencePayload());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SecretReference)) {
            return false;
        }
        SecretReference that = (SecretReference)obj;
        return Objects.equals(this.getUrn(), that.getUrn()) && Objects.equals(this.getReferencePayload(), that.getReferencePayload());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(URN_SCHEME, (Object)this.getUrn()).add("referencePayload", (Object)String.format("<num entries: %d>", this.getReferencePayload().size())).toString();
    }
}

