/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt;

import io.smallrye.jwt.JsonProviderHolder;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonUtils {
    private JsonUtils() {
    }

    public static JsonObject replaceMap(Map<String, Object> map) {
        JsonObjectBuilder builder = JsonProviderHolder.jsonProvider().createObjectBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue instanceof Map) {
                JsonObject entryJsonObject = JsonUtils.replaceMap((Map)entryValue);
                builder.add(entry.getKey(), (JsonValue)entryJsonObject);
                continue;
            }
            if (entryValue instanceof List) {
                JsonArray array = (JsonArray)JsonUtils.wrapValue(entryValue);
                builder.add(entry.getKey(), (JsonValue)array);
                continue;
            }
            if (entryValue instanceof Long || entryValue instanceof Integer) {
                long lvalue = ((Number)entryValue).longValue();
                builder.add(entry.getKey(), lvalue);
                continue;
            }
            if (entryValue instanceof Double || entryValue instanceof Float) {
                double dvalue = ((Number)entryValue).doubleValue();
                builder.add(entry.getKey(), dvalue);
                continue;
            }
            if (entryValue instanceof Boolean) {
                boolean flag = (Boolean)entryValue;
                builder.add(entry.getKey(), flag);
                continue;
            }
            if (!(entryValue instanceof String)) continue;
            builder.add(entry.getKey(), entryValue.toString());
        }
        return builder.build();
    }

    private static JsonArray toJsonArray(Collection<?> collection) {
        JsonArrayBuilder arrayBuilder = JsonProviderHolder.jsonProvider().createArrayBuilder();
        for (Object element : collection) {
            if (element instanceof String) {
                arrayBuilder.add(element.toString());
                continue;
            }
            if (element == null) {
                arrayBuilder.add(JsonValue.NULL);
                continue;
            }
            JsonValue jvalue = JsonUtils.wrapValue(element);
            arrayBuilder.add(jvalue);
        }
        return arrayBuilder.build();
    }

    public static JsonValue wrapValue(Object value) {
        JsonValue jsonValue = null;
        if (value instanceof JsonValue) {
            jsonValue = (JsonValue)value;
        } else if (value instanceof String) {
            jsonValue = JsonProviderHolder.jsonProvider().createValue(value.toString());
        } else if (value instanceof Long || value instanceof Integer) {
            jsonValue = JsonProviderHolder.jsonProvider().createValue(((Number)value).longValue());
        } else if (value instanceof Number) {
            jsonValue = JsonProviderHolder.jsonProvider().createValue(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            jsonValue = (Boolean)value != false ? JsonValue.TRUE : JsonValue.FALSE;
        } else if (value instanceof Collection) {
            jsonValue = JsonUtils.toJsonArray((Collection)value);
        } else if (value instanceof Map) {
            JsonObject entryJsonObject = JsonUtils.replaceMap((Map)value);
            jsonValue = entryJsonObject;
        }
        return jsonValue;
    }

    public static Object convert(Class<?> klass, Object value) {
        if (klass == null) {
            return value;
        }
        if (klass.isAssignableFrom(String.class) && value instanceof JsonString) {
            return value.toString();
        }
        if (klass.isAssignableFrom(JsonString.class) && value instanceof String) {
            return JsonUtils.wrapValue(value);
        }
        if (klass.isAssignableFrom(Long.class) && value instanceof JsonNumber) {
            return ((JsonNumber)value).longValue();
        }
        if (klass.isAssignableFrom(Boolean.class)) {
            if (value == JsonValue.TRUE) {
                return Boolean.TRUE;
            }
            if (value == JsonValue.FALSE) {
                return Boolean.FALSE;
            }
            if (value instanceof JsonString) {
                return Boolean.valueOf(value.toString());
            }
        }
        if (klass.isAssignableFrom(Set.class) && value instanceof JsonArray) {
            return new HashSet(((JsonArray)value).getValuesAs(jsonValue -> {
                if (jsonValue instanceof JsonString) {
                    return ((JsonString)jsonValue).getString();
                }
                return jsonValue.toString();
            }));
        }
        return value;
    }
}

