/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPipelineSyncPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.ServiceVersion;
import com.azure.core.util.UserAgentUtil;
import reactor.core.publisher.Mono;

public class UserAgentPolicy
implements HttpPipelinePolicy {
    public static final String OVERRIDE_USER_AGENT_CONTEXT_KEY = "Override-User-Agent";
    public static final String APPEND_USER_AGENT_CONTEXT_KEY = "Append-User-Agent";
    private final String userAgent;
    private final HttpPipelineSyncPolicy inner = new HttpPipelineSyncPolicy(){

        @Override
        protected void beforeSendingRequest(HttpPipelineCallContext context) {
            String overrideUserAgent = context.getData(UserAgentPolicy.OVERRIDE_USER_AGENT_CONTEXT_KEY).orElse(null);
            String appendUserAgent = context.getData(UserAgentPolicy.APPEND_USER_AGENT_CONTEXT_KEY).orElse(null);
            String userAgentValue = !CoreUtils.isNullOrEmpty(overrideUserAgent) ? overrideUserAgent : (!CoreUtils.isNullOrEmpty(appendUserAgent) ? UserAgentPolicy.this.userAgent + " " + appendUserAgent : UserAgentPolicy.this.userAgent);
            context.getHttpRequest().setHeader(HttpHeaderName.USER_AGENT, userAgentValue);
        }
    };

    public UserAgentPolicy() {
        this(null);
    }

    public UserAgentPolicy(String userAgent) {
        this.userAgent = userAgent != null ? userAgent : "azsdk-java";
    }

    public UserAgentPolicy(String applicationId, String sdkName, String sdkVersion, Configuration configuration) {
        this.userAgent = UserAgentUtil.toUserAgentString(applicationId, sdkName, sdkVersion, configuration);
    }

    @Deprecated
    public UserAgentPolicy(String sdkName, String sdkVersion, Configuration configuration, ServiceVersion version) {
        this.userAgent = UserAgentUtil.toUserAgentString(null, sdkName, sdkVersion, configuration);
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return this.inner.process(context, next);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        return this.inner.processSync(context, next);
    }
}

