/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core;

import io.smallrye.faulttolerance.core.Completer;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.function.BiConsumer;

final class FutureImpl<T>
implements Future<T>,
Completer<T> {
    private static final int STATE_PENDING = 0;
    private static final int STATE_COMPLETING = 1;
    private static final int STATE_COMPLETE = 2;
    private static final int STATE_DELIVERED = 3;
    private static final int STATE_CANCELLED = 4;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final VarHandle STATE = ConstantBootstraps.fieldVarHandle(LOOKUP, "state", VarHandle.class, FutureImpl.class, Integer.TYPE);
    private static final VarHandle COMPLETION_CALLBACK = ConstantBootstraps.fieldVarHandle(LOOKUP, "completionCallback", VarHandle.class, FutureImpl.class, BiConsumer.class);
    private static final VarHandle CANCELLATION_CALLBACK = ConstantBootstraps.fieldVarHandle(LOOKUP, "cancellationCallback", VarHandle.class, FutureImpl.class, Runnable.class);
    private volatile int state = 0;
    private volatile Object result;
    private volatile BiConsumer<T, Throwable> completionCallback = null;
    private final Barrier completionBarrier = new Barrier();
    private volatile Runnable cancellationCallback = null;

    FutureImpl() {
    }

    @Override
    public void complete(T value) {
        if (STATE.compareAndSet(this, 0, 1)) {
            this.result = value;
            this.state = 2;
            this.attemptDelivery();
            this.completionBarrier.open();
        }
    }

    @Override
    public void completeWithError(Throwable error) {
        Preconditions.checkNotNull(error, "Error must be set");
        if (STATE.compareAndSet(this, 0, 1)) {
            this.result = new ExceptionResult(error);
            this.state = 2;
            this.attemptDelivery();
            this.completionBarrier.open();
        }
    }

    @Override
    public void onCancel(Runnable cancellationCallback) {
        Preconditions.checkNotNull(cancellationCallback, "Cancellation callback must be set");
        if (!CANCELLATION_CALLBACK.compareAndSet(this, null, cancellationCallback)) {
            throw new IllegalStateException("Cancellation callback has already been set");
        }
    }

    @Override
    public Future<T> future() {
        return this;
    }

    @Override
    public void then(BiConsumer<T, Throwable> callback) {
        Preconditions.checkNotNull(callback, "Completion callback must be set");
        if (!COMPLETION_CALLBACK.compareAndSet(this, null, callback)) {
            throw new IllegalStateException("Completion callback has already been set");
        }
        this.attemptDelivery();
    }

    @Override
    public void thenComplete(Completer<T> completer) {
        Preconditions.checkNotNull(completer, "Completer must be set");
        this.then((value, error) -> {
            if (error == null) {
                completer.complete(value);
            } else {
                completer.completeWithError((Throwable)error);
            }
        });
    }

    @Override
    public boolean isComplete() {
        int state = this.state;
        return state == 2 || state == 3;
    }

    @Override
    public boolean isCancelled() {
        return this.state == 4;
    }

    @Override
    public T awaitBlocking() throws Throwable {
        try {
            this.completionBarrier.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int state = this.state;
        if (state == 2 || state == 3) {
            Object result = this.result;
            if (result instanceof ExceptionResult) {
                throw ((ExceptionResult)result).exception;
            }
            return (T)result;
        }
        if (state == 4) {
            throw new CancellationException();
        }
        throw new InterruptedException();
    }

    @Override
    public void cancel() {
        Runnable cancellationCallback;
        if (STATE.compareAndSet(this, 0, 4) && (cancellationCallback = this.cancellationCallback) != null) {
            cancellationCallback.run();
        }
    }

    private void attemptDelivery() {
        BiConsumer<Object, Throwable> callback = this.completionCallback;
        if (callback != null && STATE.compareAndSet(this, 2, 3)) {
            Object result = this.result;
            if (result instanceof ExceptionResult) {
                callback.accept(null, ((ExceptionResult)result).exception);
            } else {
                callback.accept(result, null);
            }
        }
    }

    private static class Barrier
    extends AbstractQueuedSynchronizer {
        private Barrier() {
        }

        void await() throws InterruptedException {
            this.acquireSharedInterruptibly(1);
        }

        void open() {
            this.releaseShared(1);
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            return this.getState() != 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignored) {
            this.setState(1);
            return true;
        }
    }

    private static final class ExceptionResult {
        private final Throwable exception;

        private ExceptionResult(Throwable exception) {
            this.exception = exception;
        }
    }
}

