/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core;

import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.FutureImpl;
import java.util.function.Function;
import java.util.function.Predicate;

final class FutureLoop<T> {
    private final FutureImpl<T> delegate = new FutureImpl();
    private final Predicate<T> condition;
    private final Function<T, Future<T>> iteration;

    private FutureLoop(Predicate<T> condition, Function<T, Future<T>> iteration) {
        this.condition = condition;
        this.iteration = iteration;
    }

    static <T> Future<T> loop(T initialValue, Predicate<T> condition, Function<T, Future<T>> iteration) {
        FutureLoop<T> loop = new FutureLoop<T>(condition, iteration);
        loop.run(initialValue, null);
        return loop.delegate;
    }

    private void run(T value, Result<T> previousResult) {
        if (previousResult != null && previousResult.inProgress) {
            previousResult.value = value;
            return;
        }
        Result currentResult = new Result();
        do {
            try {
                if (!this.condition.test(value)) {
                    this.delegate.complete(value);
                    return;
                }
                this.iteration.apply(value).then((val, error) -> {
                    if (error == null) {
                        this.run(val, currentResult);
                    } else {
                        this.delegate.completeWithError((Throwable)error);
                    }
                });
            }
            catch (Throwable e) {
                this.delegate.completeWithError(e);
                return;
            }
        } while ((value = currentResult.resetValue()) != Result.NONE);
        currentResult.inProgress = false;
    }

    private static class Result<T> {
        private static final Object NONE = new Object();
        boolean inProgress = true;
        T value = NONE;

        private Result() {
        }

        T resetValue() {
            T result = this.value;
            this.value = NONE;
            return result;
        }
    }
}

