/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import org.apache.polaris.core.entity.PolarisEntityType;

public enum PolarisEntitySubType {
    ANY_SUBTYPE(-1, null),
    NULL_SUBTYPE(0, null),
    ICEBERG_TABLE(2, PolarisEntityType.TABLE_LIKE),
    ICEBERG_VIEW(3, PolarisEntityType.TABLE_LIKE),
    GENERIC_TABLE(4, PolarisEntityType.TABLE_LIKE);

    private static final PolarisEntitySubType[] REVERSE_MAPPING_ARRAY;
    private final int code;
    private final PolarisEntityType parentType;

    private PolarisEntitySubType(int code, PolarisEntityType parentType) {
        this.code = code;
        this.parentType = parentType;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    public PolarisEntityType getParentType() {
        return this.parentType;
    }

    @JsonCreator
    @Nullable
    public static PolarisEntitySubType fromCode(int entitySubTypeCode) {
        if (entitySubTypeCode >= REVERSE_MAPPING_ARRAY.length) {
            return null;
        }
        if (entitySubTypeCode >= 0) {
            return REVERSE_MAPPING_ARRAY[entitySubTypeCode];
        }
        for (PolarisEntitySubType entitySubType : PolarisEntitySubType.values()) {
            if (entitySubType.code != entitySubTypeCode) continue;
            return entitySubType;
        }
        return null;
    }

    static {
        int maxId = 0;
        for (PolarisEntitySubType entitySubType : PolarisEntitySubType.values()) {
            if (maxId >= entitySubType.code) continue;
            maxId = entitySubType.code;
        }
        REVERSE_MAPPING_ARRAY = new PolarisEntitySubType[maxId + 1];
        for (PolarisEntitySubType entitySubType : PolarisEntitySubType.values()) {
            if (entitySubType.code < 0) continue;
            PolarisEntitySubType.REVERSE_MAPPING_ARRAY[entitySubType.code] = entitySubType;
        }
    }
}

