/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray.propagator;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class AwsXrayPropagator
implements TextMapPropagator {
    static final String TRACE_HEADER_KEY = "X-Amzn-Trace-Id";
    private static final Logger logger = Logger.getLogger(AwsXrayPropagator.class.getName());
    private static final char TRACE_HEADER_DELIMITER = ';';
    private static final char KV_DELIMITER = '=';
    private static final String TRACE_ID_KEY = "Root";
    private static final int TRACE_ID_LENGTH = 35;
    private static final String TRACE_ID_VERSION = "1";
    private static final char TRACE_ID_DELIMITER = '-';
    private static final int TRACE_ID_DELIMITER_INDEX_1 = 1;
    private static final int TRACE_ID_DELIMITER_INDEX_2 = 10;
    private static final int TRACE_ID_FIRST_PART_LENGTH = 8;
    private static final String PARENT_ID_KEY = "Parent";
    private static final int PARENT_ID_LENGTH = 16;
    private static final String SAMPLED_FLAG_KEY = "Sampled";
    private static final int SAMPLED_FLAG_LENGTH = 1;
    private static final char IS_SAMPLED = '1';
    private static final char NOT_SAMPLED = '0';
    private static final List<String> FIELDS = Collections.singletonList("X-Amzn-Trace-Id");
    private static final AwsXrayPropagator INSTANCE = new AwsXrayPropagator();

    private AwsXrayPropagator() {
    }

    public static AwsXrayPropagator getInstance() {
        return INSTANCE;
    }

    public List<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context == null) {
            return;
        }
        if (setter == null) {
            return;
        }
        Span span = Span.fromContext((Context)context);
        if (!span.getSpanContext().isValid()) {
            return;
        }
        SpanContext spanContext = span.getSpanContext();
        String otTraceId = spanContext.getTraceId();
        String xrayTraceId = "1-" + otTraceId.substring(0, 8) + '-' + otTraceId.substring(8);
        String parentId = spanContext.getSpanId();
        char samplingFlag = spanContext.isSampled() ? (char)'1' : '0';
        final StringBuilder traceHeader = new StringBuilder();
        traceHeader.append(TRACE_ID_KEY).append('=').append(xrayTraceId).append(';').append(PARENT_ID_KEY).append('=').append(parentId).append(';').append(SAMPLED_FLAG_KEY).append('=').append(samplingFlag);
        Baggage baggage = Baggage.fromContext((Context)context);
        baggage.forEach((BiConsumer)new BiConsumer<String, BaggageEntry>(){
            private int baggageWrittenBytes;

            @Override
            public void accept(String key, BaggageEntry entry) {
                if (key.equals(AwsXrayPropagator.TRACE_ID_KEY) || key.equals(AwsXrayPropagator.PARENT_ID_KEY) || key.equals(AwsXrayPropagator.SAMPLED_FLAG_KEY)) {
                    return;
                }
                int size = key.length() + entry.getValue().length() + 1;
                if (this.baggageWrittenBytes + size > 256) {
                    return;
                }
                traceHeader.append(';').append(key).append('=').append(entry.getValue());
                this.baggageWrittenBytes += size;
            }
        });
        setter.set(carrier, TRACE_HEADER_KEY, traceHeader.toString());
    }

    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        if (context == null) {
            return Context.root();
        }
        if (getter == null) {
            return context;
        }
        return AwsXrayPropagator.getContextFromHeader(context, carrier, getter);
    }

    public String toString() {
        return "AwsXrayPropagator";
    }

    private static <C> Context getContextFromHeader(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        SpanContext spanContext;
        String traceHeader = getter.get(carrier, TRACE_HEADER_KEY);
        if (traceHeader == null || traceHeader.isEmpty()) {
            return context;
        }
        String traceId = TraceId.getInvalid();
        String spanId = SpanId.getInvalid();
        Boolean isSampled = false;
        BaggageBuilder baggage = null;
        int baggageReadBytes = 0;
        int pos = 0;
        while (pos < traceHeader.length()) {
            String part;
            int delimiterIndex = traceHeader.indexOf(59, pos);
            if (delimiterIndex >= 0) {
                part = traceHeader.substring(pos, delimiterIndex);
                pos = delimiterIndex + 1;
            } else {
                part = traceHeader.substring(pos);
                pos = traceHeader.length();
            }
            String trimmedPart = part.trim();
            int equalsIndex = trimmedPart.indexOf(61);
            if (equalsIndex < 0) {
                logger.fine("Error parsing X-Ray trace header. Invalid key value pair: " + part);
                return context;
            }
            String value = trimmedPart.substring(equalsIndex + 1);
            if (trimmedPart.startsWith(TRACE_ID_KEY)) {
                traceId = AwsXrayPropagator.parseTraceId(value);
                continue;
            }
            if (trimmedPart.startsWith(PARENT_ID_KEY)) {
                spanId = AwsXrayPropagator.parseSpanId(value);
                continue;
            }
            if (trimmedPart.startsWith(SAMPLED_FLAG_KEY)) {
                isSampled = AwsXrayPropagator.parseTraceFlag(value);
                continue;
            }
            if (baggageReadBytes + trimmedPart.length() > 256) continue;
            if (baggage == null) {
                baggage = Baggage.builder();
            }
            baggage.put(trimmedPart.substring(0, equalsIndex), value);
            baggageReadBytes += trimmedPart.length();
        }
        if (isSampled == null) {
            logger.fine("Invalid Sampling flag in X-Ray trace header: 'X-Amzn-Trace-Id' with value " + traceHeader + "'.");
            return context;
        }
        if (spanId == null || traceId == null) {
            logger.finest("Both traceId and spanId are required to extract a valid span context. ");
        }
        if ((spanContext = SpanContext.createFromRemoteParent((String)StringUtils.padLeft((String)traceId, (int)TraceId.getLength()), (String)spanId, (TraceFlags)(isSampled != false ? TraceFlags.getSampled() : TraceFlags.getDefault()), (TraceState)TraceState.getDefault())).isValid()) {
            context = context.with((ImplicitContextKeyed)Span.wrap((SpanContext)spanContext));
        }
        if (baggage != null) {
            context = context.with((ImplicitContextKeyed)baggage.build());
        }
        return context;
    }

    private static String parseTraceId(String xrayTraceId) {
        return xrayTraceId.length() == 35 ? AwsXrayPropagator.parseSpecTraceId(xrayTraceId) : AwsXrayPropagator.parseShortTraceId(xrayTraceId);
    }

    private static String parseSpecTraceId(String xrayTraceId) {
        if (!xrayTraceId.startsWith(TRACE_ID_VERSION)) {
            return TraceId.getInvalid();
        }
        if (xrayTraceId.charAt(1) != '-' || xrayTraceId.charAt(10) != '-') {
            return TraceId.getInvalid();
        }
        String epochPart = xrayTraceId.substring(2, 10);
        String uniquePart = xrayTraceId.substring(11, 35);
        return epochPart + uniquePart;
    }

    private static String parseShortTraceId(String xrayTraceId) {
        if (xrayTraceId.length() > 35) {
            return TraceId.getInvalid();
        }
        if (!xrayTraceId.startsWith(TRACE_ID_VERSION)) {
            return TraceId.getInvalid();
        }
        int firstDelimiter = xrayTraceId.indexOf(45);
        int secondDelimiter = xrayTraceId.indexOf(45, firstDelimiter + 2);
        if (firstDelimiter != 1 || secondDelimiter == -1 || secondDelimiter > 10 || xrayTraceId.length() < secondDelimiter + 25) {
            return TraceId.getInvalid();
        }
        String epochPart = xrayTraceId.substring(firstDelimiter + 1, secondDelimiter);
        String uniquePart = xrayTraceId.substring(secondDelimiter + 1, secondDelimiter + 25);
        return epochPart + uniquePart;
    }

    private static String parseSpanId(String xrayParentId) {
        if (xrayParentId.length() != 16) {
            return SpanId.getInvalid();
        }
        return xrayParentId;
    }

    @Nullable
    private static Boolean parseTraceFlag(String xraySampledFlag) {
        if (xraySampledFlag.length() != 1) {
            return null;
        }
        char flag = xraySampledFlag.charAt(0);
        if (flag == '1') {
            return true;
        }
        if (flag == '0') {
            return false;
        }
        return null;
    }
}

