/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc;

import java.util.Optional;
import org.apache.polaris.core.persistence.bootstrap.BootstrapOptions;
import org.apache.polaris.core.persistence.bootstrap.SchemaOptions;

public class JdbcBootstrapUtils {
    private JdbcBootstrapUtils() {
    }

    public static int getRealmBootstrapSchemaVersion(int currentSchemaVersion, int requiredSchemaVersion, boolean hasAlreadyBootstrappedRealms) {
        if (currentSchemaVersion == requiredSchemaVersion) {
            return requiredSchemaVersion;
        }
        if (currentSchemaVersion == 0) {
            if (hasAlreadyBootstrappedRealms) {
                if (requiredSchemaVersion == -1 || requiredSchemaVersion == 1) {
                    return 1;
                }
            } else {
                return requiredSchemaVersion == -1 ? 3 : requiredSchemaVersion;
            }
        }
        if (requiredSchemaVersion == -1) {
            return hasAlreadyBootstrappedRealms ? currentSchemaVersion : 3;
        }
        throw new IllegalStateException(String.format("Cannot determine bootstrap schema version. Current: %d, Required: %d, Bootstrapped: %b", currentSchemaVersion, requiredSchemaVersion, hasAlreadyBootstrappedRealms));
    }

    public static int getRequestedSchemaVersion(BootstrapOptions bootstrapOptions) {
        Optional version;
        SchemaOptions schemaOptions = bootstrapOptions.schemaOptions();
        if (schemaOptions != null && (version = schemaOptions.schemaVersion()).isPresent()) {
            return (Integer)version.get();
        }
        return -1;
    }
}

