/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.Schema;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimap;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class MappingUtil {
    private static final Joiner DOT = Joiner.on((char)'.');

    private MappingUtil() {
    }

    public static NameMapping create(Schema schema) {
        return new NameMapping((MappedFields)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)CreateMapping.INSTANCE));
    }

    public static NameMapping update(NameMapping mapping, Map<Integer, Types.NestedField> updates, Multimap<Integer, Integer> adds) {
        return new NameMapping(MappingUtil.visit(mapping, new UpdateMapping(updates, adds)));
    }

    static Map<Integer, MappedField> indexById(MappedFields mapping) {
        return MappingUtil.visit(mapping, new IndexById());
    }

    static Map<String, MappedField> indexByName(MappedFields mapping) {
        return MappingUtil.visit(mapping, IndexByName.INSTANCE);
    }

    private static <S, T> S visit(NameMapping mapping, Visitor<S, T> visitor) {
        return visitor.mapping(mapping, MappingUtil.visit(mapping.asMappedFields(), visitor));
    }

    private static <S, T> S visit(MappedFields mapping, Visitor<S, T> visitor) {
        if (mapping == null) {
            return null;
        }
        ArrayList fieldResults = Lists.newArrayList();
        for (MappedField field : mapping.fields()) {
            fieldResults.add(visitor.field(field, MappingUtil.visit(field.nestedMapping(), visitor)));
        }
        return visitor.fields(mapping, fieldResults);
    }

    private static class CreateMapping
    extends TypeUtil.SchemaVisitor<MappedFields> {
        private static final CreateMapping INSTANCE = new CreateMapping();

        private CreateMapping() {
        }

        public MappedFields schema(Schema schema, MappedFields structResult) {
            return structResult;
        }

        public MappedFields struct(Types.StructType struct, List<MappedFields> fieldResults) {
            ArrayList fields = Lists.newArrayListWithExpectedSize((int)fieldResults.size());
            for (int i = 0; i < fieldResults.size(); ++i) {
                Types.NestedField field = (Types.NestedField)struct.fields().get(i);
                MappedFields result = fieldResults.get(i);
                fields.add(MappedField.of((Integer)field.fieldId(), field.name(), result));
            }
            return MappedFields.of(fields);
        }

        public MappedFields field(Types.NestedField field, MappedFields fieldResult) {
            return fieldResult;
        }

        public MappedFields list(Types.ListType list, MappedFields elementResult) {
            return MappedFields.of(MappedField.of((Integer)list.elementId(), "element", elementResult));
        }

        public MappedFields map(Types.MapType map, MappedFields keyResult, MappedFields valueResult) {
            return MappedFields.of(MappedField.of((Integer)map.keyId(), "key", keyResult), MappedField.of((Integer)map.valueId(), "value", valueResult));
        }

        public MappedFields variant(Types.VariantType variant) {
            return null;
        }

        public MappedFields primitive(Type.PrimitiveType primitive) {
            return null;
        }
    }

    private static class UpdateMapping
    implements Visitor<MappedFields, MappedField> {
        private final Map<Integer, Types.NestedField> updates;
        private final Multimap<Integer, Integer> adds;

        private UpdateMapping(Map<Integer, Types.NestedField> updates, Multimap<Integer, Integer> adds) {
            this.updates = updates;
            this.adds = adds;
        }

        @Override
        public MappedFields mapping(NameMapping mapping, MappedFields result) {
            return this.addNewFields(result, -1);
        }

        @Override
        public MappedFields fields(MappedFields fields, List<MappedField> fieldResults) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            fieldResults.stream().map(MappedField::id).filter(Objects::nonNull).map(this.updates::get).filter(Objects::nonNull).forEach(field -> builder.put((Object)field.name(), (Object)field.fieldId()));
            ImmutableMap updateAssignments = builder.build();
            return MappedFields.of(Lists.transform(fieldResults, arg_0 -> UpdateMapping.lambda$fields$1((Map)updateAssignments, arg_0)));
        }

        @Override
        public MappedField field(MappedField field, MappedFields fieldResult) {
            HashSet fieldNames = Sets.newHashSet(field.names());
            Types.NestedField update = this.updates.get(field.id());
            if (update != null) {
                fieldNames.add(update.name());
            }
            MappedFields nestedMapping = this.addNewFields(fieldResult, field.id());
            return MappedField.of(field.id(), fieldNames, nestedMapping);
        }

        private MappedFields addNewFields(MappedFields mapping, int parentId) {
            Collection fieldsToAdd = this.adds.get((Object)parentId).stream().map(this.updates::get).collect(Collectors.toList());
            if (fieldsToAdd.isEmpty()) {
                return mapping;
            }
            ArrayList newFields = Lists.newArrayList();
            for (Types.NestedField add : fieldsToAdd) {
                MappedFields nestedMapping = (MappedFields)TypeUtil.visit((Type)add.type(), (TypeUtil.SchemaVisitor)CreateMapping.INSTANCE);
                newFields.add(MappedField.of((Integer)add.fieldId(), add.name(), nestedMapping));
            }
            if (mapping == null || mapping.fields().isEmpty()) {
                return MappedFields.of(newFields);
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            fieldsToAdd.forEach(field -> builder.put((Object)field.name(), (Object)field.fieldId()));
            ImmutableMap assignments = builder.build();
            ArrayList fields = Lists.newArrayList();
            for (MappedField field2 : mapping.fields()) {
                fields.add(UpdateMapping.removeReassignedNames(field2, (Map<String, Integer>)assignments));
            }
            fields.addAll(newFields);
            return MappedFields.of(fields);
        }

        private static MappedField removeReassignedNames(MappedField field, Map<String, Integer> assignments) {
            MappedField newField = field;
            for (String name : field.names()) {
                Integer assignedId = assignments.get(name);
                if (assignedId == null || Objects.equals(assignedId, field.id())) continue;
                newField = UpdateMapping.removeName(field, name);
            }
            return newField;
        }

        private static MappedField removeName(MappedField field, String name) {
            return MappedField.of(field.id(), (Iterable<String>)Sets.difference(field.names(), (Set)Sets.newHashSet((Object[])new String[]{name})), field.nestedMapping());
        }

        private static /* synthetic */ MappedField lambda$fields$1(Map updateAssignments, MappedField field) {
            return UpdateMapping.removeReassignedNames(field, updateAssignments);
        }
    }

    private static interface Visitor<S, T> {
        public S mapping(NameMapping var1, S var2);

        public S fields(MappedFields var1, List<T> var2);

        public T field(MappedField var1, S var2);
    }

    private static class IndexById
    implements Visitor<Map<Integer, MappedField>, Map<Integer, MappedField>> {
        private final Map<Integer, MappedField> result = Maps.newHashMap();

        private IndexById() {
        }

        @Override
        public Map<Integer, MappedField> mapping(NameMapping mapping, Map<Integer, MappedField> fieldsResult) {
            return fieldsResult;
        }

        @Override
        public Map<Integer, MappedField> fields(MappedFields fields, List<Map<Integer, MappedField>> fieldResults) {
            return this.result;
        }

        @Override
        public Map<Integer, MappedField> field(MappedField field, Map<Integer, MappedField> fieldResult) {
            Preconditions.checkState((!this.result.containsKey(field.id()) ? 1 : 0) != 0, (String)"Invalid mapping: ID %s is not unique", (Object)field.id());
            this.result.put(field.id(), field);
            return this.result;
        }
    }

    private static class IndexByName
    implements Visitor<Map<String, MappedField>, Map<String, MappedField>> {
        static final IndexByName INSTANCE = new IndexByName();

        private IndexByName() {
        }

        @Override
        public Map<String, MappedField> mapping(NameMapping mapping, Map<String, MappedField> result) {
            return result;
        }

        @Override
        public Map<String, MappedField> fields(MappedFields fields, List<Map<String, MappedField>> fieldResults) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map<String, MappedField> results : fieldResults) {
                builder.putAll(results);
            }
            return builder.build();
        }

        @Override
        public Map<String, MappedField> field(MappedField field, Map<String, MappedField> fieldResult) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (fieldResult != null) {
                for (String name : field.names()) {
                    for (Map.Entry<String, MappedField> entry : fieldResult.entrySet()) {
                        String fullName = DOT.join((Object)name, (Object)entry.getKey(), new Object[0]);
                        builder.put((Object)fullName, (Object)entry.getValue());
                    }
                }
            }
            for (String name : field.names()) {
                builder.put((Object)name, (Object)field);
            }
            return builder.build();
        }
    }
}

