/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.internal.broker;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import org.apache.polaris.service.auth.PolarisCredential;
import org.apache.polaris.service.auth.internal.broker.InternalPolarisToken;
import org.apache.polaris.service.auth.internal.broker.TokenBroker;
import org.apache.polaris.service.auth.internal.broker.TokenRequestValidator;
import org.apache.polaris.service.auth.internal.broker.TokenResponse;
import org.apache.polaris.service.auth.internal.service.OAuthError;
import org.apache.polaris.service.types.TokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JWTBroker
implements TokenBroker {
    private static final Logger LOGGER = LoggerFactory.getLogger(JWTBroker.class);
    private static final String ISSUER_KEY = "polaris";
    private static final String CLAIM_KEY_ACTIVE = "active";
    private static final String CLAIM_KEY_CLIENT_ID = "client_id";
    private static final String CLAIM_KEY_PRINCIPAL_ID = "principalId";
    private static final String CLAIM_KEY_SCOPE = "scope";
    private final PolarisMetaStoreManager metaStoreManager;
    private final int maxTokenGenerationInSeconds;

    JWTBroker(PolarisMetaStoreManager metaStoreManager, int maxTokenGenerationInSeconds) {
        this.metaStoreManager = metaStoreManager;
        this.maxTokenGenerationInSeconds = maxTokenGenerationInSeconds;
    }

    public abstract Algorithm getAlgorithm();

    @Override
    public PolarisCredential verify(String token) {
        return this.verifyInternal(token);
    }

    private InternalPolarisToken verifyInternal(String token) {
        JWTVerifier verifier = JWT.require((Algorithm)this.getAlgorithm()).withClaim(CLAIM_KEY_ACTIVE, Boolean.valueOf(true)).build();
        try {
            DecodedJWT decodedJWT = verifier.verify(token);
            return InternalPolarisToken.of(decodedJWT.getSubject(), decodedJWT.getClaim(CLAIM_KEY_PRINCIPAL_ID).asLong(), decodedJWT.getClaim(CLAIM_KEY_CLIENT_ID).asString(), decodedJWT.getClaim(CLAIM_KEY_SCOPE).asString());
        }
        catch (Exception e) {
            throw (NotAuthorizedException)new NotAuthorizedException("Failed to verify the token", new Object[0]).initCause((Throwable)e);
        }
    }

    @Override
    public TokenResponse generateFromToken(TokenType subjectTokenType, String subjectToken, String grantType, String scope, PolarisCallContext polarisCallContext, TokenType requestedTokenType) {
        InternalPolarisToken decodedToken;
        if (requestedTokenType != null && !TokenType.ACCESS_TOKEN.equals((Object)requestedTokenType)) {
            return TokenResponse.of(OAuthError.invalid_request);
        }
        if (!TokenType.ACCESS_TOKEN.equals((Object)subjectTokenType)) {
            return TokenResponse.of(OAuthError.invalid_request);
        }
        if (subjectToken == null || subjectToken.isBlank()) {
            return TokenResponse.of(OAuthError.invalid_request);
        }
        try {
            decodedToken = this.verifyInternal(subjectToken);
        }
        catch (NotAuthorizedException e) {
            LOGGER.error("Failed to verify the token", e.getCause());
            return TokenResponse.of(OAuthError.invalid_client);
        }
        EntityResult principalLookup = this.metaStoreManager.loadEntity(polarisCallContext, 0L, decodedToken.getPrincipalId().longValue(), PolarisEntityType.PRINCIPAL);
        if (!principalLookup.isSuccess() || principalLookup.getEntity().getType() != PolarisEntityType.PRINCIPAL) {
            return TokenResponse.of(OAuthError.unauthorized_client);
        }
        String tokenString = this.generateTokenString(decodedToken.getPrincipalName(), decodedToken.getPrincipalId(), decodedToken.getClientId(), decodedToken.getScope());
        return TokenResponse.of(tokenString, TokenType.ACCESS_TOKEN.getValue(), this.maxTokenGenerationInSeconds);
    }

    @Override
    public TokenResponse generateFromClientSecrets(String clientId, String clientSecret, String grantType, String scope, PolarisCallContext polarisCallContext, TokenType requestedTokenType) {
        TokenRequestValidator validator = new TokenRequestValidator();
        Optional<OAuthError> initialValidationResponse = validator.validateForClientCredentialsFlow(clientId, clientSecret, grantType, scope);
        if (initialValidationResponse.isPresent()) {
            return TokenResponse.of(initialValidationResponse.get());
        }
        Optional<PrincipalEntity> principal = this.findPrincipalEntity(clientId, clientSecret, polarisCallContext);
        if (principal.isEmpty()) {
            return TokenResponse.of(OAuthError.unauthorized_client);
        }
        String tokenString = this.generateTokenString(principal.get().getName(), principal.get().getId(), clientId, scope);
        return TokenResponse.of(tokenString, TokenType.ACCESS_TOKEN.getValue(), this.maxTokenGenerationInSeconds);
    }

    private String generateTokenString(String principalName, long principalId, String clientId, String scope) {
        Instant now = Instant.now();
        return JWT.create().withIssuer(ISSUER_KEY).withSubject(principalName).withIssuedAt(now).withExpiresAt(now.plus((long)this.maxTokenGenerationInSeconds, ChronoUnit.SECONDS)).withJWTId(UUID.randomUUID().toString()).withClaim(CLAIM_KEY_ACTIVE, Boolean.valueOf(true)).withClaim(CLAIM_KEY_CLIENT_ID, clientId).withClaim(CLAIM_KEY_PRINCIPAL_ID, Long.valueOf(principalId)).withClaim(CLAIM_KEY_SCOPE, this.scopes(scope)).sign(this.getAlgorithm());
    }

    @Override
    public boolean supportsGrantType(String grantType) {
        return TokenRequestValidator.ALLOWED_GRANT_TYPES.contains(grantType);
    }

    @Override
    public boolean supportsRequestedTokenType(TokenType tokenType) {
        return tokenType == null || TokenType.ACCESS_TOKEN.equals((Object)tokenType);
    }

    private String scopes(String scope) {
        return scope == null || scope.isBlank() ? "PRINCIPAL_ROLE:ALL" : scope;
    }

    private Optional<PrincipalEntity> findPrincipalEntity(String clientId, String clientSecret, PolarisCallContext polarisCallContext) {
        PrincipalSecretsResult principalSecrets = this.metaStoreManager.loadPrincipalSecrets(polarisCallContext, clientId);
        if (!principalSecrets.isSuccess()) {
            return Optional.empty();
        }
        if (!principalSecrets.getPrincipalSecrets().matchesSecret(clientSecret)) {
            return Optional.empty();
        }
        EntityResult result = this.metaStoreManager.loadEntity(polarisCallContext, 0L, principalSecrets.getPrincipalSecrets().getPrincipalId(), PolarisEntityType.PRINCIPAL);
        if (!result.isSuccess() || result.getEntity().getType() != PolarisEntityType.PRINCIPAL) {
            return Optional.empty();
        }
        return Optional.of(PrincipalEntity.of((PolarisBaseEntity)result.getEntity()));
    }
}

