/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.ratelimiter;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.apache.polaris.service.events.BeforeLimitRequestRateEvent;
import org.apache.polaris.service.events.listeners.PolarisEventListener;
import org.apache.polaris.service.ratelimiter.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
@Priority(value=5000)
@ApplicationScoped
public class RateLimiterFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RateLimiterFilter.class);
    private final RateLimiter rateLimiter;
    private final PolarisEventListener polarisEventListener;

    @Inject
    public RateLimiterFilter(RateLimiter rateLimiter, PolarisEventListener polarisEventListener) {
        this.rateLimiter = rateLimiter;
        this.polarisEventListener = polarisEventListener;
    }

    public void filter(ContainerRequestContext ctx) throws IOException {
        if (!this.rateLimiter.canProceed()) {
            this.polarisEventListener.onBeforeLimitRequestRate(new BeforeLimitRequestRateEvent(ctx.getMethod(), ctx.getUriInfo().getAbsolutePath().toString()));
            ctx.abortWith(Response.status((Response.Status)Response.Status.TOO_MANY_REQUESTS).build());
            LOGGER.atDebug().log("Rate limiting request");
        }
    }
}

